/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.build.tools.messages;

import com.unboundid.build.tools.messages.MessageDescriptorDeclaration;
import com.unboundid.build.tools.messages.MessagePropertyKey;
import com.unboundid.messages.Category;
import com.unboundid.messages.Severity;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class GenerateMessagesFile
extends Task {
    public static final String EOL = System.getProperty("line.separator");
    protected static final String GLOBAL_CATEGORY = "global.category";
    protected static final String GLOBAL_SEVERITY = "global.severity";
    protected static final String GLOBAL_CATEGORY_MASK = "global.mask";
    protected static final String GLOBAL_ORDINAL = "global.ordinal";
    protected static final Set<String> DIRECTIVE_PROPERTIES = new HashSet<String>();
    public static String KEY_FORM_MSG;
    protected File source;
    protected File destSourceFile;
    protected File productFile;
    private File stubFile;
    protected String tokenReplacerArg;
    protected boolean overwrite;
    protected String sourceExtension;

    public static String indent(int indent) {
        char[] blankArray = new char[2 * indent];
        Arrays.fill(blankArray, ' ');
        return new String(blankArray);
    }

    protected GenerateMessagesFile(String sourceExtension) {
        this.sourceExtension = sourceExtension;
    }

    protected abstract void createProductPropertiesSourceFile(File var1) throws IOException;

    protected abstract String getDescriptorString(MessageDescriptorDeclaration var1);

    protected abstract void postProcess() throws Exception;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        BufferedReader stubReader = null;
        PrintWriter destWriter = null;
        try {
            File destDir = this.destSourceFile.getParentFile();
            if (!destDir.exists()) {
                destDir.mkdirs();
            }
            File productDestFile = new File(destDir, "ProductProperties." + this.sourceExtension);
            if (!(this.productFile == null || productDestFile.exists() && this.productFile.lastModified() <= productDestFile.lastModified())) {
                this.createProductPropertiesSourceFile(productDestFile);
            }
            if (!this.source.exists()) {
                throw new BuildException("file " + this.source.getName() + " does not exist");
            }
            if (this.destSourceFile.exists()) {
                if (!this.overwrite && this.source.lastModified() <= this.destSourceFile.lastModified()) {
                    this.log(this.destSourceFile.getName() + " is up to date");
                    return;
                }
                this.destSourceFile.delete();
                this.log("Regenerating " + this.destSourceFile.getName() + " from " + this.source.getName());
            } else {
                File genDir = this.destSourceFile.getParentFile();
                if (!genDir.exists()) {
                    genDir.mkdirs();
                }
                this.log("Generating " + this.destSourceFile.getName() + " from " + this.source.getName());
            }
            stubReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.getStubFile()), "UTF-8"));
            destWriter = new PrintWriter(this.destSourceFile, "UTF-8");
            Properties properties = new Properties();
            properties.load(new FileInputStream(this.source));
            while (true) {
                Iterator<Object> i$;
                TreeMap<MessagePropertyKey, String> keyMap;
                Severity globalSeverity;
                Category globalCategory;
                Integer globalMask;
                Integer globalOrdinal;
                block48: {
                    String stubLine;
                    if (null != (stubLine = stubReader.readLine())) {
                        if (stubLine.contains("${MESSAGES}")) {
                            globalOrdinal = null;
                            String go = properties.getProperty(GLOBAL_ORDINAL);
                            if (go != null) {
                                globalOrdinal = new Integer(go);
                            }
                            globalMask = null;
                            globalCategory = null;
                            String gms = properties.getProperty(GLOBAL_CATEGORY_MASK);
                            if (gms != null) {
                                globalMask = Integer.parseInt(gms);
                                globalCategory = Category.USER_DEFINED;
                            } else {
                                String gcs = properties.getProperty(GLOBAL_CATEGORY);
                                if (gcs != null) {
                                    globalCategory = Category.valueOf(gcs);
                                }
                            }
                            globalSeverity = null;
                            String gss = properties.getProperty(GLOBAL_SEVERITY);
                            if (gss != null) {
                                globalSeverity = Severity.parseString(gss);
                            }
                            keyMap = new TreeMap<MessagePropertyKey, String>();
                            i$ = properties.keySet().iterator();
                            break block48;
                        } else {
                            stubLine = this.replaceVars(stubLine);
                            destWriter.println(stubLine);
                            continue;
                        }
                    }
                    this.postProcess();
                    stubReader.close();
                    destWriter.close();
                    return;
                }
                while (i$.hasNext()) {
                    Object propO = i$.next();
                    String propKey = propO.toString();
                    try {
                        if (DIRECTIVE_PROPERTIES.contains(propKey)) continue;
                        MessagePropertyKey key = MessagePropertyKey.parseString(propKey, globalCategory == null, globalSeverity == null, globalOrdinal == null);
                        String formatString = properties.getProperty(propKey);
                        keyMap.put(key, formatString);
                    }
                    catch (IllegalArgumentException iae) {
                        throw new BuildException("ERROR: invalid property key: " + EOL + "   ----------->  " + propKey + "  <-----------" + EOL + "because: " + iae.getMessage() + KEY_FORM_MSG);
                    }
                }
                int usesOfGenericDescriptor = 0;
                Category firstCategory = null;
                HashSet<Integer> usedOrdinals = new HashSet<Integer>();
                for (MessagePropertyKey key : keyMap.keySet()) {
                    Severity s;
                    Category c;
                    String formatString = (String)keyMap.get(key);
                    Category category = c = globalCategory != null ? globalCategory : key.getCategory();
                    if (firstCategory != null) {
                        if (!firstCategory.equals((Object)c)) {
                            this.log("WARNING: multiple categories defined in " + this.source);
                        }
                    } else {
                        firstCategory = c;
                    }
                    Severity severity = s = globalSeverity != null ? globalSeverity : key.getSeverity();
                    if (c == null) {
                        throw new BuildException("No category could be assigned to message " + key + ".  The category " + "must either be encoded in the property key or " + "or must be set by including the property " + GLOBAL_CATEGORY + " in the properties file" + KEY_FORM_MSG);
                    }
                    if (c == null) {
                        throw new BuildException("No severity could be assigned to message " + key + ".  The severity " + "must either be encoded in the property key or " + "or must be set by including the property " + GLOBAL_SEVERITY + " in the properties file" + KEY_FORM_MSG);
                    }
                    if (globalOrdinal == null) {
                        Integer ordinal = key.getOrdinal();
                        if (usedOrdinals.contains(ordinal)) {
                            throw new BuildException("The ordinal value '" + ordinal + "' in key " + key + " has been previously defined in " + this.source + KEY_FORM_MSG);
                        }
                        usedOrdinals.add(ordinal);
                    }
                    MessageDescriptorDeclaration message = new MessageDescriptorDeclaration(key, formatString, globalMask != null ? globalMask.toString() : c.name(), s.name(), globalOrdinal != null ? globalOrdinal.toString() : key.getOrdinal().toString(), "null", this.tokenReplacerArg != null ? this.tokenReplacerArg : "null");
                    destWriter.println(this.getDescriptorString(message));
                    destWriter.println();
                    if (!message.useGenericMessageTypeClass()) continue;
                    ++usesOfGenericDescriptor;
                }
                this.log("  Message Generated:" + keyMap.size(), 3);
                this.log("  Generic Descriptor Usages:" + usesOfGenericDescriptor, 3);
            }
        }
        catch (Exception e) {
            if (this.destSourceFile.exists()) {
                this.destSourceFile.deleteOnExit();
            }
            e.printStackTrace();
            throw new BuildException("Error processing " + this.source + ":  " + e.getMessage());
        }
        finally {
            if (stubReader != null) {
                try {
                    stubReader.close();
                }
                catch (Exception e) {}
            }
            if (destWriter != null) {
                try {
                    destWriter.close();
                }
                catch (Exception e) {}
            }
        }
    }

    protected String replaceVars(String line) {
        line = line.replace("${PACKAGE}", this.getPackage());
        line = line.replace("${CLASS_NAME}", this.destSourceFile.getName().substring(0, this.destSourceFile.getName().length() - (this.sourceExtension.length() + 1)));
        line = line.replace("${BASE}", this.getBase());
        return line;
    }

    public void setStubFile(File stubFile) {
        this.stubFile = stubFile;
    }

    public void setTokenReplacer(String tokenReplacerArg) {
        this.tokenReplacerArg = tokenReplacerArg;
    }

    public void setSourceProps(File source) {
        this.source = source;
    }

    public void setDestSourceCodeFile(File dest) {
        this.destSourceFile = dest;
    }

    public void setProductFile(File productFile) {
        this.productFile = productFile;
    }

    public void setOverwrite(boolean o) {
        this.overwrite = o;
    }

    protected String getMessageDescriptorFullClassName() {
        return this.getPackage() + "." + this.getMessageDescriptorClassName();
    }

    private String getMessageDescriptorClassName() {
        return this.destSourceFile.getName().substring(0, this.destSourceFile.getName().length() - (this.sourceExtension.length() + 1));
    }

    protected String getBase() {
        String srcPath = this.unixifyPath(this.source.getAbsolutePath());
        String base = srcPath.substring(srcPath.lastIndexOf("messages/"));
        if (base.endsWith(".properties")) {
            base = base.substring(0, base.length() - ".properties".length());
        }
        return base;
    }

    protected String getPackage() {
        String destPath = this.unixifyPath(this.destSourceFile.getAbsolutePath());
        String c = destPath.substring(destPath.indexOf("com/unboundid"));
        c = c.replace('/', '.');
        c = c.substring(0, c.lastIndexOf("."));
        c = c.substring(0, c.lastIndexOf("."));
        return c;
    }

    protected String fileNameWithoutExtension(File file) {
        String name = file.getName();
        return name.substring(0, name.lastIndexOf("."));
    }

    private String unixifyPath(String path) {
        return path.replace("\\", "/");
    }

    protected File getStubFile() {
        if (this.stubFile == null) {
            throw new IllegalStateException("stubFile not specified");
        }
        return this.stubFile;
    }

    static {
        DIRECTIVE_PROPERTIES.add(GLOBAL_CATEGORY);
        DIRECTIVE_PROPERTIES.add(GLOBAL_CATEGORY_MASK);
        DIRECTIVE_PROPERTIES.add(GLOBAL_SEVERITY);
        DIRECTIVE_PROPERTIES.add(GLOBAL_ORDINAL);
        KEY_FORM_MSG = ".\n\nUnboundID message property keys must be of the form\n\n" + "\t'[CATEGORY]_[SEVERITY]_[DESCRIPTION]_[ORDINAL]'\n\n" + "where\n\n" + "CATEGORY is one of " + EnumSet.allOf(Category.class) + "\n\nSEVERITY is one of " + Severity.getPropertyKeyFormSet().toString() + "\n\nDESCRIPTION is a descriptive string composed " + "of uppercase character, digits and underscores " + "describing the purpose of the message " + "\n\nORDINAL is an integer between 0 and 65535 that is " + "unique to other messages defined in this file.\n\n" + "You can relax the mandate for including the CATEGORY, " + "SEVERITY, and/or ORDINAL by including one or more " + "of the following respective property directives in your " + "properties file:  " + GLOBAL_CATEGORY + ", " + GLOBAL_SEVERITY + ", " + GLOBAL_ORDINAL + "and setting their value appropriately.";
    }
}

