/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.messages;

import com.unboundid.messages.Message;
import com.unboundid.messages.MessageDescriptor;
import com.unboundid.messages.MessageUtils;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public final class MessageBuilder
implements Appendable,
CharSequence,
Serializable {
    private static final long serialVersionUID = -3292823563904285315L;
    private static final String EOL = System.getProperty("line.separator");
    private final boolean allowDuplicates;
    private final StringBuilder sb = new StringBuilder();
    private final List<Message> messages = new LinkedList<Message>();
    private final Locale locale;

    public MessageBuilder() {
        this(Locale.getDefault(), true);
    }

    public MessageBuilder(boolean allowDuplicates) {
        this(Locale.getDefault(), allowDuplicates);
    }

    public MessageBuilder(Message message) {
        this(Locale.getDefault(), true);
        this.append(message);
    }

    public MessageBuilder(String message) {
        this(Locale.getDefault(), true);
        this.append(message);
    }

    public MessageBuilder(MessageBuilder mb) {
        for (Message msg : mb.messages) {
            this.messages.add(msg);
        }
        this.sb.append((CharSequence)this.sb);
        this.locale = mb.locale;
        this.allowDuplicates = true;
    }

    public MessageBuilder(Locale locale) {
        this(locale, true);
    }

    public MessageBuilder(Locale locale, boolean allowDuplicates) {
        this.locale = locale;
        this.allowDuplicates = allowDuplicates;
    }

    public MessageBuilder append(Message message, CharSequence delimiter) {
        if (message != null) {
            if (delimiter != null && !this.messages.isEmpty()) {
                this.append(delimiter);
            }
            this.append(message);
        }
        return this;
    }

    public MessageBuilder append(int number) {
        this.append(String.valueOf(number));
        return this;
    }

    public MessageBuilder append(Object object) {
        if (object != null) {
            this.append(String.valueOf(object));
        }
        return this;
    }

    @Override
    public MessageBuilder append(CharSequence cs) {
        if (cs != null) {
            if (cs instanceof Message) {
                int id;
                Message m = (Message)cs;
                if (!this.allowDuplicates && !this.messages.isEmpty() && (id = m.getDescriptor().getId()) >= 0) {
                    for (Message existingMessage : this.messages) {
                        int existingID = existingMessage.getDescriptor().getId();
                        if (id != existingID) continue;
                        return this;
                    }
                }
                this.sb.append(cs);
                this.messages.add(m);
            } else if (cs instanceof MessageBuilder) {
                MessageBuilder mb = (MessageBuilder)cs;
                for (Message m : mb.messages) {
                    this.append(m);
                }
            } else {
                this.sb.append(cs);
                this.messages.add(Message.raw(cs, new Object[0]));
            }
        }
        return this;
    }

    @Override
    public MessageBuilder append(CharSequence csq, int start, int end) throws IndexOutOfBoundsException {
        return this.append(csq.subSequence(start, end));
    }

    @Override
    public MessageBuilder append(char c) {
        return this.append(String.valueOf(c));
    }

    public MessageBuilder appendSentence(CharSequence msg) {
        if (msg != null) {
            Message m;
            String s;
            this.punctuate();
            if (!this.messages.isEmpty() && (s = (m = this.messages.get(this.messages.size() - 1)).toString()).length() == s.trim().length()) {
                this.append(" ");
            }
            return this.append(msg);
        }
        return this;
    }

    public MessageBuilder appendParagraph(CharSequence msg) {
        if (msg != null) {
            if (!this.messages.isEmpty()) {
                this.punctuate();
                this.newLine().newLine();
            }
            return this.append(msg);
        }
        return this;
    }

    public MessageBuilder newLine() {
        return this.append(EOL);
    }

    public MessageBuilder punctuate() {
        Message m;
        String s;
        if (!this.messages.isEmpty() && (s = (m = this.messages.get(this.messages.size() - 1)).toString()).length() == s.trim().length() && !MessageUtils.hasEndPunctuation(s)) {
            this.append(".");
        }
        return this;
    }

    @Override
    public String toString() {
        return this.sb.toString();
    }

    public String toString(Locale locale) {
        StringBuilder sb = new StringBuilder();
        for (Message m : this.messages) {
            sb.append(m.toString(locale));
        }
        return sb.toString();
    }

    public Message toMessage() {
        switch (this.messages.size()) {
            case 0: {
                return Message.EMPTY;
            }
            case 1: {
                return this.messages.get(0);
            }
        }
        StringBuilder fmtString = new StringBuilder();
        MessageDescriptor md = this.messages.get(0).getDescriptor();
        for (Message m : this.messages) {
            fmtString.append("%s");
            if (m.getDescriptor().getSeverity().getMask() <= md.getSeverity().getMask()) continue;
            md = m.getDescriptor();
        }
        return Message.raw(md, fmtString, this.messages.toArray());
    }

    public void clear() {
        this.messages.clear();
        this.sb.setLength(0);
    }

    @Override
    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    @Override
    public int length() {
        if (this.messages.isEmpty()) {
            return 0;
        }
        return this.length(Locale.getDefault());
    }

    @Override
    public char charAt(int index) throws IndexOutOfBoundsException {
        return this.charAt(Locale.getDefault(), index);
    }

    @Override
    public CharSequence subSequence(int start, int end) throws IndexOutOfBoundsException {
        return this.subSequence(Locale.getDefault(), start, end);
    }

    public int length(Locale locale) {
        return this.toString(locale).length();
    }

    public char charAt(Locale locale, int index) throws IndexOutOfBoundsException {
        return this.toString(locale).charAt(index);
    }

    public CharSequence subSequence(Locale locale, int start, int end) throws IndexOutOfBoundsException {
        return this.toString(locale).subSequence(start, end);
    }
}

