/*
 * Decompiled with CFR 0.152.
 */
package scim.schemas.core.v1;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import scim.schemas.core.v1.Address;
import scim.schemas.core.v1.ExtensionEnterprise;
import scim.schemas.core.v1.Meta;
import scim.schemas.core.v1.MultiValuedAttribute;
import scim.schemas.core.v1.Name;
import scim.schemas.core.v1.Resource;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="User", propOrder={"userName", "name", "displayName", "nickName", "profileUrl", "title", "userType", "preferredLanguage", "locale", "timezone", "active", "password", "emails", "phoneNumbers", "ims", "photos", "addresses", "groups", "entitlements", "roles", "x509Certificates", "enterprise"})
public class User
extends Resource
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 201112191537L;
    private String userName;
    private Name name;
    private String displayName;
    private String nickName;
    private String profileUrl;
    private String title;
    private String userType;
    private String preferredLanguage;
    private String locale;
    private String timezone;
    private Boolean active;
    private String password;
    private List<MultiValuedAttribute> emails;
    private List<MultiValuedAttribute> phoneNumbers;
    private List<MultiValuedAttribute> ims;
    private List<MultiValuedAttribute> photos;
    private List<Address> addresses;
    private List<MultiValuedAttribute> groups;
    private List<MultiValuedAttribute> entitlements;
    private List<MultiValuedAttribute> roles;
    private List<MultiValuedAttribute> x509Certificates;
    @XmlElement(name="urn:scim:schemas:extension:enterprise:1.0")
    private ExtensionEnterprise enterprise;
    @XmlTransient
    private Map<String, String> phoneByType = null;

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String value) {
        this.userName = value;
    }

    public Name getName() {
        return this.name;
    }

    public void setName(Name value) {
        this.name = value;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String value) {
        this.displayName = value;
    }

    public String getNickName() {
        return this.nickName;
    }

    public void setNickName(String value) {
        this.nickName = value;
    }

    public String getProfileUrl() {
        return this.profileUrl;
    }

    public void setProfileUrl(String value) {
        this.profileUrl = value;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String value) {
        this.userType = value;
    }

    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    public void setPreferredLanguage(String value) {
        this.preferredLanguage = value;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String value) {
        this.locale = value;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String value) {
        this.timezone = value;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String value) {
        this.password = value;
    }

    public List<MultiValuedAttribute> getEmails() {
        return this.emails;
    }

    public void setEmails(List<MultiValuedAttribute> value) {
        this.emails = value;
    }

    public List<MultiValuedAttribute> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public void setPhoneNumbers(List<MultiValuedAttribute> value) {
        this.phoneNumbers = value;
    }

    public List<MultiValuedAttribute> getIms() {
        return this.ims;
    }

    public void setIms(List<MultiValuedAttribute> value) {
        this.ims = value;
    }

    public List<MultiValuedAttribute> getPhotos() {
        return this.photos;
    }

    public void setPhotos(List<MultiValuedAttribute> value) {
        this.photos = value;
    }

    public List<Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<Address> value) {
        this.addresses = value;
    }

    public List<MultiValuedAttribute> getGroups() {
        return this.groups;
    }

    public void setGroups(List<MultiValuedAttribute> value) {
        this.groups = value;
    }

    public List<MultiValuedAttribute> getEntitlements() {
        return this.entitlements;
    }

    public void setEntitlements(List<MultiValuedAttribute> value) {
        this.entitlements = value;
    }

    public List<MultiValuedAttribute> getRoles() {
        return this.roles;
    }

    public void setRoles(List<MultiValuedAttribute> value) {
        this.roles = value;
    }

    public String toString() {
        return "User [userName=" + this.userName + ", name=" + this.name + ", displayName=" + this.displayName + ", nickName=" + this.nickName + ", profileUrl=" + this.profileUrl + ", title=" + this.title + ", userType=" + this.userType + ", preferredLanguage=" + this.preferredLanguage + ", locale=" + this.locale + ", timezone=" + this.timezone + ", active=" + this.active + ", password=*****" + ", emails=" + this.emails + ", phoneNumbers=" + this.phoneNumbers + ", ims=" + this.ims + ", photos=" + this.photos + ", addresses=" + this.addresses + ", groups=" + this.groups + ", entitlements=" + this.entitlements + ", roles=" + this.roles + ", x509Certificates=" + this.x509Certificates + "]";
    }

    public List<MultiValuedAttribute> getX509Certificates() {
        return this.x509Certificates;
    }

    public void setX509Certificates(List<MultiValuedAttribute> x509Certificates) {
        this.x509Certificates = x509Certificates;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Map<String, String> getPhoneByType() {
        if (this.phoneByType == null) {
            this.phoneByType = new HashMap<String, String>();
            if (this.getPhoneNumbers() != null) {
                for (MultiValuedAttribute phone : this.getPhoneNumbers()) {
                    if (phone.getType() == null || phone.getValue() == null) continue;
                    this.phoneByType.put(phone.getType(), phone.getValue());
                }
            }
        }
        return this.phoneByType;
    }

    public boolean isActive() {
        return this.getActive() == null || this.getActive() != false;
    }

    private User(Builder builder) {
        this.userName = builder.userName;
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.nickName = builder.nickName;
        this.profileUrl = builder.profileUrl;
        this.title = builder.title;
        this.userType = builder.userType;
        this.preferredLanguage = builder.preferredLanguage;
        this.locale = builder.locale;
        this.timezone = builder.timezone;
        this.active = builder.active;
        this.password = builder.password;
        this.emails = builder.emails;
        this.phoneNumbers = builder.phoneNumbers;
        this.ims = builder.ims;
        this.photos = builder.photos;
        this.addresses = builder.addresses;
        this.groups = builder.groups;
        this.entitlements = builder.entitlements;
        this.roles = builder.roles;
        this.x509Certificates = builder.x509Certificates;
        this.phoneByType = builder.phoneByType;
        this.meta = builder.meta;
        this.id = builder.id;
        this.externalId = builder.externalId;
        this.map = builder.map;
    }

    public User() {
    }

    public User(User user) {
        this.userName = user.userName;
        this.name = user.name;
        this.displayName = user.displayName;
        this.nickName = user.nickName;
        this.profileUrl = user.profileUrl;
        this.title = user.title;
        this.userType = user.userType;
        this.preferredLanguage = user.preferredLanguage;
        this.locale = user.locale;
        this.timezone = user.timezone;
        this.active = user.active;
        this.password = user.password;
        this.emails = user.emails;
        this.phoneNumbers = user.phoneNumbers;
        this.ims = user.ims;
        this.photos = user.photos;
        this.addresses = user.addresses;
        this.groups = user.groups;
        this.entitlements = user.entitlements;
        this.roles = user.roles;
        this.x509Certificates = user.x509Certificates;
        this.phoneByType = user.phoneByType;
        this.meta = user.meta;
        this.id = user.id;
        this.externalId = user.externalId;
        this.map = user.map;
    }

    public ExtensionEnterprise getEnterprise() {
        return this.enterprise;
    }

    public void setEnterprise(ExtensionEnterprise enterprise) {
        this.enterprise = enterprise;
    }

    public User clone() {
        User user = new User();
        user.userName = this.userName;
        user.name = this.name;
        user.displayName = this.displayName;
        user.nickName = this.nickName;
        user.profileUrl = this.profileUrl;
        user.title = this.title;
        user.userType = this.userType;
        user.preferredLanguage = this.preferredLanguage;
        user.locale = this.locale;
        user.timezone = this.timezone;
        user.active = this.active;
        user.password = this.password;
        user.emails = this.emails;
        user.phoneNumbers = this.phoneNumbers;
        user.ims = this.ims;
        user.photos = this.photos;
        user.addresses = this.addresses;
        user.groups = this.groups;
        user.entitlements = this.entitlements;
        user.roles = this.roles;
        user.x509Certificates = this.x509Certificates;
        user.phoneByType = this.phoneByType;
        user.meta = this.meta;
        user.id = this.id;
        user.externalId = this.externalId;
        user.map = this.map;
        return user;
    }

    public static class Builder {
        private String userName;
        private Name name;
        private String displayName;
        private String nickName;
        private String profileUrl;
        private String title;
        private String userType;
        private String preferredLanguage;
        private String locale;
        private String timezone;
        private Boolean active;
        private String password;
        private List<MultiValuedAttribute> emails;
        private List<MultiValuedAttribute> phoneNumbers;
        private List<MultiValuedAttribute> ims;
        private List<MultiValuedAttribute> photos;
        private List<Address> addresses;
        private List<MultiValuedAttribute> groups;
        private List<MultiValuedAttribute> entitlements;
        private List<MultiValuedAttribute> roles;
        private List<MultiValuedAttribute> x509Certificates;
        private Map<String, String> phoneByType;
        private Meta meta;
        private String id;
        private String externalId;
        private Map<String, Object> map;

        public Builder meta(Meta meta) {
            this.meta = meta;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public Builder map(Map<String, Object> map) {
            this.map = map;
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public Builder name(Name name) {
            this.name = name;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder nickName(String nickName) {
            this.nickName = nickName;
            return this;
        }

        public Builder profileUrl(String profileUrl) {
            this.profileUrl = profileUrl;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder userType(String userType) {
            this.userType = userType;
            return this;
        }

        public Builder preferredLanguage(String preferredLanguage) {
            this.preferredLanguage = preferredLanguage;
            return this;
        }

        public Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder emails(List<MultiValuedAttribute> emails) {
            this.emails = emails;
            return this;
        }

        public Builder phoneNumbers(List<MultiValuedAttribute> phoneNumbers) {
            this.phoneNumbers = phoneNumbers;
            return this;
        }

        public Builder ims(List<MultiValuedAttribute> ims) {
            this.ims = ims;
            return this;
        }

        public Builder photos(List<MultiValuedAttribute> photos) {
            this.photos = photos;
            return this;
        }

        public Builder addresses(List<Address> addresses) {
            this.addresses = addresses;
            return this;
        }

        public Builder groups(List<MultiValuedAttribute> groups) {
            this.groups = groups;
            return this;
        }

        public Builder entitlements(List<MultiValuedAttribute> entitlements) {
            this.entitlements = entitlements;
            return this;
        }

        public Builder roles(List<MultiValuedAttribute> roles) {
            this.roles = roles;
            return this;
        }

        public Builder x509Certificates(List<MultiValuedAttribute> x509Certificates) {
            this.x509Certificates = x509Certificates;
            return this;
        }

        public Builder phoneByType(Map<String, String> phoneByType) {
            this.phoneByType = phoneByType;
            return this;
        }

        public User build() {
            return new User(this);
        }
    }
}

