/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.sdk;

import com.pingidentity.provisioner.mapping.FieldInfo;

public class SaasPluginFieldInfo
extends FieldInfo {
    private static final long serialVersionUID = 1L;

    public SaasPluginFieldInfo(String name, String description) throws IllegalArgumentException {
        super(name, description);
        this.validateName(name);
    }

    public SaasPluginFieldInfo(String name, String description, boolean required, boolean unique) throws IllegalArgumentException {
        super(name, description, required, unique);
        this.validateName(name);
    }

    public SaasPluginFieldInfo(String name, String description, boolean required, boolean unique, int minLength, int maxLength, String regex) throws IllegalArgumentException {
        super(name, description, required, unique, minLength, maxLength, regex);
        this.validateRangeParameters(minLength, maxLength);
        this.validateName(name);
    }

    private void validateRangeParameters(int minLength, int maxLength) throws IllegalArgumentException {
        if (minLength <= 0 || maxLength <= 0 || maxLength < minLength) {
            throw new IllegalArgumentException("Invalid minLength or maxLength");
        }
    }

    private void validateName(String name) throws IllegalArgumentException {
        if (name == null || "".equals(name.trim())) {
            throw new IllegalArgumentException("name can not be empty");
        }
    }
}

