/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.sdk.internal;

import com.pingidentity.provisioner.identity.SaasGroup;
import com.pingidentity.provisioner.identity.SaasIdentity;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.saas.SaasProvisionerPluginGroupsWithMembersExt;
import com.pingidentity.provisioner.sdk.AbstractSaasPlugin;
import com.pingidentity.provisioner.sdk.SaasGroupData;
import com.pingidentity.provisioner.sdk.SaasPluginException;
import com.pingidentity.provisioner.sdk.SaasUserData;
import com.pingidentity.provisioner.sdk.internal.AbstractSaasPluginBase;
import java.util.Iterator;

public abstract class AbstractSaasPluginWithGroupsBase
extends AbstractSaasPlugin
implements SaasProvisionerPluginGroupsWithMembersExt {
    private static final long serialVersionUID = 1L;

    public abstract boolean doesGroupExist(SaasGroupData var1) throws SaasPluginException;

    public abstract String updateGroup(SaasGroupData var1, boolean var2) throws SaasPluginException;

    public abstract String createGroup(SaasGroupData var1) throws SaasPluginException;

    public abstract void deleteGroup(SaasGroupData var1) throws SaasPluginException;

    public boolean doesGroupExist(SaasGroup saasGroup) throws SaasException {
        SaasGroupData saasGroupData = this.convertToGroupData(saasGroup);
        boolean saasGroupExists = this.doesGroupExist(saasGroupData);
        if (saasGroupExists) {
            saasGroup.setGuid(saasGroupData.getGuid());
        }
        return saasGroupExists;
    }

    public String updateGroup(SaasGroup saasGroup, boolean mergeMembership) throws SaasException {
        return this.updateGroup(this.convertToGroupData(saasGroup), mergeMembership);
    }

    public String createGroup(SaasGroup saasGroup) throws SaasException {
        return this.createGroup(this.convertToGroupData(saasGroup));
    }

    public void deleteGroup(SaasGroup saasGroup) throws SaasException {
        this.deleteGroup(this.convertToGroupData(saasGroup));
    }

    private SaasGroupData convertToGroupData(SaasGroup saasGroup) {
        return AbstractSaasPluginWithGroupsBase.convertToGroupData(saasGroup, this.getSaasUserIdFieldName());
    }

    private static SaasGroupData convertToGroupData(SaasGroup saasGroup, String saasUserIdFieldName) {
        Iterator<SaasUserData> iterator;
        SaasGroupData data = new SaasGroupData(saasGroup.getGuid(), saasGroup.getName());
        data.setDescription(saasGroup.getDescription());
        data.setInternalGuid(saasGroup.getInternalGuid());
        if (saasGroup.getMembersIterator() != null) {
            iterator = new SaasUserDataIterator(saasGroup.getMembersIterator(), saasUserIdFieldName);
            data.setMembersIterator(iterator);
        }
        if (saasGroup.getSubGroupsIterator() != null) {
            iterator = new SaasGroupDataIterator(saasGroup.getSubGroupsIterator());
            data.setSubGroupsIterator(iterator);
        }
        return data;
    }

    public static enum GroupMembershipUpdateMethod {
        UPDATE_VIA_GROUP;

    }

    private static class SaasGroupDataIterator
    implements Iterator<SaasGroupData> {
        private final Iterator<SaasGroup> delegate;

        public SaasGroupDataIterator(Iterator<SaasGroup> it) {
            this.delegate = it;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public SaasGroupData next() {
            return AbstractSaasPluginWithGroupsBase.convertToGroupData(this.delegate.next(), null);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SaasUserDataIterator
    implements Iterator<SaasUserData> {
        private final Iterator<SaasIdentity> delegate;
        private final String usernameField;

        public SaasUserDataIterator(Iterator<SaasIdentity> it, String usernameField) {
            this.delegate = it;
            this.usernameField = usernameField;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public SaasUserData next() {
            return AbstractSaasPluginBase.convertAndFilter(this.delegate.next(), this.usernameField, false);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

