/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingone;

import java.io.IOException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlCalendar;
import org.sourceid.saml20.domain.AdapterToAssertionMapping;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.AttributeSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.EndpointGroup;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.impl.LdapAttributeSource;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.ProvisioningParameters;
import org.sourceid.saml20.service.SpConnectionFactory;

public class PingOneSpConnectionBuilder {
    private final Log log = LogFactory.getLog(this.getClass());
    private final SpConnection connection;
    private ProvisioningParameters provisioningParams;
    private final ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
    private final SpConnectionFactory spConnFactory = MgmtFactory.getPingOneAdminService().getSpConnectionFactory();

    public PingOneSpConnectionBuilder(boolean isActiveDirectory) throws IOException {
        this.connection = this.createConnection(this.spConnFactory, isActiveDirectory);
        this.connection.setActive(true);
        this.spConnFactory.addCredentialsToConnection(this.connection);
    }

    public PingOneSpConnectionBuilder(IdpAuthnAdapterInstance formAdapter, IdpAuthnAdapterInstance kerberosAdapter, boolean isActiveDirectoryConfigured) throws IOException {
        this(formAdapter, kerberosAdapter, null, isActiveDirectoryConfigured);
    }

    public PingOneSpConnectionBuilder(IdpAuthnAdapterInstance formAdapter, IdpAuthnAdapterInstance kerberosAdapter, ProvisioningParameters parameters, boolean isActiveDirectoryConfigured) throws IOException {
        this.connection = this.createConnection(this.spConnFactory, isActiveDirectoryConfigured);
        this.connection.setActive(true);
        this.connection.getEnabledProfiles().setSpInitiatedSLOEnabled(false);
        this.connection.setSingleLogoutServices(new EndpointGroup());
        LinkedList<AdapterToAssertionMapping> adapterMappings = new LinkedList<AdapterToAssertionMapping>();
        AdapterToAssertionMapping htmlFormMapping = this.createAdapterMapping(this.connection.getAttributeContract().getAllAttributeNames(), formAdapter.getId(), isActiveDirectoryConfigured);
        adapterMappings.add(htmlFormMapping);
        this.connection.setAdapterMappings(adapterMappings);
        this.provisioningParams = parameters;
    }

    private SpConnection createConnection(SpConnectionFactory spConnProvider, boolean isActiveDirectory) throws IOException {
        try {
            SpConnection spConnection = spConnProvider.createSpConnection();
            if (!isActiveDirectory) {
                AttributeContract contract = spConnection.getAttributeContract();
                contract.removeMutableAttributeName("objectGuid");
                contract.removeMutableAttributeName("userPrincipalName");
            }
            return spConnection;
        }
        catch (IOException e) {
            this.log.error((Object)"Unable to create SP Connection for PingOne.");
            throw e;
        }
    }

    private AdapterToAssertionMapping createAdapterMapping(Set<String> attrs, String adapterID, boolean isActiveDirectory) {
        AttributeMapping mapping = new AttributeMapping();
        HashMap<String, String> p1ToPfAttributes = new HashMap<String, String>(PingOneSpConnectionBuilder.getP1ToPfAttributes(isActiveDirectory));
        for (String attr : attrs) {
            if (!p1ToPfAttributes.containsKey(attr)) continue;
            mapping.addAttributeMapping(attr, SourceType.ADAPTER, (String)p1ToPfAttributes.get(attr));
        }
        AdapterToAssertionMapping assertionMapping = new AdapterToAssertionMapping();
        assertionMapping.setAdapterInstanceId(adapterID);
        assertionMapping.setDefaultAttributeMapping(mapping);
        return assertionMapping;
    }

    private AdapterToAssertionMapping createAdapterMappingWithLookup(Set<String> attrs, String adapterID, AttributeSource source, boolean isActiveDirectory) {
        HashMap<String, String> p1ToPfAttributes = new HashMap<String, String>(PingOneSpConnectionBuilder.getP1ToPfAttributes(isActiveDirectory));
        AttributeMapping mapping = new AttributeMapping();
        mapping.setAttributeSource(source);
        HashMap<String, List<AttrMappingValue>> attrMap = new HashMap<String, List<AttrMappingValue>>();
        for (String attr : attrs) {
            if (attr.equals("SAML_SUBJECT")) {
                attrMap.put(attr, Collections.singletonList(new AttrMappingValue(SourceType.ADAPTER, "Username")));
                continue;
            }
            attrMap.put(attr, Collections.singletonList(new AttrMappingValue(SourceType.LDAP_DATA_STORE, (String)p1ToPfAttributes.get(attr), null, source.getId())));
        }
        mapping.setAttributeMap2(attrMap);
        AdapterToAssertionMapping adapterToAssertionMapping = new AdapterToAssertionMapping();
        adapterToAssertionMapping.setAdapterInstanceId(adapterID);
        adapterToAssertionMapping.setDefaultAttributeMapping(mapping);
        return adapterToAssertionMapping;
    }

    public void mapKerberoseAdapter(IdpAuthnAdapterInstance kerberoseAdapter, AttributeSource attributeSource, boolean isActiveDirectory) {
        AdapterToAssertionMapping kerberoseMapping = this.createAdapterMappingWithLookup(this.connection.getAttributeContract().getAllAttributeNames(), kerberoseAdapter.getId(), attributeSource, isActiveDirectory);
        LinkedList<AdapterToAssertionMapping> adapterMappings = new LinkedList<AdapterToAssertionMapping>(this.connection.getAdapterMappings());
        adapterMappings.add(kerberoseMapping);
        this.connection.setAdapterMappings(adapterMappings);
    }

    public LdapAttributeSource createAttributeSource(LdapDataSource dataSource, String searchBase, String filter) {
        LdapAttributeSource source = new LdapAttributeSource();
        source.setId(RandomStringUtils.randomAlphanumeric((int)10));
        source.setDescription(dataSource.getHost());
        source.setDataSource((DataSource)dataSource);
        source.setParameter("search_scope", "SUBTREE_SCOPE");
        source.setParameter("search_base", searchBase);
        if (filter != null) {
            source.setParameter("filter", filter.replaceAll("username", "Username"));
        }
        source.setParameter("memberof_nested_group", "false");
        for (String attribute : dataSource.getBinaryAttributes()) {
            source.setAttributeEncodingType(attribute, LdapDataSource.LdapAttrEncodingType.HEX.toString());
        }
        return source;
    }

    public void save() {
        this.log.debug((Object)"Saving populated SP Connection");
        this.spConnFactory.addCredentialsToConnection(this.connection);
        if (this.provisioningParams != null) {
            this.spConnFactory.addProvisioningToConnection(this.connection, this.provisioningParams);
        }
        this.connection.setCreationTime((Calendar)new XmlCalendar(new Date()));
        this.connectionManager.saveSpConnection(this.connection);
    }

    public SpConnection getConnection() {
        return this.connection;
    }

    public static Map<String, String> getP1ToPfAttributes(boolean isActiveDirectory) {
        HashMap<String, String> P1toPFAttributes = new HashMap<String, String>();
        P1toPFAttributes.put("SAML_SUBJECT", "username");
        P1toPFAttributes.put("email", "mail");
        P1toPFAttributes.put("fname", "givenName");
        P1toPFAttributes.put("lname", "sn");
        if (isActiveDirectory) {
            P1toPFAttributes.put("memberOf", "memberOf");
            P1toPFAttributes.put("objectGuid", "objectGUID");
            P1toPFAttributes.put("userPrincipalName", "userPrincipalName");
        } else {
            P1toPFAttributes.put("memberOf", "isMemberOf");
        }
        return P1toPFAttributes;
    }
}

