/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingone.impl;

import java.util.Arrays;
import java.util.List;
import org.sourceid.config.ConfigStore;

public class ConnectionFactoryConfig {
    private static final String PROVISIONING_FIELD_CODES = "ProvisioningFieldCodes";
    private static final String SIGNING_KEY_PAIR_LIFETIME_DAYS = "SigningKeyPairLifetimeDays";
    private static final String SIGNING_KEY_PAIR_ROTATION_BUFFER_MINS = "SigningKeyPairRotationBufferMins";
    private static final String SIGNING_KEY_PAIR_ACTIVATION_BUFFER_MINS = "SigningKeyPairActivationBufferMins";
    private static final String SIGNING_KEY_PAIR_KEY_SIZE = "SigningKeyPairKeySize";
    private static final String SIGNING_KEY_PAIR_SIGNATURE_ALGORITHM = "SigningKeyPairSignatureAlgorithm";
    private static final List<String> DEFAULT_PROVISIONING_FIELD_CODES = Arrays.asList("userName", "title", "givenName", "middleName", "familyName", "honorificSuffix", "displayName", "email", "emailType", "ldapAttributesMap");
    private ConfigStore configStore;

    public ConnectionFactoryConfig(ConfigStore store) {
        this.configStore = store;
    }

    public void startBatchUpdate() {
        this.configStore.startBatchUpdate();
    }

    public void cancelBatchUpdate() {
        this.configStore.cancelBatchUpdate();
    }

    public void commitBatchUpdate() {
        this.configStore.commitBatchUpdate();
    }

    public int getSigningKeyPairLifetimeDays() {
        return this.configStore.getIntValue(SIGNING_KEY_PAIR_LIFETIME_DAYS, 1095);
    }

    public void setSigningKeyPairLifetimeDays(int signingKeyPairLifetimeDays) {
        this.configStore.setIntValue(SIGNING_KEY_PAIR_LIFETIME_DAYS, signingKeyPairLifetimeDays);
    }

    public int getSigningKeyPairRotationBufferMins() {
        return this.configStore.getIntValue(SIGNING_KEY_PAIR_ROTATION_BUFFER_MINS, 129600);
    }

    public void setSigningKeyPairRotationBufferMins(int mins) {
        this.configStore.setIntValue(SIGNING_KEY_PAIR_ROTATION_BUFFER_MINS, mins);
    }

    public int getSigningKeyPairActivationBufferMins() {
        return this.configStore.getIntValue(SIGNING_KEY_PAIR_ACTIVATION_BUFFER_MINS, 43200);
    }

    public void setSigningKeyPairActivationBufferMins(int mins) {
        this.configStore.setIntValue(SIGNING_KEY_PAIR_ACTIVATION_BUFFER_MINS, mins);
    }

    public int getSigningKeyPairKeySize() {
        return this.configStore.getIntValue(SIGNING_KEY_PAIR_KEY_SIZE, 2048);
    }

    public void setSigningKeyPairKeySize(int bits) {
        this.configStore.setIntValue(SIGNING_KEY_PAIR_KEY_SIZE, bits);
    }

    public String getSigningKeyPairSignatureAlgorithm() {
        return this.configStore.getStringValue(SIGNING_KEY_PAIR_SIGNATURE_ALGORITHM, "SHA256withRSA");
    }

    public void setSigningKeyPairSignatureAlgorithm(String algorithm) {
        this.configStore.setStringValue(SIGNING_KEY_PAIR_SIGNATURE_ALGORITHM, algorithm);
    }

    public List<String> getProvisioningFieldCodes() {
        return this.configStore.getListValue(PROVISIONING_FIELD_CODES, DEFAULT_PROVISIONING_FIELD_CODES);
    }

    public void setProvisioningFieldCodes(List<String> provisioningFieldCodes) {
        this.configStore.setListValue(PROVISIONING_FIELD_CODES, provisioningFieldCodes);
    }
}

