/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingone.impl;

import com.pingidentity.common.util.CachedValue;
import com.pingidentity.configservice.Reloadable;
import com.pingidentity.crypto.CertificateGenerator;
import com.pingidentity.crypto.PkCert;
import com.pingidentity.pingone.AdminUserRoleMapping;
import com.pingidentity.pingone.InvalidAccessTokenException;
import com.pingidentity.pingone.PingOneAdminService;
import com.pingidentity.pingone.PingOneAdminServiceMetadata;
import com.pingidentity.pingone.PingOneAdminServiceSettings;
import com.pingidentity.pingone.api.IdpConfig;
import com.pingidentity.pingone.api.OpenIdConfiguration;
import com.pingidentity.pingone.api.PingDockInfo;
import com.pingidentity.pingone.api.PingOneAdminApiClient;
import com.pingidentity.pingone.api.PingOneAdminApiException;
import com.pingidentity.pingone.api.PingOneClientInfo;
import com.pingidentity.pingone.api.PingOneOAuthClientInfo;
import com.pingidentity.pingone.impl.AccessTokenHolder;
import com.pingidentity.pingone.impl.PingOneSpConnectionFactory;
import com.pingidentity.pingone.impl.PingOneWebSocketConnectionManager;
import com.pingidentity.pingone.impl.ServiceConfig;
import com.pingidentity.pingone.impl.ServiceKeyResolver;
import com.pingidentity.pingone.impl.ServiceState;
import com.pingidentity.pingone.impl.StatusRequestMessageHandler;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.openid.connect.domain.OIDCProviderConnection;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertManager;
import org.sourceid.saml20.service.SpConnectionFactory;

public class PingOneAdminServiceImpl
implements PingOneAdminService,
Reloadable {
    private static final String ACTIVATION_KEY_RELATIVE_PATH = "/cas/config/idpng/pingFedActivate";
    private static final String CLIENT_AUTHN_KEY_PAIR_ALGORITHM = "RSA";
    private static final int CLIENT_AUTHN_KEY_PAIR_SIZE = 2048;
    private static final String ADMIN_CONSOLE_HOSTNAME = "AdminConsoleHostname";
    protected static final String P1_ADMIN_SERVICE_CONFIG_NAME = "p1-admin-service-config";
    protected static final String P1_ADMIN_SERVICE_STATE_NAME = "p1-admin-service-state";
    protected static final String ADMIN_CONSOLE_ENDPOINT_CONFIG = "admin-console-endpoint-config";
    private static final Log log = LogFactory.getLog(PingOneAdminServiceImpl.class);
    private final ConfigStore configStore = ConfigStoreFarm.getConfig((String)"p1-admin-service-config");
    private final ConfigStore stateStore = ConfigStoreFarm.getConfig((String)"p1-admin-service-state");
    private final ConfigStore adminConsoleEndpointConfig = ConfigStoreFarm.getConfig((String)"admin-console-endpoint-config");
    private final ServiceConfig serviceConfig = this.makeServiceConfig();
    private final ServiceState serviceState = new ServiceState(this.stateStore);
    private final PkCertManager generalPkCertManager = MgmtFactory.getGeneralPkCertManager();
    private final AccessTokenHolder accessTokenHolder = new AccessTokenHolder();
    private VerificationKeyResolver verificationKeyResolver;
    private final PingOneSpConnectionFactory connFactory = this.makeSpConnectionFactory();
    private final PingOneWebSocketConnectionManager webSocketConnMgr = new PingOneWebSocketConnectionManager(this);
    private boolean initialized = false;
    private CachedValue<OpenIdConfiguration> pingOneOpenIdConfiguration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        PingOneAdminServiceImpl pingOneAdminServiceImpl = this;
        synchronized (pingOneAdminServiceImpl) {
            this.initialize();
            this.accessTokenHolder.setAccessToken(null);
            this.verificationKeyResolver = this.makeVerificationKeyResolver();
            if (this.isAssociated()) {
                this.webSocketConnMgr.activate();
            }
        }
        this.connFactory.reload();
    }

    public void upgradeConfiguration() {
        this.connFactory.upgradeConfiguration();
    }

    private void initialize() {
        if (!this.initialized) {
            this.pingOneOpenIdConfiguration = new CachedValue(() -> {
                try (PingOneAdminApiClient apiClient = this.makeApiClient();){
                    OpenIdConfiguration openIdConfiguration = apiClient.getOpenIdConfiguration();
                    return openIdConfiguration;
                }
            }, (long)this.serviceConfig.getEndpointMetadataCacheExpirySecs());
            this.webSocketConnMgr.addMessageHandler(new StatusRequestMessageHandler(this.webSocketConnMgr));
            this.initialized = true;
        }
    }

    public void shutdown() {
        this.connFactory.shutdown();
    }

    public synchronized boolean isAssociated() {
        return this.serviceState.isAssociated();
    }

    public synchronized void associate(String initialAccessToken, String initiateLoginUri) throws IOException, InvalidAccessTokenException {
        if (this.isAssociated()) {
            this.disassociate();
        }
        log.info((Object)"Creating association with PingOne admin service");
        String adminConsoleHostname = "";
        if (initiateLoginUri != null) {
            try {
                adminConsoleHostname = new URI(initiateLoginUri).getHost();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Invalid initiateLoginUri: " + initiateLoginUri, e);
            }
        }
        try (PingOneAdminApiClient apiClient = this.makeApiClient();
             AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            PingOneOAuthClientInfo clientInfo;
            PkCert keyPair = this.createClientAuthnKeyPair();
            try {
                clientInfo = apiClient.registerOAuthClient(initialAccessToken, initiateLoginUri, Collections.singletonList(keyPair));
            }
            catch (PingOneAdminApiException e) {
                if (e.getHttpStatusCode() == 401 || e.getHttpStatusCode() == 403) {
                    throw new InvalidAccessTokenException("The initial access token is invalid, it may have expired", (Throwable)e);
                }
                throw e;
            }
            this.serviceState.startBatchUpdate();
            try {
                try {
                    String applicationDockEndpoint = this.retrievePingOneDockUrl(apiClient);
                    this.serviceState.setApplicationDockEndpoint(applicationDockEndpoint);
                }
                catch (IOException e) {
                    log.debug((Object)"Error retrieving PingOne dock URL (likely the account does not support API access to this URL). The URL will not be available in the UI.");
                }
                this.serviceState.setProvisioningBaseUrl(this.retrieveProvisioningBaseUrl(apiClient));
                this.generalPkCertManager.savePkCert(keyPair);
                this.serviceState.setKeyPairAlias(keyPair.getAlias());
                this.serviceState.setClientId(clientInfo.getClientId());
                this.serviceState.setAccountId(clientInfo.getCustomerUuid());
                this.serviceState.setCompanyName(clientInfo.getCustomerName());
                this.serviceState.setAssociated(true);
                this.adminConsoleEndpointConfig.setStringValue(ADMIN_CONSOLE_HOSTNAME, adminConsoleHostname);
            }
            catch (Exception e) {
                this.serviceState.cancelBatchUpdate();
                throw e;
            }
            this.serviceState.commitBatchUpdate();
            auditLoggerScope.log(AdminAuditLogger.Component.PINGONE_ACCOUNT_ASSOCIATION, AdminAuditLogger.Event.CREATE);
        }
        this.webSocketConnMgr.activate();
        log.info((Object)"Finished creating association with PingOne admin service");
    }

    public synchronized void disassociate() {
        this.checkAssociated();
        log.info((Object)"Deleting association with PingOne admin service");
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.webSocketConnMgr.deactivate();
            this.accessTokenHolder.setAccessToken(null);
            if (this.serviceState.getKeyPairAlias() != null) {
                this.generalPkCertManager.deletePkCertById(this.serviceState.getKeyPairAlias());
            }
            if (this.serviceState.getPreviousKeyPairAlias() != null) {
                this.generalPkCertManager.deletePkCertById(this.serviceState.getPreviousKeyPairAlias());
            }
            this.serviceState.startBatchUpdate();
            this.serviceState.setKeyPairAlias(null);
            this.serviceState.setPreviousKeyPairAlias(null);
            this.serviceState.setAssociated(false);
            this.serviceState.setAccountId(null);
            this.serviceState.setClientId(null);
            this.serviceState.setCompanyName(null);
            this.serviceState.setApplicationDockEndpoint(null);
            this.serviceState.setProvisioningBaseUrl(null);
            this.serviceState.commitBatchUpdate();
            PingOneAdminServiceSettings settings = this.getSettings();
            settings.setEnableAdminConsoleSso(false);
            this.saveSettings(settings);
            auditLoggerScope.log(AdminAuditLogger.Component.PINGONE_ACCOUNT_ASSOCIATION, AdminAuditLogger.Event.DELETE);
        }
    }

    public synchronized PingOneAdminServiceSettings getSettings() {
        PingOneAdminServiceSettings settings = new PingOneAdminServiceSettings();
        settings.setEnableAdminConsoleSso(this.serviceConfig.isEnableAdminConsoleSso());
        settings.setEnableMonitoring(this.serviceConfig.isEnableMonitoring());
        settings.setValidateSsoRedirectUri(this.serviceConfig.isValidateSsoRedirectUri());
        settings.setAdminConsoleHostname(this.adminConsoleEndpointConfig.getStringValue(ADMIN_CONSOLE_HOSTNAME, ""));
        return settings;
    }

    public synchronized void saveSettings(PingOneAdminServiceSettings settings) {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            this.serviceConfig.startBatchUpdate();
            this.serviceConfig.setEnableAdminConsoleSso(settings.isEnableAdminConsoleSso());
            this.serviceConfig.setEnableMonitoring(settings.isEnableMonitoring());
            this.serviceConfig.setValidateSsoRedirectUri(settings.isValidateSsoRedirectUri());
            this.serviceConfig.commitBatchUpdate();
            this.adminConsoleEndpointConfig.setStringValue(ADMIN_CONSOLE_HOSTNAME, StringUtils.defaultString((String)settings.getAdminConsoleHostname()));
            auditLoggerScope.log(AdminAuditLogger.Component.PINGONE_CONNECTION, AdminAuditLogger.Event.UPDATE);
        }
    }

    public synchronized PingOneAdminServiceMetadata getMetadata() {
        PingOneAdminServiceMetadata metadata = new PingOneAdminServiceMetadata();
        metadata.setWebPortalUrl(this.serviceConfig.getWebPortalUrl());
        metadata.setAddApplicationUrl(this.serviceConfig.getAddApplicationUrl());
        metadata.setActivationKeyUrl(this.serviceConfig.getWebPortalUrl() + ACTIVATION_KEY_RELATIVE_PATH);
        metadata.setPingOneAccountId(this.serviceState.getAccountId());
        metadata.setPingOneCompanyName(this.serviceState.getCompanyName());
        return metadata;
    }

    public synchronized SpConnectionFactory getSpConnectionFactory() {
        return this.connFactory;
    }

    public synchronized OIDCProviderConnection getOIDCProviderConnection() {
        this.checkAssociated();
        PkCert keyPair = this.getActiveClientAuthnKeyPair();
        OIDCProviderConnection result = new OIDCProviderConnection(this.serviceConfig.getApiAudience(), this.serviceState.getClientId(), this.serviceConfig.getOIDCAuthorizationEndpoint(), this.serviceConfig.getOIDCEndSessionEndpoint(), keyPair, this.verificationKeyResolver);
        result.setAllowedClockSkewSecs(this.serviceConfig.getAllowedClockSkewSecs());
        return result;
    }

    public synchronized AdminUserRoleMapping getAdminUserRoleMapping() {
        AdminUserRoleMapping mapping = new AdminUserRoleMapping();
        mapping.setAdminRoles(this.serviceConfig.getAdminRoles());
        mapping.setAuditorRoles(this.serviceConfig.getAuditorRoles());
        mapping.setCryptoManagerRoles(this.serviceConfig.getCryptoManagerRoles());
        mapping.setUserManagerRoles(this.serviceConfig.getUserManagerRoles());
        mapping.setExpressionManagerRoles(this.serviceConfig.getExpressionAdminRoles());
        return mapping;
    }

    public String downloadLicense() throws IOException {
        try (PingOneAdminApiClient apiClient = this.makeApiClient();){
            String string = apiClient.downloadLicense();
            return string;
        }
    }

    public JsonWebKeySet getVerificationKeySet() throws IOException {
        try (PingOneAdminApiClient apiClient = this.makeApiClient();){
            JsonWebKeySet jsonWebKeySet = apiClient.getKeySet();
            return jsonWebKeySet;
        }
    }

    public synchronized PkCert getClientAuthnKeyPair() {
        if (this.serviceState.getKeyPairAlias() == null) {
            return null;
        }
        return this.generalPkCertManager.getPkCert(this.serviceState.getKeyPairAlias());
    }

    public synchronized PkCert getPreviousClientAuthnKeyPair() {
        if (this.serviceState.getPreviousKeyPairAlias() == null) {
            return null;
        }
        return this.generalPkCertManager.getPkCert(this.serviceState.getPreviousKeyPairAlias());
    }

    public synchronized void rotateClientAuthnKeyPair() throws IOException {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            PkCert newKeyPair = this.createClientAuthnKeyPair();
            this.generalPkCertManager.savePkCert(newKeyPair);
            ArrayList<PkCert> keyPairs = new ArrayList<PkCert>();
            keyPairs.add(newKeyPair);
            PkCert prevKeyPair = this.getClientAuthnKeyPair();
            if (prevKeyPair != null) {
                keyPairs.add(prevKeyPair);
            }
            try {
                this.updateOAuthClient(keyPairs);
            }
            catch (Exception e) {
                this.generalPkCertManager.deletePkCert(newKeyPair);
                throw e;
            }
            if (this.serviceState.getPreviousKeyPairAlias() != null) {
                this.generalPkCertManager.deletePkCertById(this.serviceState.getPreviousKeyPairAlias());
            }
            this.serviceState.setPreviousKeyPairAlias(this.serviceState.getKeyPairAlias());
            this.serviceState.setKeyPairAlias(newKeyPair.getAlias());
            log.debug((Object)("Rotated client authn key pair, new key pair alias: " + this.serviceState.getKeyPairAlias()));
            auditLoggerScope.log(AdminAuditLogger.Component.PINGONE_ACCOUNT_ASSOCIATION, AdminAuditLogger.Event.MODIFY);
        }
    }

    public synchronized int getClientAuthnKeyPairActivationDelaySecs() {
        return this.serviceConfig.getClientAuthnKeyPairActivationDelaySecs();
    }

    public synchronized boolean isMonitoringEnabled() {
        return this.isAssociated() && this.serviceConfig.isEnableMonitoring();
    }

    public synchronized PingOneAdminApiClient makeApiClient() throws PingOneAdminApiException {
        PkCert keyPair = this.getActiveClientAuthnKeyPair();
        PingOneAdminApiClient apiClient = this.serviceState.isAssociated() && keyPair != null ? new PingOneAdminApiClient(this.accessTokenHolder, keyPair, this.serviceState.getAccountId(), this.serviceState.getClientId()) : new PingOneAdminApiClient(this.accessTokenHolder);
        PingOneAdminApiClient.ClientOptions options = PingOneAdminServiceImpl.getClientOptions(this.serviceConfig);
        apiClient.setClientOptions(options);
        apiClient.initialize();
        return apiClient;
    }

    private static PingOneAdminApiClient.ClientOptions getClientOptions(ServiceConfig serviceConfig) {
        PingOneAdminApiClient.ClientOptions options = new PingOneAdminApiClient.ClientOptions();
        options.setBaseUrl(serviceConfig.getApiBaseUrl());
        options.setConnTimeoutMillis(serviceConfig.getConnTimeoutMillis());
        options.setClientAuthnTokenAudience(serviceConfig.getApiAudience());
        options.setClientAuthnTokenLifetimeMins(serviceConfig.getClientAuthnTokenLifetimeMins());
        options.setJwksUri(serviceConfig.getOIDCJwksUri());
        options.setDisableHostnameVerification(serviceConfig.isDisableHostnameVerification());
        return options;
    }

    public synchronized String getApplicationDockEndpoint() {
        return this.serviceState.getApplicationDockEndpoint();
    }

    public synchronized String getCompanyName() {
        return this.serviceState.getCompanyName();
    }

    public synchronized int getAllowedClockSkewSecs() {
        return this.serviceConfig.getAllowedClockSkewSecs();
    }

    public synchronized String getAccountId() {
        return this.serviceState.getAccountId();
    }

    public synchronized String getClientId() {
        return this.serviceState.getClientId();
    }

    public synchronized String getProvisioningBaseUrl() {
        return this.serviceState.getProvisioningBaseUrl();
    }

    public synchronized int getClientAuthnTokenLifetimeMins() {
        return this.serviceConfig.getClientAuthnTokenLifetimeMins();
    }

    protected synchronized PkCert getActiveClientAuthnKeyPair() {
        PkCert currentKeyPair = this.getClientAuthnKeyPair();
        if (currentKeyPair == null) {
            return null;
        }
        if (currentKeyPair.getX509Certificate().getNotBefore().getTime() + this.serviceConfig.getClientAuthnKeyPairActivationDelayMillis() < this.getCurrentTimeMillis()) {
            return currentKeyPair;
        }
        PkCert previousKeyPair = this.getPreviousClientAuthnKeyPair();
        return Objects.requireNonNullElse(previousKeyPair, currentKeyPair);
    }

    protected synchronized PkCert createClientAuthnKeyPair() {
        try {
            return new PkCert.Builder().cn("localhost").ou("Development").o("PingIdentity").l("Denver").st("CO").c("US").validDays(this.serviceConfig.getClientAuthnKeyPairLifetimeDays()).validFrom(new Date(this.getCurrentTimeMillis())).keyAlgo(CLIENT_AUTHN_KEY_PAIR_ALGORITHM).keySize(2048).certificateType(CertificateGenerator.CertificateType.generalCerts).build();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Unexpected error creating client authentication keypair for PingOne admin service: " + e, e);
        }
    }

    protected synchronized ServiceConfig makeServiceConfig() {
        return new ServiceConfig(this.configStore);
    }

    protected synchronized CachedValue<OpenIdConfiguration> getPingOneOpenIdConfiguration() {
        return this.pingOneOpenIdConfiguration;
    }

    protected synchronized void updateOAuthClient(List<PkCert> keyPairs) throws IOException {
        try (PingOneAdminApiClient apiClient = this.makeApiClient();){
            PingOneClientInfo currentInfo = apiClient.getClient();
            apiClient.updateOAuthClient(currentInfo.getInitiateLoginUri(), keyPairs);
        }
    }

    protected synchronized VerificationKeyResolver makeVerificationKeyResolver() {
        return new ServiceKeyResolver(this, this.serviceConfig.getVerificationKeySetRefreshIntervalMins());
    }

    public synchronized void checkAssociated() {
        if (!this.serviceState.isAssociated()) {
            throw new IllegalStateException("Association not yet established with PingOne admin service");
        }
    }

    protected synchronized PingOneSpConnectionFactory makeSpConnectionFactory() {
        return new PingOneSpConnectionFactory(this);
    }

    protected synchronized String retrieveProvisioningBaseUrl(PingOneAdminApiClient apiClient) throws IOException {
        IdpConfig idpConfig = apiClient.getIdpConfig("prv");
        try {
            return idpConfig.getProfiles().get("prv").getConfigs().get("provisioning.baseurl").getValue();
        }
        catch (Exception e) {
            throw new IOException("Failed to retrieve provisioning base URL: " + e, e);
        }
    }

    protected synchronized long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    protected synchronized String retrievePingOneDockUrl(PingOneAdminApiClient apiClient) throws IOException {
        PingDockInfo dockInfo = apiClient.getPingDockInfo();
        return dockInfo.getLaunchUrl();
    }

    public synchronized String downloadPingIdProperties() throws IOException {
        try (PingOneAdminApiClient apiClient = this.makeApiClient();){
            String string = apiClient.downloadPingIdPropertiesFile();
            return string;
        }
    }
}

