/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingone.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.sourceid.util.ObjectMapperFactory;
import org.sourceid.util.json.JsonUtils;

public class PingOneMessage {
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.buildObjectMapper();
    public static final String MESSAGE_TYPE = "messageType";
    public static final String REQUEST_ID = "requestId";
    public static final String IN_RESPONSE_TO = "inResponseTo";
    private Map<String, Object> fields = new HashMap<String, Object>();

    public PingOneMessage() {
    }

    public PingOneMessage(String messageType) {
        this.setMessageType(messageType);
    }

    public PingOneMessage(Map<String, Object> fields) {
        this.fields = fields;
    }

    public static PingOneMessage makeRequest(String messageType) {
        PingOneMessage msg = new PingOneMessage(messageType);
        msg.setRequestId(UUID.randomUUID().toString());
        return msg;
    }

    public PingOneMessage makeResponse(String messageType) {
        PingOneMessage msg = new PingOneMessage(messageType);
        msg.setInResponseTo(this.getRequestId());
        return msg;
    }

    public static PingOneMessage fromJson(String json) throws JsonProcessingException {
        Map fields = (Map)OBJECT_MAPPER.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
        return new PingOneMessage(fields);
    }

    public String toString() {
        Object result = this.getMessageType();
        if (this.getRequestId() != null) {
            result = (String)result + "[" + this.getRequestId() + "]";
        } else if (this.getInResponseTo() != null) {
            result = (String)result + "[" + this.getInResponseTo() + "]";
        }
        return result;
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, Object> fields) {
        this.fields = fields;
    }

    public void setField(String fieldName, Object fieldValue) {
        this.fields.put(fieldName, fieldValue);
    }

    public Object getField(String fieldName) {
        return this.fields.get(fieldName);
    }

    public String toJson() {
        try {
            return JsonUtils.getInstance().writeValueAsString(this.getFields());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getMessageType() {
        return (String)this.fields.get(MESSAGE_TYPE);
    }

    public void setMessageType(String messageType) {
        this.fields.put(MESSAGE_TYPE, messageType);
    }

    public String getRequestId() {
        return (String)this.fields.get(REQUEST_ID);
    }

    public void setRequestId(String requestId) {
        this.fields.put(REQUEST_ID, requestId);
    }

    public String getInResponseTo() {
        return (String)this.fields.get(IN_RESPONSE_TO);
    }

    public void setInResponseTo(String inResponseTo) {
        this.fields.put(IN_RESPONSE_TO, inResponseTo);
    }
}

