/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingone.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sourceid.config.ConfigStore;

public class ServiceConfig {
    private static final String MONITORING_PAGE_RELATIVE_PATH = "/cas/config/idpng";
    private static final String API_BASE_URL = "ApiBaseUrl";
    private static final String CONN_TIMEOUT_MILLIS = "ConnTimeoutMillis";
    private static final String DISABLE_HOSTNAME_VERIFICATION = "DisableHostnameVerification";
    private static final String ENABLE_ADMIN_CONSOLE_SSO = "EnableAdminConsoleSso";
    private static final String VERIFICATION_KEY_SET_REFRESH_INTERVAL_MINS = "VerificationKeySetRefreshIntervalMins";
    private static final String ALLOWED_CLOCK_SKEW_SECS = "AllowedClockSkewSecs";
    private static final String API_AUDIENCE = "ApiAudience";
    private static final String CLIENT_AUTHN_KEY_PAIR_LIFETIME_DAYS = "ClientAuthnKeyPairLifetimeDays";
    private static final String CLIENT_AUTHN_KEY_PAIR_ACTIVATION_DELAY_SECS = "ClientAuthnKeyPairActivationDelaySecs";
    private static final String CLIENT_AUTHN_TOKEN_LIFETIME_MINS = "ClientAuthnTokenLifetimeMins";
    private static final String ENABLE_MONITORING = "EnableMonitoring";
    private static final String WEB_PORTAL_URL = "WebPortalUrl";
    private static final String ADD_APPLICATION_URL = "AddApplicationUrl";
    private static final String OIDC_AUTHORIZATION_ENDPOINT = "OIDCAuthorizationEndpoint";
    private static final String OIDC_END_SESSION_ENDPOINT = "OIDCEndSessionEndpoint";
    private static final String OIDC_JWKS_URI = "OIDCJwksUri";
    private static final String VALIDATE_SSO_REDIRECT_URI = "ValidateSsoRedirectUri";
    private static final String ENDPOINT_METADATA_CACHE_EXPIRY_SECS = "EndpointMetadataCacheExpirySecs";
    private static final String ADMIN_ROLES = "AdminRoles";
    private static final String CRYPTO_MANAGER_ROLES = "CryptoManagerRoles";
    private static final String USER_MANAGER_ROLES = "UserManagerRoles";
    private static final String AUDITOR_ROLES = "AuditorRoles";
    private static final String EXPRESSION_ADMIN_ROLES = "ExpressionAdminRoles";
    private static final String PING_ONE_GLOBAL_ADMIN_ROLE = "GLOBAL_ADMIN";
    private ConfigStore configStore;

    public ServiceConfig(ConfigStore store) {
        this.configStore = store;
    }

    public void startBatchUpdate() {
        this.configStore.startBatchUpdate();
    }

    public void commitBatchUpdate() {
        this.configStore.commitBatchUpdate();
    }

    public String getApiBaseUrl() {
        String result = this.configStore.getStringValue(API_BASE_URL, "https://admin-api.pingone.com/v3");
        if (result.endsWith("/")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public void setApiBaseUrl(String apiBaseUrl) {
        this.configStore.setStringValue(API_BASE_URL, apiBaseUrl);
    }

    public int getConnTimeoutMillis() {
        return this.configStore.getIntValue(CONN_TIMEOUT_MILLIS, 10000);
    }

    public void setConnTimeoutMillis(int connTimeoutMillis) {
        this.configStore.setIntValue(CONN_TIMEOUT_MILLIS, connTimeoutMillis);
    }

    public boolean isDisableHostnameVerification() {
        return this.configStore.getBooleanValue(DISABLE_HOSTNAME_VERIFICATION, false);
    }

    public boolean isEnableAdminConsoleSso() {
        return this.configStore.getBooleanValue(ENABLE_ADMIN_CONSOLE_SSO, false);
    }

    public void setEnableAdminConsoleSso(boolean adminConsoleSsoEnabled) {
        this.configStore.setBooleanValue(ENABLE_ADMIN_CONSOLE_SSO, adminConsoleSsoEnabled);
    }

    public int getVerificationKeySetRefreshIntervalMins() {
        return this.configStore.getIntValue(VERIFICATION_KEY_SET_REFRESH_INTERVAL_MINS, 60);
    }

    public void setVerificationKeySetRefreshIntervalMins(int verificationKeySetRefreshIntervalMins) {
        this.configStore.setIntValue(VERIFICATION_KEY_SET_REFRESH_INTERVAL_MINS, verificationKeySetRefreshIntervalMins);
    }

    public int getAllowedClockSkewSecs() {
        return this.configStore.getIntValue(ALLOWED_CLOCK_SKEW_SECS, 300);
    }

    public void setAllowedClockSkewSecs(int allowedClockSkewSecs) {
        this.configStore.setIntValue(ALLOWED_CLOCK_SKEW_SECS, allowedClockSkewSecs);
    }

    public String getApiAudience() {
        return this.configStore.getStringValue(API_AUDIENCE, "https://admin.pingone.com");
    }

    public void setApiAudience(String apiAudience) {
        this.configStore.setStringValue(API_AUDIENCE, apiAudience);
    }

    public int getClientAuthnKeyPairLifetimeDays() {
        return this.configStore.getIntValue(CLIENT_AUTHN_KEY_PAIR_LIFETIME_DAYS, 1095);
    }

    public void setClientAuthnKeyPairLifetimeDays(int clientAuthnKeyPairLifetimeDays) {
        this.configStore.setIntValue(CLIENT_AUTHN_KEY_PAIR_LIFETIME_DAYS, clientAuthnKeyPairLifetimeDays);
    }

    public int getClientAuthnKeyPairActivationDelaySecs() {
        return this.configStore.getIntValue(CLIENT_AUTHN_KEY_PAIR_ACTIVATION_DELAY_SECS, 900);
    }

    public long getClientAuthnKeyPairActivationDelayMillis() {
        return (long)this.getClientAuthnKeyPairActivationDelaySecs() * 1000L;
    }

    public int getClientAuthnTokenLifetimeMins() {
        return this.configStore.getIntValue(CLIENT_AUTHN_TOKEN_LIFETIME_MINS, 10);
    }

    public void setClientAuthnTokenLifetimeMins(int mins) {
        this.configStore.setIntValue(CLIENT_AUTHN_TOKEN_LIFETIME_MINS, mins);
    }

    public boolean isEnableMonitoring() {
        return this.configStore.getBooleanValue(ENABLE_MONITORING, true);
    }

    public void setEnableMonitoring(boolean monitoringEnabled) {
        this.configStore.setBooleanValue(ENABLE_MONITORING, monitoringEnabled);
    }

    public String getWebPortalUrl() {
        return this.configStore.getStringValue(WEB_PORTAL_URL, "https://admin.pingone.com/web-portal");
    }

    public String getAddApplicationUrl() {
        return this.configStore.getStringValue(ADD_APPLICATION_URL, "https://admin.pingone.com/web-portal/cas/connections#/");
    }

    public void setWebPortalUrl(String url) {
        this.configStore.setStringValue(WEB_PORTAL_URL, url);
    }

    public String getOIDCAuthorizationEndpoint() {
        return this.configStore.getStringValue(OIDC_AUTHORIZATION_ENDPOINT, this.getApiBaseUrl() + "/as/authorization.oauth2");
    }

    public void setOIDCAuthorizationEndpoint(String endpoint) {
        this.configStore.setStringValue(OIDC_AUTHORIZATION_ENDPOINT, endpoint);
    }

    public String getOIDCEndSessionEndpoint() {
        return this.configStore.getStringValue(OIDC_END_SESSION_ENDPOINT, this.getWebPortalUrl() + MONITORING_PAGE_RELATIVE_PATH);
    }

    public void setOIDCEndSessionEndpoint(String endpoint) {
        this.configStore.setStringValue(OIDC_END_SESSION_ENDPOINT, endpoint);
    }

    public String getOIDCJwksUri() {
        return this.configStore.getStringValue(OIDC_JWKS_URI, this.getApiBaseUrl() + "/jwks");
    }

    public void setOIDCJwksUri(String uri) {
        this.configStore.setStringValue(OIDC_JWKS_URI, uri);
    }

    public List<String> getAdminRoles() {
        return this.configStore.getListValue(ADMIN_ROLES, Arrays.asList(PING_ONE_GLOBAL_ADMIN_ROLE));
    }

    public void setAdminRoles(List<String> roles) {
        this.configStore.setListValue(ADMIN_ROLES, roles);
    }

    public List<String> getUserManagerRoles() {
        return this.configStore.getListValue(USER_MANAGER_ROLES, Arrays.asList(PING_ONE_GLOBAL_ADMIN_ROLE));
    }

    public void setUserManagerRoles(List<String> roles) {
        this.configStore.setListValue(USER_MANAGER_ROLES, roles);
    }

    public List<String> getCryptoManagerRoles() {
        return this.configStore.getListValue(CRYPTO_MANAGER_ROLES, Arrays.asList(PING_ONE_GLOBAL_ADMIN_ROLE));
    }

    public void setCryptoManagerRoles(List<String> roles) {
        this.configStore.setListValue(CRYPTO_MANAGER_ROLES, roles);
    }

    public List<String> getAuditorRoles() {
        return this.configStore.getListValue(AUDITOR_ROLES, new ArrayList());
    }

    public void setAuditorRoles(List<String> roles) {
        this.configStore.setListValue(AUDITOR_ROLES, roles);
    }

    public int getEndpointMetadataCacheExpirySecs() {
        return this.configStore.getIntValue(ENDPOINT_METADATA_CACHE_EXPIRY_SECS, 3600);
    }

    public boolean isValidateSsoRedirectUri() {
        return this.configStore.getBooleanValue(VALIDATE_SSO_REDIRECT_URI, true);
    }

    public void setValidateSsoRedirectUri(boolean validate) {
        this.configStore.setBooleanValue(VALIDATE_SSO_REDIRECT_URI, validate);
    }

    public List<String> getExpressionAdminRoles() {
        return this.configStore.getListValue(EXPRESSION_ADMIN_ROLES, Arrays.asList(PING_ONE_GLOBAL_ADMIN_ROLE));
    }

    public void setExpressionAdminRoles(List<String> roles) {
        this.configStore.setListValue(EXPRESSION_ADMIN_ROLES, roles);
    }
}

