/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingone.impl;

import com.pingidentity.pingone.PingOneAdminService;
import java.io.IOException;
import java.security.Key;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.VerificationJwkSelector;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.JoseException;
import org.jose4j.lang.UnresolvableKeyException;

public class ServiceKeyResolver
implements VerificationKeyResolver {
    private static final Log log = LogFactory.getLog(ServiceKeyResolver.class);
    private PingOneAdminService remoteAdminService;
    private volatile JsonWebKeySet keySet = new JsonWebKeySet(new JsonWebKey[0]);
    private volatile long lastRefreshTimeMillis = 0L;
    private int keySetRefreshIntervalMins = 60;

    public ServiceKeyResolver(PingOneAdminService remoteAdminService, int keySetRefreshIntervalMins) {
        this.remoteAdminService = remoteAdminService;
        this.keySetRefreshIntervalMins = keySetRefreshIntervalMins;
    }

    public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        JsonWebKey selected = null;
        try {
            VerificationJwkSelector selector;
            boolean refreshed = false;
            if (this.getCurrentTimeMillis() - this.lastRefreshTimeMillis > (long)(this.keySetRefreshIntervalMins * 60 * 1000)) {
                this.refreshLocalKeySet();
                refreshed = true;
            }
            if ((selected = (selector = new VerificationJwkSelector()).select(jws, (Collection)this.keySet.getJsonWebKeys())) == null && !refreshed) {
                this.refreshLocalKeySet();
                selected = selector.select(jws, (Collection)this.keySet.getJsonWebKeys());
            }
        }
        catch (IOException | JoseException e) {
            throw new UnresolvableKeyException("Error resolving key to verify JWT signature: " + (Exception)e, e);
        }
        if (selected == null) {
            throw new UnresolvableKeyException("No key found to verify JWT with header " + jws.getHeaders().getFullHeaderAsJsonString() + " in key set " + this.keySet.getJsonWebKeys());
        }
        return selected.getKey();
    }

    protected long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    private void refreshLocalKeySet() throws IOException {
        log.debug((Object)"Refreshing key set");
        this.keySet = this.remoteAdminService.getVerificationKeySet();
        this.lastRefreshTimeMillis = this.getCurrentTimeMillis();
    }
}

