/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingone.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.pingidentity.common.util.B64;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.pingcommons.monitoring.impl.SystemMonitorBuilder;
import com.pingidentity.pingid.PingIdInitialSetupAdminService;
import com.pingidentity.pingone.impl.PingOneMessage;
import com.pingidentity.pingone.impl.PingOneMessageHandler;
import com.pingidentity.pingone.impl.PingOneWebSocketConnectionManager;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.json.JsonUtils;
import org.sourceid.util.license.LicenseManager;

public class StatusRequestMessageHandler
implements PingOneMessageHandler {
    private static final Log log = LogFactory.getLog(StatusRequestMessageHandler.class);
    public static final String PF_STATUS_REQUEST = "PF.StatusRequest";
    public static final String PF_STATUS_RESPONSE = "PF.StatusResponse";
    public static final String PF_VERSION = "pf.version";
    public static final String PF_LICENSE = "pf.license";
    public static final String BODY = "body";
    public static final String MANAGED_PCV = "managed.pcv";
    public static final String MANAGED_PCV_ID = "id";
    public static final String MANAGED_PCV_NAME = "name";
    private final PingOneWebSocketConnectionManager connManager;
    private final PingIdInitialSetupAdminService pingIdServer = MgmtFactory.getPingIdInitialSetupAdminService();

    public StatusRequestMessageHandler(PingOneWebSocketConnectionManager connMgr) {
        this.connManager = connMgr;
    }

    @Override
    public String getHandledMessageType() {
        return PF_STATUS_REQUEST;
    }

    @Override
    public void onMessage(PingOneMessage message) {
        PingOneMessage response = message.makeResponse(PF_STATUS_RESPONSE);
        String jsonResults = this.getStatusInfoJsonResults();
        String b64 = B64.encode((String)jsonResults);
        response.setField(BODY, b64);
        if (log.isTraceEnabled()) {
            log.trace((Object)("PF.StatusResponse sent to PingOne: " + jsonResults));
        }
        this.connManager.sendMessage(response);
    }

    private String getStatusInfoJsonResults() {
        try {
            return JsonUtils.getInstance().writeValueAsString(this.getStatusInfo());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    protected Map<String, Object> getStatusInfo() {
        Map<String, Object> statusInfo = this.getJvmMetrics();
        statusInfo.put(PF_LICENSE, this.getPingFederateLicenseType());
        statusInfo.put(PF_VERSION, PropertyInfo.getPingFederateVersion());
        if (this.pingIdServer.getPCV() != null) {
            statusInfo.put(MANAGED_PCV, this.getManagedPCV());
        }
        return statusInfo;
    }

    private Map<String, Object> getJvmMetrics() {
        Map<String, Object> results = new HashMap<String, Object>();
        if (MgmtFactory.getPingOneAdminService().getSettings().isEnableMonitoring()) {
            SystemMonitorBuilder builder = new SystemMonitorBuilder();
            builder.setCPU().setJVMMemory().setSystemMemory().setHostnameCachedAtStartup();
            results = builder.build().getResults();
        }
        return results;
    }

    private String getPingFederateLicenseType() {
        if (LicenseManager.getLicense() != null && LicenseManager.getLicense().isBridgeMode()) {
            return "BRIDGE";
        }
        return "FULL";
    }

    private Map<String, Object> getManagedPCV() {
        HashMap<String, Object> managedPCV = new HashMap<String, Object>();
        managedPCV.put(MANAGED_PCV_ID, this.pingIdServer.getPCV().getId());
        managedPCV.put(MANAGED_PCV_NAME, this.pingIdServer.getPCV().getName());
        return managedPCV;
    }
}

