/*
 * Decompiled with CFR 0.152.
 */
package org.pingidentity.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.pingidentity.utils.EnvironmentVariableUtil;
import org.pingidentity.utils.StringSubstituter;

public class HivemoduleGenerator {
    private static final String PF_DEFAULT_CONF_PATH = System.getProperty("pf.server.default.dir") + File.separator + "conf" + File.separator;
    private static final String HIVEMODULE_XML_RELATIVE_PATH = "META-INF" + File.separator + "hivemodule.xml";
    private static final String GENERATED_HIVEMODULE_PATH = PF_DEFAULT_CONF_PATH + "generated-hivemodule" + File.separator + HIVEMODULE_XML_RELATIVE_PATH;
    private static final String HIVEMODULE_PATH = PF_DEFAULT_CONF_PATH + HIVEMODULE_XML_RELATIVE_PATH;
    private static final String HIVEMODULE_TEMPLATE_PATH = "/template/hivemodule-template.xml";
    private static final String SERVICE_POINTS_CONF_FILE = "service-points.conf";
    private static final String SHA1_ALG = "SHA-1";
    private static final String FINGERPRINT_REGEX = "<!--\\s*Fingerprint\\s*:(.*)-->";
    private static final Pattern FINGERPRINT_PATTERN = Pattern.compile("<!--\\s*Fingerprint\\s*:(.*)-->");

    public static void generateRuntimeHivemodule() throws IOException, NoSuchAlgorithmException {
        File generatedHivemoduleXml = new File(GENERATED_HIVEMODULE_PATH);
        File sourceFile = new File(HIVEMODULE_PATH);
        if (!sourceFile.exists()) {
            File servicePointsConf = new File(PF_DEFAULT_CONF_PATH + SERVICE_POINTS_CONF_FILE);
            if (!servicePointsConf.exists()) {
                throw new IOException("Failed to read file: " + servicePointsConf.getPath());
            }
            String sha1Hash = HivemoduleGenerator.generateSha1Hash(servicePointsConf);
            if (generatedHivemoduleXml.exists()) {
                if (sha1Hash.equals(HivemoduleGenerator.getPrevSha1Hash(generatedHivemoduleXml))) {
                    return;
                }
                if (!generatedHivemoduleXml.delete()) {
                    throw new IOException("Failed to delete file: " + GENERATED_HIVEMODULE_PATH);
                }
            }
            HivemoduleGenerator.generateHivemoduleWithTemplate(generatedHivemoduleXml, servicePointsConf, sha1Hash, true);
        }
    }

    public static void generateHivemoduleWithTemplate(File hivemoduleXmlFile, File servicePointsConfFile) throws IOException {
        HivemoduleGenerator.generateHivemoduleWithTemplate(hivemoduleXmlFile, servicePointsConfFile, "", false);
    }

    private static void generateHivemoduleWithTemplate(File hivemoduleXmlFile, File servicePointsConfFile, String sha1Hash, boolean substituteEnvVar) throws IOException {
        File hivemoduleXmlParentFile = hivemoduleXmlFile.getParentFile();
        if (!hivemoduleXmlParentFile.exists() && !hivemoduleXmlParentFile.mkdirs()) {
            throw new IOException("Failed to create folder: " + hivemoduleXmlParentFile.getAbsolutePath());
        }
        if (!hivemoduleXmlFile.exists() && !hivemoduleXmlFile.createNewFile()) {
            throw new IOException("Failed to create file: " + hivemoduleXmlFile.getAbsolutePath());
        }
        try (FileOutputStream fileStream = new FileOutputStream(hivemoduleXmlFile);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileStream, StandardCharsets.UTF_8);){
            writer.write(HivemoduleGenerator.substituteVariablesInTemplate(servicePointsConfFile, substituteEnvVar, sha1Hash));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static String substituteVariablesInTemplate(File servicePointsConfFile, boolean substituteEnvVar, String newSha1Hash) throws IOException, StringSubstituter.UnRecognizedKeyException {
        String templateContent = HivemoduleGenerator.loadHivemoduleTemplate();
        if (newSha1Hash != null && newSha1Hash.length() > 0) {
            templateContent = HivemoduleGenerator.updateFingerprintHash(templateContent, newSha1Hash);
        }
        return StringSubstituter.substituteValues(templateContent, HivemoduleGenerator.getProperties(servicePointsConfFile, substituteEnvVar));
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NULL_VALUE", "NP_LOAD_OF_KNOWN_NULL_VALUE", "RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="introduced by java 11 language level change")
    private static String loadHivemoduleTemplate() throws IOException {
        block11: {
            try (InputStream inputStream = HivemoduleGenerator.class.getResourceAsStream(HIVEMODULE_TEMPLATE_PATH);){
                String string;
                if (inputStream == null) break block11;
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                    string = bufferedReader.lines().collect(Collectors.joining("\n"));
                }
                return string;
            }
        }
        throw new IOException("Failed to load /template/hivemodule-template.xml");
    }

    public static Properties getProperties(File servicePointsConfFile, boolean substituteEnvVar) throws IOException {
        Properties props = new Properties();
        try (FileInputStream inputStream = new FileInputStream(servicePointsConfFile);){
            if (substituteEnvVar) {
                EnvironmentVariableUtil.loadPropertyWithEnvVar(props, inputStream, SERVICE_POINTS_CONF_FILE);
            } else {
                props.load(inputStream);
            }
        }
        return props;
    }

    private static String updateFingerprintHash(String content, String sha1Hash) {
        String fingerprintLine = "<!-- Fingerprint:" + sha1Hash + " -->\n";
        Matcher matcher = FINGERPRINT_PATTERN.matcher(content);
        Object updatedContent = matcher.find() ? content.replaceFirst(FINGERPRINT_REGEX, fingerprintLine) : fingerprintLine + content;
        return updatedContent;
    }

    private static String getPrevSha1Hash(File generatedHivemoduleXml) throws IOException {
        String preSha1Hash = null;
        try (BufferedReader bufferedReader = Files.newBufferedReader(generatedHivemoduleXml.toPath(), StandardCharsets.UTF_8);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                Matcher matcher = FINGERPRINT_PATTERN.matcher(line);
                if (!matcher.find()) continue;
                preSha1Hash = matcher.group(1);
                break;
            }
        }
        return preSha1Hash != null ? preSha1Hash.trim() : null;
    }

    private static String generateSha1Hash(File servicePointsConf) throws IOException, NoSuchAlgorithmException {
        MessageDigest sha1Digest = MessageDigest.getInstance(SHA1_ALG);
        byte[] hashedBytes = sha1Digest.digest(HivemoduleGenerator.getByteBuffer(servicePointsConf).array());
        return Base64.getEncoder().encodeToString(hashedBytes);
    }

    private static ByteBuffer getByteBuffer(File servicePointsConf) throws IOException {
        byte[] hivemoduleTemplateBytes = HivemoduleGenerator.loadHivemoduleTemplate().getBytes(StandardCharsets.UTF_8);
        byte[] servicePointConfBytes = HivemoduleGenerator.getServicePointsProperties(servicePointsConf).getBytes(StandardCharsets.UTF_8);
        ByteBuffer buffer = ByteBuffer.allocate(hivemoduleTemplateBytes.length + servicePointConfBytes.length);
        buffer.put(hivemoduleTemplateBytes);
        buffer.put(servicePointConfBytes);
        return buffer;
    }

    private static String getServicePointsProperties(File servicePointsConf) throws IOException {
        Properties properties = new Properties();
        try (InputStream inputStream = Files.newInputStream(servicePointsConf.toPath(), new OpenOption[0]);
             InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            EnvironmentVariableUtil.loadPropertyWithEnvVar(properties, reader, SERVICE_POINTS_CONF_FILE);
        }
        return new TreeMap<Object, Object>(properties).toString();
    }
}

