/*
 * Decompiled with CFR 0.152.
 */
package org.pingidentity.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class LoggingUtil {
    private static final String PF_HOME = "pf.home";
    private static final String BOOT_LOG_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss,SSS";
    private final PrintStream bootLog = this.getBootLogPrintStream();

    public PrintStream getBootLog() {
        return this.bootLog;
    }

    private PrintStream getBootLogPrintStream() throws IOException {
        File bootLogFile;
        File logDirFile = new File(System.getProperty(PF_HOME), "log");
        if (!logDirFile.exists() && !logDirFile.mkdirs()) {
            this.logError("Unable to create directory at " + logDirFile.getAbsolutePath());
        }
        if (!(bootLogFile = new File(logDirFile.getPath(), "init.log")).exists() && !bootLogFile.createNewFile()) {
            this.logError("Unable to create file at " + bootLogFile.getAbsolutePath());
        }
        return new PrintStream((OutputStream)new FileOutputStream(bootLogFile, true), false, "UTF-8");
    }

    public void logMessage(String message) {
        message = LoggingUtil.getTimeString() + " " + (String)message;
        this.bootLog.println((String)message);
    }

    public void logError(String message) {
        message = LoggingUtil.getTimeString() + " ERROR: " + (String)message;
        System.err.println((String)message);
        this.bootLog.println((String)message);
    }

    private static String getTimeString() {
        return new SimpleDateFormat(BOOT_LOG_DATE_FORMAT).format(new Date());
    }

    public void logPfEnvironmentVariables() {
        String START_BORDER = "====================== PF Environment Variables =========================\n";
        String END_BORDER = "=========================================================================";
        String PF_PREFIX = "PF_";
        Map<String, String> envVars = System.getenv();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> env : envVars.entrySet()) {
            String key = env.getKey().toUpperCase();
            if (!key.startsWith(PF_PREFIX)) continue;
            String value = env.getValue();
            if (key.contains("PASSWORD") || key.contains("PWD") || key.contains("SECRET")) {
                value = "****";
            }
            sb.append(String.format("%s %s = %s %n", LoggingUtil.getTimeString(), env.getKey(), value));
        }
        if (sb.length() > 0) {
            this.logMessage(START_BORDER);
            this.bootLog.println(sb);
            this.logMessage(END_BORDER);
        }
    }

    public void logErrorAndHaltStartup(String message) {
        this.logError(message);
        Runtime.getRuntime().halt(1);
    }
}

