/*
 * Decompiled with CFR 0.152.
 */
package org.pingidentity.utils;

public class VersionComparisonUtil {
    public static int compareVersions(String jarName, String file1Name, String file2Name) {
        String version1String = VersionComparisonUtil.getVersionFromFileName(file1Name, jarName);
        String version2String = VersionComparisonUtil.getVersionFromFileName(file2Name, jarName);
        String validVersionPattern = "[0-9]+(\\.[0-9]+)*";
        if (!version1String.matches(validVersionPattern)) {
            return -1;
        }
        if (!version2String.matches(validVersionPattern)) {
            return 1;
        }
        String[] file1VersionTokens = version1String.split("\\.");
        String[] file2VersionTokens = version2String.split("\\.");
        int maxVersionStringLength = Math.max(file1VersionTokens.length, file2VersionTokens.length);
        for (int i = 0; i < maxVersionStringLength; ++i) {
            int v2;
            int v1 = i < file1VersionTokens.length ? Integer.parseInt(file1VersionTokens[i]) : 0;
            int n = v2 = i < file2VersionTokens.length ? Integer.parseInt(file2VersionTokens[i]) : 0;
            if (v1 > v2) {
                return 1;
            }
            if (v1 >= v2) continue;
            return -1;
        }
        return 0;
    }

    private static String getVersionFromFileName(String fileName, String jarName) {
        String versionString = fileName.replace(jarName, "").replace("-", "");
        versionString = versionString.substring(0, versionString.lastIndexOf("."));
        return versionString;
    }
}

