/*
 * Decompiled with CFR 0.152.
 */
package org.pingidentity.validate;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.pingidentity.utils.LoggingUtil;

public class AdminApiAuthPropertyValidator {
    private static final String RUN_PROPS = "run.properties";
    private static final String PF_AUTHENTICATION_ADMIN_API_PROPERTY = "pf.admin.api.authentication";
    public static final String PF_AUTHENTICATION_PROPERTY_NONE = "none";
    public static final String PF_AUTHENTICATION_PROPERTY_NATIVE = "native";
    public static final String PF_AUTHENTICATION_PROPERTY_LDAP = "LDAP";
    public static final String PF_AUTHENTICATION_PROPERTY_RADIUS = "RADIUS";
    public static final String PF_AUTHENTICATION_PROPERTY_OAUTH = "OAuth2";
    public static final String PF_AUTHENTICATION_PROPERTY_CERT = "cert";
    public static final String PF_AUTHENTICATION_PROPERTY_JWT = "JWT";
    private static final String ADMIN_API_AUTHENTICATION_PROPERTY_SEPARATOR = ",";
    private final LoggingUtil loggingUtil;

    public AdminApiAuthPropertyValidator(LoggingUtil loggingUtil) {
        this.loggingUtil = loggingUtil;
    }

    public boolean isAdminApiAuthPropertyValid(String propertyValue) {
        if (propertyValue == null || propertyValue.trim().isEmpty()) {
            this.loggingUtil.logMessage("No value is found for pf.admin.api.authentication. Default value will be used.");
            return true;
        }
        String[] values = propertyValue.split(ADMIN_API_AUTHENTICATION_PROPERTY_SEPARATOR);
        Set authMethods = Arrays.stream(values).map(String::trim).filter(m -> !m.isEmpty()).collect(Collectors.toSet());
        if (authMethods.isEmpty()) {
            this.loggingUtil.logError("Invalid value found in pf.admin.api.authentication in run.properties.");
            return false;
        }
        if (authMethods.size() != values.length) {
            this.loggingUtil.logError("Duplicate values found in pf.admin.api.authentication in run.properties.");
            return false;
        }
        if (authMethods.size() > 1 && (authMethods.contains(PF_AUTHENTICATION_PROPERTY_CERT) || authMethods.contains(PF_AUTHENTICATION_PROPERTY_NONE))) {
            this.loggingUtil.logError("Invalid value of pf.admin.api.authentication in run.properties. None and cert cannot be used with any other authentication methods.");
            return false;
        }
        if (authMethods.size() > 1 && authMethods.contains(PF_AUTHENTICATION_PROPERTY_JWT) && authMethods.contains(PF_AUTHENTICATION_PROPERTY_OAUTH)) {
            this.loggingUtil.logError("Invalid value of pf.admin.api.authentication in run.properties. JWT and OAuth2 cannot be used at the same time.");
            return false;
        }
        int basicAuthMethodCount = 0;
        for (String authMethod : authMethods) {
            if (!this.isAdminApiAuthMethodValid(authMethod)) {
                this.loggingUtil.logError("Invalid value of pf.admin.api.authentication:" + authMethod + " in run.properties.");
                return false;
            }
            if (!this.isBasicAuthMethod(authMethod) || ++basicAuthMethodCount <= 1) continue;
            this.loggingUtil.logError("More than one basic authentication method is not allowed in pf.admin.api.authentication in run.properties.");
            return false;
        }
        return true;
    }

    private boolean isAdminApiAuthMethodValid(String authMethod) {
        return PF_AUTHENTICATION_PROPERTY_OAUTH.equalsIgnoreCase(authMethod) || PF_AUTHENTICATION_PROPERTY_NONE.equalsIgnoreCase(authMethod) || PF_AUTHENTICATION_PROPERTY_CERT.equalsIgnoreCase(authMethod) || PF_AUTHENTICATION_PROPERTY_JWT.equalsIgnoreCase(authMethod) || this.isBasicAuthMethod(authMethod);
    }

    private boolean isBasicAuthMethod(String authMethod) {
        return PF_AUTHENTICATION_PROPERTY_NATIVE.equalsIgnoreCase(authMethod) || PF_AUTHENTICATION_PROPERTY_LDAP.equalsIgnoreCase(authMethod) || PF_AUTHENTICATION_PROPERTY_RADIUS.equalsIgnoreCase(authMethod);
    }
}

