/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.asset;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.ApplicationServlet;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IResourceResolver;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.IPropertySource;
import org.apache.tapestry.util.StringSplitter;

public class AssetExternalizer {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$asset$AssetExternalizer == null ? (class$org$apache$tapestry$asset$AssetExternalizer = AssetExternalizer.class$("org.apache.tapestry.asset.AssetExternalizer")) : class$org$apache$tapestry$asset$AssetExternalizer));
    private IResourceResolver _resolver;
    private File _assetDir;
    private String _URL;
    private Map _resources = new HashMap();
    private static final int BUFFER_SIZE = 2048;
    static /* synthetic */ Class class$org$apache$tapestry$asset$AssetExternalizer;

    protected AssetExternalizer(IRequestCycle cycle) {
        this._resolver = cycle.getEngine().getResourceResolver();
        IPropertySource properties = cycle.getEngine().getPropertySource();
        String directory = properties.getPropertyValue("org.apache.tapestry.asset.dir");
        if (directory == null) {
            return;
        }
        this._URL = properties.getPropertyValue("org.apache.tapestry.asset.URL");
        if (this._URL == null) {
            return;
        }
        this._assetDir = new File(directory);
        LOG.debug((Object)("Initialized with directory " + this._assetDir + " mapped to " + this._URL));
    }

    protected void externalize(String resourcePath) throws IOException {
        int bytesRead;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Externalizing " + resourcePath));
        }
        File file = this._assetDir;
        StringSplitter splitter = new StringSplitter('/');
        String[] path = splitter.splitToArray(resourcePath);
        for (int i = 0; i < path.length - 1; ++i) {
            file = new File(file, path[i]);
        }
        file.mkdirs();
        file = new File(file, path[path.length - 1]);
        if (file.exists()) {
            return;
        }
        URL inputURL = this._resolver.getResource(resourcePath);
        if (inputURL == null) {
            throw new IOException(Tapestry.format("missing-resource", resourcePath));
        }
        InputStream in = inputURL.openStream();
        FileOutputStream out = new FileOutputStream(file);
        byte[] buffer = new byte[2048];
        while ((bytesRead = in.read(buffer, 0, 2048)) >= 0) {
            ((OutputStream)out).write(buffer, 0, bytesRead);
        }
        in.close();
        ((OutputStream)out).close();
    }

    public static AssetExternalizer get(IRequestCycle cycle) {
        ApplicationServlet servlet = cycle.getRequestContext().getServlet();
        ServletContext context = servlet.getServletContext();
        String servletName = servlet.getServletName();
        String attributeName = "org.apache.tapestry.AssetExternalizer:" + servletName;
        AssetExternalizer result = (AssetExternalizer)context.getAttribute(attributeName);
        if (result == null) {
            result = new AssetExternalizer(cycle);
            context.setAttribute(attributeName, (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getURL(String resourcePath) {
        if (this._assetDir == null) {
            return null;
        }
        Map map = this._resources;
        synchronized (map) {
            String result = (String)this._resources.get(resourcePath);
            if (result != null) {
                return result;
            }
            try {
                this.externalize(resourcePath);
            }
            catch (IOException ex) {
                throw new ApplicationRuntimeException(Tapestry.format("AssetExternalizer.externalize-failure", resourcePath, this._assetDir), ex);
            }
            result = this._URL + resourcePath;
            this._resources.put(resourcePath, result);
            return result;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

