/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.asset;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.AbstractService;
import org.apache.tapestry.engine.IEngineServiceView;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.request.ResponseOutputStream;

public class AssetService
extends AbstractService {
    private static final Map _mimeTypes = new HashMap(17);
    private static final int BUFFER_SIZE = 10240;

    public ILink getLink(IRequestCycle cycle, IComponent component, Object[] parameters) {
        if (Tapestry.size(parameters) != 2) {
            throw new ApplicationRuntimeException(Tapestry.format("service-incorrect-parameter-count", "asset", new Integer(2)));
        }
        return this.constructLink(cycle, "asset", null, parameters, false);
    }

    public String getName() {
        return "asset";
    }

    private static String getMimeType(String path) {
        int dotx = path.lastIndexOf(46);
        String key = path.substring(dotx + 1).toLowerCase();
        String result = (String)_mimeTypes.get(key);
        if (result == null) {
            result = "text/plain";
        }
        return result;
    }

    public void service(IEngineServiceView engine, IRequestCycle cycle, ResponseOutputStream output) throws IOException {
        Object[] parameters = this.getParameters(cycle);
        if (Tapestry.size(parameters) != 2) {
            throw new ApplicationRuntimeException(Tapestry.format("service-incorrect-parameter-count", "asset", new Integer(2)));
        }
        String resourcePath = (String)parameters[0];
        String checksum = (String)parameters[1];
        URL resourceURL = engine.getResourceResolver().getResource(resourcePath);
        if (resourceURL == null) {
            throw new ApplicationRuntimeException(Tapestry.format("missing-resource", resourcePath));
        }
        String actualChecksum = engine.getResourceChecksumSource().getChecksum(resourceURL);
        if (!actualChecksum.equals(checksum)) {
            throw new ApplicationRuntimeException(Tapestry.format("AssetService.checksum-failure", checksum, resourcePath));
        }
        URLConnection resourceConnection = resourceURL.openConnection();
        ServletContext servletContext = cycle.getRequestContext().getServlet().getServletContext();
        this.writeAssetContent(engine, cycle, output, resourcePath, resourceConnection, servletContext);
    }

    private void writeAssetContent(IEngineServiceView engine, IRequestCycle cycle, ResponseOutputStream output, String resourcePath, URLConnection resourceConnection, ServletContext servletContext) {
        String contentType = servletContext.getMimeType(resourcePath);
        int contentLength = resourceConnection.getContentLength();
        try {
            int bytesRead;
            if (contentLength > 0) {
                cycle.getRequestContext().getResponse().setContentLength(contentLength);
            }
            if (contentType == null || contentType.length() == 0) {
                contentType = AssetService.getMimeType(resourcePath);
            }
            output.setContentType(contentType);
            output.forceFlush();
            InputStream input = resourceConnection.getInputStream();
            byte[] buffer = new byte[10240];
            while ((bytesRead = input.read(buffer)) >= 0) {
                output.write(buffer, 0, bytesRead);
            }
            input.close();
        }
        catch (Throwable ex) {
            String title = Tapestry.format("AssetService.exception-report-title", resourcePath);
            engine.reportException(title, ex);
        }
    }

    static {
        _mimeTypes.put("css", "text/css");
        _mimeTypes.put("gif", "image/gif");
        _mimeTypes.put("jpg", "image/jpeg");
        _mimeTypes.put("jpeg", "image/jpeg");
        _mimeTypes.put("htm", "text/html");
        _mimeTypes.put("html", "text/html");
    }
}

