/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.bean;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IBeanProvider;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IResourceResolver;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.bean.IBeanInitializer;
import org.apache.tapestry.event.PageDetachListener;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageRenderListener;
import org.apache.tapestry.spec.BeanLifecycle;
import org.apache.tapestry.spec.IBeanSpecification;
import org.apache.tapestry.spec.IComponentSpecification;

public class BeanProvider
implements IBeanProvider,
PageDetachListener,
PageRenderListener {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$bean$BeanProvider == null ? (class$org$apache$tapestry$bean$BeanProvider = BeanProvider.class$("org.apache.tapestry.bean.BeanProvider")) : class$org$apache$tapestry$bean$BeanProvider));
    private boolean _registeredForDetach = false;
    private boolean _registeredForRender = false;
    private IComponent _component;
    private IResourceResolver _resolver;
    private Map _beans;
    private Set _beanNames;
    static /* synthetic */ Class class$org$apache$tapestry$bean$BeanProvider;

    public BeanProvider(IComponent component) {
        this._component = component;
        IEngine engine = component.getPage().getEngine();
        this._resolver = engine.getResourceResolver();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created BeanProvider for " + component));
        }
    }

    public Collection getBeanNames() {
        if (this._beanNames == null) {
            Collection c = this._component.getSpecification().getBeanNames();
            this._beanNames = c == null || c.isEmpty() ? Collections.EMPTY_SET : Collections.unmodifiableSet(new HashSet(c));
        }
        return this._beanNames;
    }

    public IComponent getComponent() {
        return this._component;
    }

    public Object getBean(String name) {
        Object bean = null;
        if (this._beans != null) {
            bean = this._beans.get(name);
        }
        if (bean != null) {
            return bean;
        }
        IBeanSpecification spec = this._component.getSpecification().getBeanSpecification(name);
        if (spec == null) {
            throw new ApplicationRuntimeException(Tapestry.format("BeanProvider.bean-not-defined", this._component.getExtendedId(), name));
        }
        bean = this.instantiateBean(name, spec);
        BeanLifecycle lifecycle = spec.getLifecycle();
        if (lifecycle == BeanLifecycle.NONE) {
            return bean;
        }
        if (this._beans == null) {
            this._beans = new HashMap();
        }
        this._beans.put(name, bean);
        if (lifecycle == BeanLifecycle.REQUEST && !this._registeredForDetach) {
            this._component.getPage().addPageDetachListener(this);
            this._registeredForDetach = true;
        }
        if (lifecycle == BeanLifecycle.RENDER && !this._registeredForRender) {
            this._component.getPage().addPageRenderListener(this);
            this._registeredForRender = true;
        }
        return bean;
    }

    private Object instantiateBean(String beanName, IBeanSpecification spec) {
        String className = spec.getClassName();
        Object bean = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Instantiating instance of " + className));
        }
        try {
            Class beanClass = this._resolver.findClass(className);
            bean = beanClass.newInstance();
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(Tapestry.format("BeanProvider.instantiation-error", new Object[]{beanName, this._component.getExtendedId(), className, ex.getMessage()}), spec.getLocation(), ex);
        }
        List initializers = spec.getInitializers();
        if (initializers == null) {
            return bean;
        }
        Iterator i = initializers.iterator();
        while (i.hasNext()) {
            IBeanInitializer iz = (IBeanInitializer)i.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Initializing property " + iz.getPropertyName()));
            }
            iz.setBeanProperty(this, bean);
        }
        return bean;
    }

    public void pageDetached(PageEvent event) {
        this.removeBeans(BeanLifecycle.REQUEST);
    }

    private void removeBeans(BeanLifecycle lifecycle) {
        if (this._beans == null) {
            return;
        }
        IComponentSpecification spec = null;
        Iterator i = this._beans.entrySet().iterator();
        while (i.hasNext()) {
            IBeanSpecification s;
            Map.Entry e = i.next();
            String name = (String)e.getKey();
            if (spec == null) {
                spec = this._component.getSpecification();
            }
            if ((s = spec.getBeanSpecification(name)).getLifecycle() != lifecycle) continue;
            Object bean = e.getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing " + lifecycle.getName() + " bean " + name + ": " + bean));
            }
            i.remove();
        }
    }

    public IResourceResolver getResourceResolver() {
        return this._resolver;
    }

    public void pageBeginRender(PageEvent event) {
    }

    public void pageEndRender(PageEvent event) {
        this.removeBeans(BeanLifecycle.RENDER);
    }

    public boolean canProvideBean(String name) {
        return this.getBeanNames().contains(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

