/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.engine;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.ApplicationServlet;
import org.apache.tapestry.IEngine;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.INamespace;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IResourceResolver;
import org.apache.tapestry.PageRedirectException;
import org.apache.tapestry.RedirectException;
import org.apache.tapestry.StaleLinkException;
import org.apache.tapestry.StaleSessionException;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.asset.ResourceChecksumSource;
import org.apache.tapestry.asset.ResourceChecksumSourceImpl;
import org.apache.tapestry.engine.BSFManagerPoolableAdaptor;
import org.apache.tapestry.engine.DefaultComponentMessagesSource;
import org.apache.tapestry.engine.DefaultMonitorFactory;
import org.apache.tapestry.engine.DefaultScriptSource;
import org.apache.tapestry.engine.DefaultSpecificationSource;
import org.apache.tapestry.engine.DefaultTemplateSource;
import org.apache.tapestry.engine.IComponentClassEnhancer;
import org.apache.tapestry.engine.IComponentMessagesSource;
import org.apache.tapestry.engine.IEngineService;
import org.apache.tapestry.engine.IEngineServiceView;
import org.apache.tapestry.engine.IMonitor;
import org.apache.tapestry.engine.IMonitorFactory;
import org.apache.tapestry.engine.IPageRecorder;
import org.apache.tapestry.engine.IPageSource;
import org.apache.tapestry.engine.IPropertySource;
import org.apache.tapestry.engine.IScriptSource;
import org.apache.tapestry.engine.ISpecificationSource;
import org.apache.tapestry.engine.ITemplateSource;
import org.apache.tapestry.engine.RequestCycle;
import org.apache.tapestry.enhance.DefaultComponentClassEnhancer;
import org.apache.tapestry.listener.ListenerMap;
import org.apache.tapestry.pageload.PageSource;
import org.apache.tapestry.request.RequestContext;
import org.apache.tapestry.request.ResponseOutputStream;
import org.apache.tapestry.spec.IApplicationSpecification;
import org.apache.tapestry.util.DelegatingPropertySource;
import org.apache.tapestry.util.PropertyHolderPropertySource;
import org.apache.tapestry.util.ResourceBundlePropertySource;
import org.apache.tapestry.util.ServletContextPropertySource;
import org.apache.tapestry.util.ServletPropertySource;
import org.apache.tapestry.util.SystemPropertiesPropertySource;
import org.apache.tapestry.util.io.DataSqueezer;
import org.apache.tapestry.util.pool.Pool;

public abstract class AbstractEngine
implements IEngine,
IEngineServiceView,
Externalizable,
HttpSessionBindingListener {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$engine$AbstractEngine == null ? (class$org$apache$tapestry$engine$AbstractEngine = AbstractEngine.class$("org.apache.tapestry.engine.AbstractEngine")) : class$org$apache$tapestry$engine$AbstractEngine));
    private static final long serialVersionUID = 6884834397673817117L;
    private transient String _contextPath;
    private transient String _servletPath;
    private transient String _clientAddress;
    private transient String _sessionId;
    private transient boolean _stateful;
    private transient ListenerMap _listeners;
    private transient DataSqueezer _dataSqueezer;
    private Object _visit;
    private transient Object _global;
    public static final String GLOBAL_NAME = "org.apache.tapestry.global";
    public static final String OUTPUT_ENCODING_PROPERTY_NAME = "org.apache.tapestry.output-encoding";
    public static final String DEFAULT_OUTPUT_ENCODING = "UTF-8";
    private Locale _locale;
    private boolean _localeChanged;
    protected transient IApplicationSpecification _specification;
    protected transient ITemplateSource _templateSource;
    protected transient ISpecificationSource _specificationSource;
    private transient IScriptSource _scriptSource;
    protected static final String SCRIPT_SOURCE_NAME = "org.apache.tapestry.ScriptSource";
    protected static final String STRINGS_SOURCE_NAME = "org.apache.tapestry.StringsSource";
    private transient IComponentMessagesSource _stringsSource;
    public static final String VISIT_CLASS_PROPERTY_NAME = "org.apache.tapestry.visit-class";
    protected static final String TEMPLATE_SOURCE_NAME = "org.apache.tapestry.TemplateSource";
    protected static final String SPECIFICATION_SOURCE_NAME = "org.apache.tapestry.SpecificationSource";
    protected static final String PAGE_SOURCE_NAME = "org.apache.tapestry.PageSource";
    protected static final String DATA_SQUEEZER_NAME = "org.apache.tapestry.DataSqueezer";
    protected static final String RESOURCE_CHECKSUM_SOURCE_NAME = "org.apache.tapestry.ResourceChecksumSource";
    private transient IPageSource _pageSource;
    private static final boolean _resetServiceEnabled = Boolean.getBoolean("org.apache.tapestry.enable-reset-service");
    private static final boolean _disableCaching = Boolean.getBoolean("org.apache.tapestry.disable-caching");
    private transient IResourceResolver _resolver;
    protected static final String PROPERTY_SOURCE_NAME = "org.apache.tapestry.PropertySource";
    private transient IPropertySource _propertySource;
    private transient Map _serviceMap;
    protected static final String SERVICE_MAP_NAME = "org.apache.tapestry.ServiceMap";
    private transient Pool _pool;
    protected static final String POOL_NAME = "org.apache.tapestry.Pool";
    protected static final String ENHANCER_NAME = "org.apache.tapestry.ComponentClassEnhancer";
    private transient IComponentClassEnhancer _enhancer;
    private transient boolean _dirty;
    private transient IMonitorFactory _monitorFactory;
    private transient ResourceChecksumSource _resourceChecksumSource;
    private static final String EXTENSION_PROPERTY_SOURCE_NAME = "org.apache.tapestry.property-source";
    static /* synthetic */ Class class$org$apache$tapestry$engine$AbstractEngine;
    static /* synthetic */ Class class$org$apache$tapestry$engine$IMonitorFactory;
    static /* synthetic */ Class class$org$apache$tapestry$engine$IPropertySource;
    static /* synthetic */ Class class$org$apache$bsf$BSFManager;

    protected void activateExceptionPage(IRequestCycle cycle, ResponseOutputStream output, Throwable cause) throws ServletException {
        try {
            IPage exceptionPage = cycle.getPage(this.getExceptionPageName());
            exceptionPage.setProperty("exception", cause);
            cycle.activate(exceptionPage);
            this.renderResponse(cycle, output);
        }
        catch (Throwable ex) {
            this.reportException(Tapestry.getMessage("AbstractEngine.unable-to-process-client-request"), cause);
            this.reportException(Tapestry.getMessage("AbstractEngine.unable-to-present-exception-page"), ex);
            throw new ServletException(ex.getMessage(), ex);
        }
    }

    public void reportException(String reportTitle, Throwable ex) {
        LOG.warn((Object)reportTitle, ex);
    }

    protected abstract void cleanupAfterRequest(IRequestCycle var1);

    protected void extendDescription(ToStringBuilder builder) {
    }

    public Locale getLocale() {
        return this._locale;
    }

    public IMonitor getMonitor(RequestContext context) {
        if (this._monitorFactory == null) {
            this._monitorFactory = this._specification.checkExtension("org.apache.tapestry.monitor-factory") ? (IMonitorFactory)this._specification.getExtension("org.apache.tapestry.monitor-factory", class$org$apache$tapestry$engine$IMonitorFactory == null ? (class$org$apache$tapestry$engine$IMonitorFactory = AbstractEngine.class$("org.apache.tapestry.engine.IMonitorFactory")) : class$org$apache$tapestry$engine$IMonitorFactory) : DefaultMonitorFactory.SHARED;
        }
        return this._monitorFactory.createMonitor(context);
    }

    public IPageSource getPageSource() {
        return this._pageSource;
    }

    public IEngineService getService(String name) {
        IEngineService result = (IEngineService)this._serviceMap.get(name);
        String encodedName = name.replace("\n", "<LF>").replace("\r", "<CR>");
        encodedName = encodedName + "(ENCODED)";
        if (result == null) {
            throw new ApplicationRuntimeException(Tapestry.format("AbstractEngine.unknown-service", encodedName));
        }
        return result;
    }

    public String getServletPath() {
        return this._servletPath;
    }

    public String getContextPath() {
        return this._contextPath;
    }

    public IApplicationSpecification getSpecification() {
        return this._specification;
    }

    public ISpecificationSource getSpecificationSource() {
        return this._specificationSource;
    }

    public ITemplateSource getTemplateSource() {
        return this._templateSource;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._stateful = true;
        String localeName = in.readUTF();
        this._locale = Tapestry.getLocale(localeName);
        this._visit = in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this._locale.toString());
        out.writeObject(this._visit);
    }

    protected void redirect(String pageName, IRequestCycle cycle, ResponseOutputStream out, ApplicationRuntimeException exception) throws IOException, ServletException {
        out.reset();
        IPage page = cycle.getPage(pageName);
        cycle.activate(page);
        this.renderResponse(cycle, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderResponse(IRequestCycle cycle, ResponseOutputStream output) throws ServletException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Begin render response.");
        }
        if (this._localeChanged) {
            this._localeChanged = false;
            RequestContext context = cycle.getRequestContext();
            ApplicationServlet servlet = context.getServlet();
            servlet.writeLocaleCookie(this._locale, this, context);
        }
        IPage page = cycle.getPage();
        IMarkupWriter writer = page.getResponseWriter(output);
        output.setContentType(writer.getContentType());
        boolean discard = true;
        try {
            cycle.renderPage(writer);
            discard = false;
            Object var7_6 = null;
            if (discard) {
                output.setDiscard(true);
            }
            writer.close();
            if (discard) {
                output.setDiscard(false);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (discard) {
                output.setDiscard(true);
            }
            writer.close();
            if (discard) {
                output.setDiscard(false);
            }
            throw throwable;
        }
    }

    public void restart(IRequestCycle cycle) throws IOException {
        RequestContext context;
        block3: {
            context = cycle.getRequestContext();
            HttpSession session = context.getSession();
            if (session != null) {
                try {
                    session.invalidate();
                }
                catch (IllegalStateException ex) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug((Object)"Exception thrown invalidating HttpSession.", (Throwable)ex);
                }
            }
        }
        this._stateful = false;
        String url = context.getAbsoluteURL(this._servletPath);
        context.redirect(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean service(RequestContext context) throws ServletException, IOException {
        block43: {
            block38: {
                block42: {
                    block39: {
                        servlet = context.getServlet();
                        cycle = null;
                        output = null;
                        monitor = null;
                        if (AbstractEngine.LOG.isDebugEnabled()) {
                            AbstractEngine.LOG.debug((Object)("Begin service " + context.getRequestURI()));
                        }
                        if (this._specification == null) {
                            this._specification = servlet.getApplicationSpecification();
                        }
                        this._localeChanged = false;
                        if (this._resolver == null) {
                            this._resolver = servlet.getResourceResolver();
                        }
                        try {
                            this.setupForRequest(context);
                            monitor = this.getMonitor(context);
                            output = new ResponseOutputStream(context.getResponse());
                        }
                        catch (Exception ex) {
                            this.reportException(Tapestry.getMessage("AbstractEngine.unable-to-begin-request"), ex);
                            throw new ServletException(ex.getMessage(), (Throwable)ex);
                        }
                        service = null;
                        try {
                            try {
                                try {
                                    try {
                                        serviceName = this.extractServiceName(context);
                                        if (Tapestry.isBlank(serviceName)) {
                                            serviceName = "home";
                                        }
                                        service = this.getService(serviceName);
                                    }
                                    catch (Exception ex) {
                                        service = this.getService("home");
                                        cycle = this.createRequestCycle(context, service, monitor);
                                        throw ex;
                                    }
                                    cycle = this.createRequestCycle(context, service, monitor);
                                    monitor.serviceBegin(serviceName, context.getRequestURI());
                                    service.service(this, cycle, output);
                                    var8_15 = this._dirty;
                                }
                                catch (PageRedirectException ex) {
                                    this.handlePageRedirectException(ex, cycle, output);
                                    break block38;
                                }
                                catch (RedirectException ex) {
                                    this.handleRedirectException(cycle, ex);
                                    break block38;
                                }
                                catch (StaleLinkException ex) {
                                    this.handleStaleLinkException(ex, cycle, output);
                                    break block38;
                                }
                                catch (StaleSessionException ex) {
                                    this.handleStaleSessionException(ex, cycle, output);
                                    break block38;
                                }
                                var10_16 = null;
                                if (service == null) break block39;
                                monitor.serviceEnd(service.getName());
                            }
                            catch (Exception ex) {
                                monitor.serviceException(ex);
                                output.reset();
                                if (AbstractEngine.LOG.isDebugEnabled()) {
                                    AbstractEngine.LOG.debug((Object)"Uncaught exception", (Throwable)ex);
                                }
                                this.activateExceptionPage(cycle, output, ex);
                                var10_18 = null;
                                if (service != null) {
                                    monitor.serviceEnd(service.getName());
                                }
                                try {
                                    try {
                                        cycle.cleanup();
                                        if (output != null) {
                                            output.forceFlush();
                                        }
                                        v0 = null;
                                    }
                                    catch (Exception ex) {
                                        this.reportException(Tapestry.getMessage("AbstractEngine.exception-during-cleanup"), ex);
                                        v0 = null;
                                    }
                                }
                                catch (Throwable var12_26) {
                                    v0 = null;
                                }
                                var13_30 = v0;
                                this.cleanupAfterRequest(cycle);
                                return this._dirty;
                            }
                        }
                        catch (Throwable var9_32) {
                            block41: {
                                var10_19 = null;
                                if (service != null) {
                                    monitor.serviceEnd(service.getName());
                                }
                                ** try [egrp 5[TRYBLOCK] [13 : 387->428)] { 
lbl89:
                                // 1 sources

                                ** try [egrp 6[TRYBLOCK] [12 : 387->403)] { 
lbl90:
                                // 1 sources

                                cycle.cleanup();
                                if (output != null) {
                                    output.forceFlush();
                                }
                                v1 = null;
lbl95:
                                // 1 sources

                                catch (Exception ex) {
                                    this.reportException(Tapestry.getMessage("AbstractEngine.exception-during-cleanup"), ex);
                                    v1 = null;
                                }
                                break block41;
lbl99:
                                // 1 sources

                                catch (Throwable var12_27) {
                                    v1 = null;
                                }
                            }
                            var13_31 = v1;
                            this.cleanupAfterRequest(cycle);
                            throw var9_32;
                        }
                    }
                    ** try [egrp 5[TRYBLOCK] [13 : 387->428)] { 
lbl107:
                    // 1 sources

                    ** try [egrp 6[TRYBLOCK] [12 : 387->403)] { 
lbl108:
                    // 1 sources

                    cycle.cleanup();
                    if (output != null) {
                        output.forceFlush();
                    }
                    v2 = null;
lbl113:
                    // 1 sources

                    catch (Exception ex) {
                        this.reportException(Tapestry.getMessage("AbstractEngine.exception-during-cleanup"), ex);
                        v2 = null;
                    }
                    break block42;
lbl117:
                    // 1 sources

                    catch (Throwable var12_24) {
                        v2 = null;
                    }
                }
                var13_28 = v2;
                this.cleanupAfterRequest(cycle);
                return var8_15;
            }
            var10_17 = null;
            if (service != null) {
                monitor.serviceEnd(service.getName());
            }
            ** try [egrp 5[TRYBLOCK] [13 : 387->428)] { 
lbl128:
            // 1 sources

            ** try [egrp 6[TRYBLOCK] [12 : 387->403)] { 
lbl129:
            // 1 sources

            cycle.cleanup();
            if (output != null) {
                output.forceFlush();
            }
            v3 = null;
lbl134:
            // 1 sources

            catch (Exception ex) {
                this.reportException(Tapestry.getMessage("AbstractEngine.exception-during-cleanup"), ex);
                v3 = null;
            }
            break block43;
lbl138:
            // 1 sources

            catch (Throwable var12_25) {
                v3 = null;
            }
        }
        var13_29 = v3;
        this.cleanupAfterRequest(cycle);
        return this._dirty;
    }

    protected void handlePageRedirectException(PageRedirectException ex, IRequestCycle cycle, ResponseOutputStream output) throws IOException, ServletException {
        ArrayList<String> pageNames = new ArrayList<String>();
        String pageName = ex.getTargetPageName();
        while (true) {
            if (pageNames.contains(pageName)) {
                pageNames.add(pageName);
                StringBuffer buffer = new StringBuffer();
                int count = pageNames.size();
                for (int i = 0; i < count; ++i) {
                    if (i > 0) {
                        buffer.append("; ");
                    }
                    buffer.append(pageNames.get(i));
                }
                throw new ApplicationRuntimeException(Tapestry.format("AbstractEngine.validate-cycle", buffer.toString()));
            }
            pageNames.add(pageName);
            try {
                cycle.activate(pageName);
            }
            catch (PageRedirectException ex2) {
                pageName = ex2.getTargetPageName();
                continue;
            }
            break;
        }
        output.reset();
        this.renderResponse(cycle, output);
    }

    protected IRequestCycle createRequestCycle(RequestContext context, IEngineService service, IMonitor monitor) {
        return new RequestCycle(this, context, service, monitor);
    }

    protected void handleStaleLinkException(StaleLinkException ex, IRequestCycle cycle, ResponseOutputStream output) throws IOException, ServletException {
        String staleLinkPageName = this.getStaleLinkPageName();
        IPage page = cycle.getPage(staleLinkPageName);
        page.setProperty("message", ex.getMessage());
        this.redirect(staleLinkPageName, cycle, output, ex);
    }

    protected void handleStaleSessionException(StaleSessionException ex, IRequestCycle cycle, ResponseOutputStream output) throws IOException, ServletException {
        this.redirect(this.getStaleSessionPageName(), cycle, output, ex);
    }

    public void clearCachedData() {
        this._pool.clear();
        this._pageSource.reset();
        this._specificationSource.reset();
        this._templateSource.reset();
        this._scriptSource.reset();
        this._stringsSource.reset();
        this._enhancer.reset();
        this._resourceChecksumSource.reset();
    }

    public void setLocale(Locale value) {
        if (value == null) {
            throw new IllegalArgumentException("May not change engine locale to null.");
        }
        if (!value.equals(this._locale)) {
            this._locale = value;
            this._localeChanged = true;
            this.markDirty();
        }
    }

    protected void setupForRequest(RequestContext context) {
        String encoding;
        String name;
        ApplicationServlet servlet = context.getServlet();
        ServletContext servletContext = servlet.getServletContext();
        HttpServletRequest request = context.getRequest();
        HttpSession session = context.getSession();
        this._sessionId = session != null ? context.getSession().getId() : null;
        if (this._clientAddress == null) {
            this._clientAddress = request.getRemoteAddr();
        }
        if (this._servletPath == null) {
            String path = (String)request.getAttribute("org.apache.tapestry.tagsupport.servlet-path");
            if (path == null) {
                path = request.getServletPath();
            }
            this._contextPath = request.getContextPath();
            this._servletPath = this._contextPath + path;
        }
        String servletName = context.getServlet().getServletName();
        if (this._propertySource == null) {
            name = "org.apache.tapestry.PropertySource:" + servletName;
            this._propertySource = (IPropertySource)servletContext.getAttribute(name);
            if (this._propertySource == null) {
                this._propertySource = this.createPropertySource(context);
                servletContext.setAttribute(name, (Object)this._propertySource);
            }
        }
        if (this._enhancer == null) {
            name = "org.apache.tapestry.ComponentClassEnhancer:" + servletName;
            this._enhancer = (IComponentClassEnhancer)servletContext.getAttribute(name);
            if (this._enhancer == null) {
                this._enhancer = this.createComponentClassEnhancer(context);
                servletContext.setAttribute(name, (Object)this._enhancer);
            }
        }
        if (this._pool == null) {
            name = "org.apache.tapestry.Pool:" + servletName;
            this._pool = (Pool)servletContext.getAttribute(name);
            if (this._pool == null) {
                this._pool = this.createPool(context);
                servletContext.setAttribute(name, (Object)this._pool);
            }
        }
        if (this._templateSource == null) {
            name = "org.apache.tapestry.TemplateSource:" + servletName;
            this._templateSource = (ITemplateSource)servletContext.getAttribute(name);
            if (this._templateSource == null) {
                this._templateSource = this.createTemplateSource(context);
                servletContext.setAttribute(name, (Object)this._templateSource);
            }
        }
        if (this._specificationSource == null) {
            name = "org.apache.tapestry.SpecificationSource:" + servletName;
            this._specificationSource = (ISpecificationSource)servletContext.getAttribute(name);
            if (this._specificationSource == null) {
                this._specificationSource = this.createSpecificationSource(context);
                servletContext.setAttribute(name, (Object)this._specificationSource);
            }
        }
        if (this._pageSource == null) {
            name = "org.apache.tapestry.PageSource:" + servletName;
            this._pageSource = (IPageSource)servletContext.getAttribute(name);
            if (this._pageSource == null) {
                this._pageSource = this.createPageSource(context);
                servletContext.setAttribute(name, (Object)this._pageSource);
            }
        }
        if (this._scriptSource == null) {
            name = "org.apache.tapestry.ScriptSource:" + servletName;
            this._scriptSource = (IScriptSource)servletContext.getAttribute(name);
            if (this._scriptSource == null) {
                this._scriptSource = this.createScriptSource(context);
                servletContext.setAttribute(name, (Object)this._scriptSource);
            }
        }
        if (this._serviceMap == null) {
            name = "org.apache.tapestry.ServiceMap:" + servletName;
            this._serviceMap = (Map)servletContext.getAttribute(name);
            if (this._serviceMap == null) {
                this._serviceMap = this.createServiceMap();
                servletContext.setAttribute(name, (Object)this._serviceMap);
            }
        }
        if (this._stringsSource == null) {
            name = "org.apache.tapestry.StringsSource:" + servletName;
            this._stringsSource = (IComponentMessagesSource)servletContext.getAttribute(name);
            if (this._stringsSource == null) {
                this._stringsSource = this.createComponentStringsSource(context);
                servletContext.setAttribute(name, (Object)this._stringsSource);
            }
        }
        if (this._dataSqueezer == null) {
            name = "org.apache.tapestry.DataSqueezer:" + servletName;
            this._dataSqueezer = (DataSqueezer)servletContext.getAttribute(name);
            if (this._dataSqueezer == null) {
                this._dataSqueezer = this.createDataSqueezer();
                servletContext.setAttribute(name, (Object)this._dataSqueezer);
            }
        }
        if (this._global == null) {
            name = "org.apache.tapestry.global:" + servletName;
            this._global = servletContext.getAttribute(name);
            if (this._global == null) {
                this._global = this.createGlobal(context);
                servletContext.setAttribute(name, this._global);
            }
        }
        if (this._resourceChecksumSource == null) {
            name = "org.apache.tapestry.ResourceChecksumSource:" + servletName;
            this._resourceChecksumSource = (ResourceChecksumSource)servletContext.getAttribute(name);
            if (this._resourceChecksumSource == null) {
                this._resourceChecksumSource = this.createResourceChecksumSource();
                servletContext.setAttribute(name, (Object)this._resourceChecksumSource);
            }
        }
        if ((encoding = request.getCharacterEncoding()) == null) {
            encoding = this.getOutputEncoding();
            try {
                request.setCharacterEncoding(encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException(Tapestry.format("illegal-encoding", encoding));
            }
            catch (NoSuchMethodError noSuchMethodError) {
            }
            catch (AbstractMethodError abstractMethodError) {
                // empty catch block
            }
        }
    }

    public IComponentMessagesSource createComponentStringsSource(RequestContext context) {
        return new DefaultComponentMessagesSource();
    }

    protected IScriptSource createScriptSource(RequestContext context) {
        return new DefaultScriptSource(this.getResourceResolver());
    }

    protected IPageSource createPageSource(RequestContext context) {
        return new PageSource(this);
    }

    protected ISpecificationSource createSpecificationSource(RequestContext context) {
        return new DefaultSpecificationSource(this.getResourceResolver(), this._specification, this._pool);
    }

    protected ITemplateSource createTemplateSource(RequestContext context) {
        return new DefaultTemplateSource();
    }

    protected ResourceChecksumSource createResourceChecksumSource() {
        return new ResourceChecksumSourceImpl("MD5", (BinaryEncoder)new Hex());
    }

    public IResourceResolver getResourceResolver() {
        return this._resolver;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("name", (Object)(this._specification == null ? Tapestry.getMessage("AbstractEngine.unknown-specification") : this._specification.getName()));
        builder.append("dirty", this._dirty);
        builder.append("locale", (Object)this._locale);
        builder.append("stateful", this._stateful);
        builder.append("visit", this._visit);
        this.extendDescription(builder);
        return builder.toString();
    }

    public boolean isResetServiceEnabled() {
        return _resetServiceEnabled;
    }

    public abstract Collection getActivePageNames();

    public Object getVisit() {
        if (this._visit != null) {
            this.markDirty();
        }
        return this._visit;
    }

    public Object getVisit(IRequestCycle cycle) {
        if (this._visit == null && cycle != null) {
            this._visit = this.createVisit(cycle);
            cycle.getRequestContext().createSession();
            this.setStateful();
        }
        if (this._visit != null) {
            this.markDirty();
        }
        return this._visit;
    }

    public void setVisit(Object value) {
        this._visit = value;
        this.markDirty();
    }

    public boolean getHasVisit() {
        return this._visit != null;
    }

    protected Object createVisit(IRequestCycle cycle) {
        Object result = null;
        String visitClassName = this._propertySource.getPropertyValue(VISIT_CLASS_PROPERTY_NAME);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating visit object as instance of " + visitClassName));
        }
        Class visitClass = this._resolver.findClass(visitClassName);
        try {
            result = visitClass.newInstance();
        }
        catch (Throwable t) {
            throw new ApplicationRuntimeException(Tapestry.format("AbstractEngine.unable-to-instantiate-visit", visitClassName), t);
        }
        return result;
    }

    public Object getGlobal() {
        return this._global;
    }

    public IScriptSource getScriptSource() {
        return this._scriptSource;
    }

    public boolean isStateful() {
        return this._stateful;
    }

    protected void setStateful() {
        this._stateful = true;
    }

    public ListenerMap getListeners() {
        if (this._listeners == null) {
            this._listeners = new ListenerMap(this);
        }
        return this._listeners;
    }

    protected void handleRedirectException(IRequestCycle cycle, RedirectException ex) {
        String location = ex.getRedirectLocation();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Redirecting to: " + location));
        }
        RedirectAnalyzer analyzer = new RedirectAnalyzer(location);
        analyzer.process(cycle);
    }

    private Map createServiceMap() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Creating service map.");
        }
        ISpecificationSource source = this.getSpecificationSource();
        HashMap result = new HashMap();
        this.addServices(source.getFrameworkNamespace(), result);
        this.addServices(source.getApplicationNamespace(), result);
        IResourceResolver resolver = this.getResourceResolver();
        Iterator i = result.entrySet().iterator();
        while (i.hasNext()) {
            String message;
            Map.Entry entry = i.next();
            String name = (String)entry.getKey();
            String className = (String)entry.getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating service " + name + " as instance of " + className));
            }
            Class serviceClass = resolver.findClass(className);
            try {
                IEngineService service = (IEngineService)serviceClass.newInstance();
                String serviceName = service.getName();
                if (!service.getName().equals(name)) {
                    throw new ApplicationRuntimeException(Tapestry.format("AbstractEngine.service-name-mismatch", name, className, serviceName));
                }
                entry.setValue(service);
            }
            catch (InstantiationException ex) {
                message = Tapestry.format("AbstractEngine.unable-to-instantiate-service", name, className);
                LOG.error((Object)message, (Throwable)ex);
                throw new ApplicationRuntimeException(message, ex);
            }
            catch (IllegalAccessException ex) {
                message = Tapestry.format("AbstractEngine.unable-to-instantiate-service", name, className);
                LOG.error((Object)message, (Throwable)ex);
                throw new ApplicationRuntimeException(message, ex);
            }
        }
        return result;
    }

    private void addServices(INamespace namespace, Map map) {
        List names = namespace.getServiceNames();
        int count = names.size();
        for (int i = 0; i < count; ++i) {
            String name = (String)names.get(i);
            map.put(name, namespace.getServiceClassName(name));
        }
        List namespaceIds = namespace.getChildIds();
        count = namespaceIds.size();
        for (int i = 0; i < count; ++i) {
            String id = (String)namespaceIds.get(i);
            this.addServices(namespace.getChildNamespace(id), map);
        }
    }

    public IComponentMessagesSource getComponentMessagesSource() {
        return this._stringsSource;
    }

    public DataSqueezer getDataSqueezer() {
        return this._dataSqueezer;
    }

    public DataSqueezer createDataSqueezer() {
        return new DataSqueezer(this._resolver);
    }

    protected String extractServiceName(RequestContext context) {
        if (context.getRequest().getAttribute("org.apache.tapestry.tagsupport.service") != null) {
            return "tagsupport";
        }
        String serviceData = context.getParameter("service");
        if (serviceData == null) {
            return "home";
        }
        int slashx = serviceData.indexOf(47);
        if (slashx < 0) {
            return serviceData;
        }
        return serviceData.substring(0, slashx);
    }

    public IPropertySource getPropertySource() {
        return this._propertySource;
    }

    public ResourceChecksumSource getResourceChecksumSource() {
        return this._resourceChecksumSource;
    }

    protected String getExceptionPageName() {
        return "Exception";
    }

    protected String getStaleLinkPageName() {
        return "StaleLink";
    }

    protected String getStaleSessionPageName() {
        return "StaleSession";
    }

    protected IPropertySource createPropertySource(RequestContext context) {
        DelegatingPropertySource result = new DelegatingPropertySource();
        ApplicationServlet servlet = context.getServlet();
        IApplicationSpecification spec = servlet.getApplicationSpecification();
        result.addSource(new PropertyHolderPropertySource(spec));
        result.addSource(new ServletPropertySource(servlet.getServletConfig()));
        result.addSource(new ServletContextPropertySource(servlet.getServletContext()));
        if (spec.checkExtension(EXTENSION_PROPERTY_SOURCE_NAME)) {
            IPropertySource source = (IPropertySource)spec.getExtension(EXTENSION_PROPERTY_SOURCE_NAME, class$org$apache$tapestry$engine$IPropertySource == null ? (class$org$apache$tapestry$engine$IPropertySource = AbstractEngine.class$("org.apache.tapestry.engine.IPropertySource")) : class$org$apache$tapestry$engine$IPropertySource);
            result.addSource(source);
        }
        result.addSource(SystemPropertiesPropertySource.getInstance());
        ResourceBundle bundle = ResourceBundle.getBundle("org.apache.tapestry.ConfigurationDefaults");
        result.addSource(new ResourceBundlePropertySource(bundle));
        return result;
    }

    protected Object createGlobal(RequestContext context) {
        String className = this._propertySource.getPropertyValue("org.apache.tapestry.global-class");
        if (className == null) {
            return Collections.synchronizedMap(new HashMap());
        }
        Class globalClass = this._resolver.findClass(className);
        try {
            return globalClass.newInstance();
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(Tapestry.format("AbstractEngine.unable-to-instantiate-global", className), ex);
        }
    }

    protected Pool createPool(RequestContext context) {
        Pool result = new Pool();
        result.registerAdaptor(class$org$apache$bsf$BSFManager == null ? (class$org$apache$bsf$BSFManager = AbstractEngine.class$("org.apache.bsf.BSFManager")) : class$org$apache$bsf$BSFManager, new BSFManagerPoolableAdaptor());
        return result;
    }

    public Pool getPool() {
        return this._pool;
    }

    protected IComponentClassEnhancer createComponentClassEnhancer(RequestContext context) {
        boolean disableValidation = "true".equals(this._propertySource.getPropertyValue("org.apache.tapestry.enhance.disable-abstract-method-validation"));
        return new DefaultComponentClassEnhancer(this._resolver, disableValidation);
    }

    public IComponentClassEnhancer getComponentClassEnhancer() {
        return this._enhancer;
    }

    public boolean isDirty() {
        return this._dirty;
    }

    protected void markDirty() {
        if (!this._dirty) {
            LOG.debug((Object)"Setting dirty flag.");
        }
        this._dirty = true;
    }

    public void valueBound(HttpSessionBindingEvent arg0) {
        LOG.debug((Object)(this._dirty ? "Clearing dirty flag." : "Dirty flag already cleared."));
        this._dirty = false;
    }

    public void valueUnbound(HttpSessionBindingEvent arg0) {
    }

    protected String getDefaultOutputEncoding() {
        return DEFAULT_OUTPUT_ENCODING;
    }

    public String getOutputEncoding() {
        IPropertySource source = this.getPropertySource();
        String encoding = source.getPropertyValue(OUTPUT_ENCODING_PROPERTY_NAME);
        if (encoding == null) {
            encoding = this.getDefaultOutputEncoding();
        }
        return encoding;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public abstract /* synthetic */ IPageRecorder createPageRecorder(String var1, IRequestCycle var2);

    public abstract /* synthetic */ void forgetPage(String var1);

    public abstract /* synthetic */ IPageRecorder getPageRecorder(String var1, IRequestCycle var2);

    private static class RedirectAnalyzer {
        private boolean _internal;
        private String _location;

        private RedirectAnalyzer(String location) {
            if (Tapestry.isBlank(location)) {
                this._location = "";
                this._internal = true;
                return;
            }
            this._location = location;
            this._internal = !location.startsWith("/") && location.indexOf("://") <= 0;
        }

        public void process(IRequestCycle cycle) {
            RequestContext context = cycle.getRequestContext();
            if (this._internal) {
                this.forward(context);
            } else {
                this.redirect(context);
            }
        }

        private void forward(RequestContext context) {
            HttpServletRequest request = context.getRequest();
            HttpServletResponse response = context.getResponse();
            RequestDispatcher dispatcher = request.getRequestDispatcher("/" + this._location);
            if (dispatcher == null) {
                throw new ApplicationRuntimeException(Tapestry.format("AbstractEngine.unable-to-find-dispatcher", this._location));
            }
            try {
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (ServletException ex) {
                throw new ApplicationRuntimeException(Tapestry.format("AbstractEngine.unable-to-forward", this._location), ex);
            }
            catch (IOException ex) {
                throw new ApplicationRuntimeException(Tapestry.format("AbstractEngine.unable-to-forward", this._location), ex);
            }
        }

        private void redirect(RequestContext context) {
            HttpServletResponse response = context.getResponse();
            String finalURL = response.encodeRedirectURL(this._location);
            try {
                response.sendRedirect(finalURL);
            }
            catch (IOException ex) {
                throw new ApplicationRuntimeException(Tapestry.format("AbstractEngine.unable-to-redirect", this._location), ex);
            }
        }
    }
}

