/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.engine;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMessages;
import org.apache.tapestry.IResourceLocation;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.engine.ComponentMessages;
import org.apache.tapestry.engine.IComponentMessagesSource;
import org.apache.tapestry.util.MultiKey;

public class DefaultComponentMessagesSource
implements IComponentMessagesSource {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$engine$DefaultComponentMessagesSource == null ? (class$org$apache$tapestry$engine$DefaultComponentMessagesSource = DefaultComponentMessagesSource.class$("org.apache.tapestry.engine.DefaultComponentMessagesSource")) : class$org$apache$tapestry$engine$DefaultComponentMessagesSource));
    private Properties _emptyProperties = new Properties();
    private Map _cache = new HashMap();
    private static final String SUFFIX = ".properties";
    static /* synthetic */ Class class$org$apache$tapestry$engine$DefaultComponentMessagesSource;

    protected synchronized Properties getLocalizedProperties(IComponent component) {
        Locale locale;
        if (component == null) {
            throw new IllegalArgumentException(Tapestry.format("invalid-null-parameter", "component"));
        }
        IResourceLocation specificationLocation = component.getSpecification().getSpecificationLocation();
        MultiKey key = this.buildKey(specificationLocation, locale = component.getPage().getLocale());
        Properties result = (Properties)this._cache.get(key);
        if (result != null) {
            return result;
        }
        result = this.assembleProperties(specificationLocation, locale);
        this._cache.put(key, result);
        return result;
    }

    private Properties assembleProperties(IResourceLocation baseResourceLocation, Locale locale) {
        MultiKey key;
        Locale l;
        boolean debug = LOG.isDebugEnabled();
        if (debug) {
            LOG.debug((Object)("Assembling properties for " + baseResourceLocation + " " + locale));
        }
        String name = baseResourceLocation.getName();
        int dotx = name.indexOf(46);
        String baseName = name.substring(0, dotx);
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        Properties parent = (Properties)this._cache.get(baseResourceLocation);
        if (parent == null) {
            parent = this.readProperties(baseResourceLocation, baseName, null, null);
            if (parent == null) {
                parent = this._emptyProperties;
            }
            this._cache.put(baseResourceLocation, parent);
        }
        Properties result = parent;
        if (!Tapestry.isBlank(language)) {
            l = new Locale(language, "");
            key = this.buildKey(baseResourceLocation, l);
            result = (Properties)this._cache.get(key);
            if (result == null) {
                result = this.readProperties(baseResourceLocation, baseName, l, parent);
            }
            this._cache.put(key, result);
            parent = result;
        } else {
            language = "";
        }
        if (Tapestry.isNonBlank(country)) {
            l = new Locale(language, country);
            key = this.buildKey(baseResourceLocation, l);
            result = (Properties)this._cache.get(key);
            if (result == null) {
                result = this.readProperties(baseResourceLocation, baseName, l, parent);
            }
            this._cache.put(key, result);
            parent = result;
        } else {
            country = "";
        }
        if (Tapestry.isNonBlank(variant)) {
            l = new Locale(language, country, variant);
            key = this.buildKey(baseResourceLocation, l);
            result = (Properties)this._cache.get(key);
            if (result == null) {
                result = this.readProperties(baseResourceLocation, baseName, l, parent);
            }
            this._cache.put(key, result);
        }
        return result;
    }

    private MultiKey buildKey(IResourceLocation location, Locale locale) {
        return new MultiKey(new Object[]{location, locale.toString()}, false);
    }

    private Properties readProperties(IResourceLocation baseLocation, String baseName, Locale locale, Properties parent) {
        StringBuffer buffer = new StringBuffer(baseName);
        if (locale != null) {
            buffer.append('_');
            buffer.append(locale.toString());
        }
        buffer.append(SUFFIX);
        IResourceLocation localized = baseLocation.getRelativeLocation(buffer.toString());
        URL propertiesURL = localized.getResourceURL();
        if (propertiesURL == null) {
            return parent;
        }
        Properties result = null;
        result = parent == null ? new Properties() : new Properties(parent);
        try {
            InputStream input = propertiesURL.openStream();
            result.load(input);
            input.close();
        }
        catch (IOException ex) {
            throw new ApplicationRuntimeException(Tapestry.format("ComponentPropertiesStore.unable-to-read-input", propertiesURL), ex);
        }
        return result;
    }

    public void reset() {
        this._cache.clear();
    }

    public IMessages getMessages(IComponent component) {
        return new ComponentMessages(component.getPage().getLocale(), this.getLocalizedProperties(component));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

