/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.enhance.javassist;

import java.io.IOException;
import java.text.MessageFormat;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.enhance.CodeGenerationException;

public class ClassFabricator {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$enhance$javassist$ClassFabricator == null ? (class$org$apache$tapestry$enhance$javassist$ClassFabricator = ClassFabricator.class$("org.apache.tapestry.enhance.javassist.ClassFabricator")) : class$org$apache$tapestry$enhance$javassist$ClassFabricator));
    private static final String PROPERTY_ACCESSOR_TEMPLATE = "'{'  return {0}; '}'";
    private static final String PROPERTY_MUTATOR_TEMPLATE = "'{'  {0} = $1; '}'";
    private static final String PERSISTENT_PROPERTY_MUTATOR_TEMPLATE = "'{'  {0} = $1;  fireObservedChange(\"{1}\", {0}); '}'";
    private ClassPool _classPool;
    private CtClass _genClass;
    static /* synthetic */ Class class$org$apache$tapestry$enhance$javassist$ClassFabricator;

    public ClassFabricator(String className, CtClass parentClass, ClassPool classPool) {
        this._classPool = classPool;
        this._genClass = this._classPool.makeClass(className, parentClass);
    }

    public CtField getField(String fieldName) {
        try {
            return this._genClass.getField(fieldName);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    public void createField(CtClass fieldType, String fieldName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating field: " + fieldName));
        }
        try {
            CtField field = new CtField(fieldType, fieldName, this._genClass);
            this._genClass.addField(field);
        }
        catch (CannotCompileException e) {
            throw new CodeGenerationException(e);
        }
    }

    public void createField(CtClass fieldType, String fieldName, String init) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating field: " + fieldName + " with initializer: " + init));
        }
        try {
            CtField field = new CtField(fieldType, fieldName, this._genClass);
            this._genClass.addField(field, init);
        }
        catch (CannotCompileException e) {
            throw new CodeGenerationException(e);
        }
    }

    public CtMethod getMethod(String name, String signature) {
        try {
            return this._genClass.getMethod(name, signature);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    public void addMethod(CtMethod method) throws CannotCompileException {
        this._genClass.addMethod(method);
    }

    public String buildMethodName(String prefix, String propertyName) {
        StringBuffer result = new StringBuffer(prefix);
        char ch = propertyName.charAt(0);
        result.append(Character.toUpperCase(ch));
        result.append(propertyName.substring(1));
        return result.toString();
    }

    public CtMethod createMethod(CtClass returnType, String methodName, CtClass[] arguments) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating method: " + methodName));
        }
        CtMethod method = new CtMethod(returnType, methodName, arguments, this._genClass);
        return method;
    }

    public CtMethod createAccessor(CtClass fieldType, String propertyName, String readMethodName) {
        String methodName;
        String string = methodName = readMethodName == null ? this.buildMethodName("get", propertyName) : readMethodName;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating accessor: " + methodName));
        }
        CtMethod method = new CtMethod(fieldType, methodName, new CtClass[0], this._genClass);
        return method;
    }

    public void createPropertyAccessor(CtClass fieldType, String fieldName, String propertyName, String readMethodName) {
        try {
            String accessorBody = MessageFormat.format(PROPERTY_ACCESSOR_TEMPLATE, fieldName, propertyName);
            CtMethod method = this.createAccessor(fieldType, propertyName, readMethodName);
            method.setBody(accessorBody);
            this._genClass.addMethod(method);
        }
        catch (CannotCompileException e) {
            throw new CodeGenerationException(e);
        }
    }

    public CtMethod createMutator(CtClass fieldType, String propertyName) {
        String methodName = this.buildMethodName("set", propertyName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating mutator: " + methodName));
        }
        CtMethod method = new CtMethod(CtClass.voidType, methodName, new CtClass[]{fieldType}, this._genClass);
        return method;
    }

    public void createPropertyMutator(CtClass fieldType, String fieldName, String propertyName, boolean isPersistent) {
        String bodyTemplate = isPersistent ? PERSISTENT_PROPERTY_MUTATOR_TEMPLATE : PROPERTY_MUTATOR_TEMPLATE;
        String body = MessageFormat.format(bodyTemplate, fieldName, propertyName);
        try {
            CtMethod method = this.createMutator(fieldType, propertyName);
            method.setBody(body);
            this._genClass.addMethod(method);
        }
        catch (CannotCompileException e) {
            throw new CodeGenerationException(e);
        }
    }

    public void commit() {
    }

    public byte[] getByteCode() {
        try {
            return this._genClass.toBytecode();
        }
        catch (NotFoundException e) {
            throw new CodeGenerationException(e);
        }
        catch (IOException e) {
            throw new CodeGenerationException(e);
        }
        catch (CannotCompileException e) {
            throw new CodeGenerationException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

