/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.enhance.javassist;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.enhance.CodeGenerationException;
import org.apache.tapestry.enhance.IEnhancedClass;
import org.apache.tapestry.enhance.IEnhancer;
import org.apache.tapestry.enhance.javassist.ClassFabricator;
import org.apache.tapestry.enhance.javassist.EnhancedClass;

public class CreateAutoParameterEnhancer
implements IEnhancer {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$enhance$javassist$CreateAutoParameterEnhancer == null ? (class$org$apache$tapestry$enhance$javassist$CreateAutoParameterEnhancer = CreateAutoParameterEnhancer.class$("org.apache.tapestry.enhance.javassist.CreateAutoParameterEnhancer")) : class$org$apache$tapestry$enhance$javassist$CreateAutoParameterEnhancer));
    protected static final String PARAMETER_ACCESSOR_TEMPLATE = "'{'  org.apache.tapestry.IBinding binding = {0}();  return {2} binding.{1}(); '}'";
    protected static final String PARAMETER_MUTATOR_TEMPLATE = "'{'  org.apache.tapestry.IBinding binding = {0}();  binding.{1}({2} $1); '}'";
    private static final Map SPECIAL_BINDING_TYPES = new HashMap();
    private static final Map VALUE_CAST_TYPES;
    private EnhancedClass _enhancedClass;
    private String _propertyName;
    private String _parameterName;
    private CtClass _type;
    private String _readMethodName;
    static /* synthetic */ Class class$org$apache$tapestry$enhance$javassist$CreateAutoParameterEnhancer;

    public CreateAutoParameterEnhancer(EnhancedClass enhancedClass, String propertyName, String parameterName, CtClass type, String readMethodName) {
        this._enhancedClass = enhancedClass;
        this._propertyName = propertyName;
        this._parameterName = parameterName;
        this._type = type;
        this._readMethodName = readMethodName;
    }

    public void performEnhancement(IEnhancedClass enhancedClass) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating auto property: " + this._propertyName));
        }
        EnhancedClass jaEnhancedClass = (EnhancedClass)enhancedClass;
        ClassFabricator cf = jaEnhancedClass.getClassFabricator();
        String readBindingMethodName = cf.buildMethodName("get", this._parameterName + "Binding");
        this.createReadMethod(cf, readBindingMethodName);
        this.createWriteMethod(cf, readBindingMethodName);
    }

    private String getSpecialBindingType() {
        String typeName = this._type.getName();
        return (String)SPECIAL_BINDING_TYPES.get(typeName);
    }

    private String getValueCastType() {
        String typeName = this._type.getName();
        return (String)VALUE_CAST_TYPES.get(typeName);
    }

    private void createReadMethod(ClassFabricator cf, String readBindingMethodName) {
        String bindingValueAccessor;
        String castToType;
        String specialBindingType = this.getSpecialBindingType();
        if (specialBindingType != null) {
            castToType = "";
            bindingValueAccessor = cf.buildMethodName("get", specialBindingType);
        } else {
            castToType = "($r)";
            bindingValueAccessor = "getObject";
        }
        String readMethodBody = MessageFormat.format(PARAMETER_ACCESSOR_TEMPLATE, readBindingMethodName, bindingValueAccessor, castToType);
        try {
            CtMethod method = cf.createAccessor(this._type, this._propertyName, this._readMethodName);
            method.setBody(readMethodBody);
            cf.addMethod(method);
        }
        catch (CannotCompileException e) {
            throw new CodeGenerationException(e);
        }
    }

    private void createWriteMethod(ClassFabricator cf, String readBindingMethodName) {
        String bindingValueAccessor;
        String valueCast = "";
        String specialBindingType = this.getSpecialBindingType();
        if (specialBindingType != null) {
            bindingValueAccessor = cf.buildMethodName("set", specialBindingType);
        } else {
            bindingValueAccessor = "setObject";
            String castForType = this.getValueCastType();
            if (castForType != null) {
                valueCast = castForType;
            }
        }
        String writeMethodBody = MessageFormat.format(PARAMETER_MUTATOR_TEMPLATE, readBindingMethodName, bindingValueAccessor, valueCast);
        try {
            CtMethod method = cf.createMutator(this._type, this._propertyName);
            method.setBody(writeMethodBody);
            cf.addMethod(method);
        }
        catch (CannotCompileException e) {
            throw new CodeGenerationException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        SPECIAL_BINDING_TYPES.put("boolean", "boolean");
        SPECIAL_BINDING_TYPES.put("int", "int");
        SPECIAL_BINDING_TYPES.put("double", "double");
        SPECIAL_BINDING_TYPES.put("java.lang.String", "string");
        VALUE_CAST_TYPES = new HashMap();
        VALUE_CAST_TYPES.put("byte", "($w)");
        VALUE_CAST_TYPES.put("long", "($w)");
        VALUE_CAST_TYPES.put("short", "($w)");
        VALUE_CAST_TYPES.put("char", "($w)");
        VALUE_CAST_TYPES.put("float", "($w)");
    }
}

