/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form;

import java.awt.Point;
import org.apache.tapestry.IActionListener;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.form.AbstractFormComponent;
import org.apache.tapestry.request.RequestContext;

public abstract class ImageSubmit
extends AbstractFormComponent {
    public abstract IBinding getPointBinding();

    public abstract IBinding getSelectedBinding();

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        String name;
        IForm form = this.getForm(cycle);
        boolean rewinding = form.isRewinding();
        String nameOverride = this.getNameOverride();
        String string = name = nameOverride == null ? form.getElementId(this) : form.getElementId(this, nameOverride);
        if (rewinding) {
            IActionListener listener;
            IBinding selectedBinding;
            String parameterName;
            if (this.isDisabled()) {
                return;
            }
            RequestContext context = cycle.getRequestContext();
            String value = context.getParameter(parameterName = name + ".x");
            if (value == null) {
                return;
            }
            IBinding pointBinding = this.getPointBinding();
            if (pointBinding != null) {
                int x = Integer.parseInt(value);
                parameterName = name + ".y";
                value = context.getParameter(parameterName);
                int y = Integer.parseInt(value);
                pointBinding.setObject(new Point(x, y));
            }
            if ((selectedBinding = this.getSelectedBinding()) != null) {
                selectedBinding.setObject(this.getTag());
            }
            if ((listener = this.getListener()) != null) {
                listener.actionTriggered(this, cycle);
            }
            return;
        }
        boolean disabled = this.isDisabled();
        IAsset disabledImage = this.getDisabledImage();
        IAsset finalImage = disabled && disabledImage != null ? disabledImage : this.getImage();
        String imageURL = finalImage.buildURL(cycle);
        writer.beginEmpty("input");
        writer.attribute("type", "image");
        writer.attribute("name", name);
        if (disabled) {
            writer.attribute("disabled", "disabled");
        }
        writer.attribute("border", 0);
        writer.attribute("src", imageURL);
        this.renderInformalParameters(writer, cycle);
        writer.closeTag();
    }

    public abstract boolean isDisabled();

    public abstract IAsset getDisabledImage();

    public abstract IAsset getImage();

    public abstract IActionListener getListener();

    public abstract Object getTag();

    public abstract String getNameOverride();

    protected void prepareForRender(IRequestCycle cycle) {
        super.prepareForRender(cycle);
        if (this.getImage() == null) {
            throw Tapestry.createRequiredParameterException(this, "image");
        }
    }
}

