/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.spec;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import ognl.ClassResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IResourceResolver;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.spec.IExtensionSpecification;
import org.apache.tapestry.spec.LocatablePropertyHolder;
import org.apache.tapestry.util.prop.OgnlUtils;

public class ExtensionSpecification
extends LocatablePropertyHolder
implements IExtensionSpecification {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$spec$ExtensionSpecification == null ? (class$org$apache$tapestry$spec$ExtensionSpecification = ExtensionSpecification.class$("org.apache.tapestry.spec.ExtensionSpecification")) : class$org$apache$tapestry$spec$ExtensionSpecification));
    private String _className;
    protected Map _configuration = new HashMap();
    private boolean _immediate;
    static /* synthetic */ Class class$org$apache$tapestry$spec$ExtensionSpecification;

    public String getClassName() {
        return this._className;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void addConfiguration(String propertyName, Object value) {
        if (this._configuration.containsKey(propertyName)) {
            throw new IllegalArgumentException(Tapestry.format("ExtensionSpecification.duplicate-property", this, propertyName));
        }
        this._configuration.put(propertyName, value);
    }

    public Map getConfiguration() {
        return Collections.unmodifiableMap(this._configuration);
    }

    public Object instantiateExtension(IResourceResolver resolver) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Instantiating extension class " + this._className + "."));
        }
        Class extensionClass = null;
        Object result = null;
        try {
            extensionClass = resolver.findClass(this._className);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(Tapestry.format("ExtensionSpecification.bad-class", this._className), this.getLocation(), ex);
        }
        result = this.instantiateInstance(extensionClass, result);
        this.initializeProperties(resolver, result);
        return result;
    }

    private void initializeProperties(IResourceResolver resolver, Object extension) {
        if (this._configuration.isEmpty()) {
            return;
        }
        Iterator i = this._configuration.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String propertyName = (String)entry.getKey();
            OgnlUtils.set(propertyName, (ClassResolver)resolver, extension, entry.getValue());
        }
    }

    private Object instantiateInstance(Class extensionClass, Object result) {
        try {
            result = extensionClass.newInstance();
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ex.getMessage(), this.getLocation(), ex);
        }
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("ExtensionSpecification@");
        buffer.append(Integer.toHexString(this.hashCode()));
        buffer.append('[');
        buffer.append(this._className);
        if (this._configuration != null) {
            buffer.append(' ');
            buffer.append(this._configuration);
        }
        buffer.append(']');
        return buffer.toString();
    }

    public boolean isImmediate() {
        return this._immediate;
    }

    public void setImmediate(boolean immediate) {
        this._immediate = immediate;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

