/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.Tapestry;

public class AdaptorRegistry {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$util$AdaptorRegistry == null ? (class$org$apache$tapestry$util$AdaptorRegistry = AdaptorRegistry.class$("org.apache.tapestry.util.AdaptorRegistry")) : class$org$apache$tapestry$util$AdaptorRegistry));
    private Map registrations = new HashMap();
    private Map cache = new HashMap();
    static /* synthetic */ Class class$org$apache$tapestry$util$AdaptorRegistry;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public synchronized void register(Class registrationClass, Object adaptor) {
        if (this.registrations.containsKey(registrationClass)) {
            throw new IllegalArgumentException(Tapestry.format("AdaptorRegistry.duplicate-registration", Tapestry.getClassName(registrationClass)));
        }
        this.registrations.put(registrationClass, adaptor);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Registered " + adaptor + " for " + Tapestry.getClassName(registrationClass)));
        }
        this.cache.clear();
    }

    public synchronized Object getAdaptor(Class subjectClass) {
        Object result;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting adaptor for class " + Tapestry.getClassName(subjectClass)));
        }
        if ((result = this.cache.get(subjectClass)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found " + result + " in cache"));
            }
            return result;
        }
        result = this.searchForAdaptor(subjectClass);
        this.cache.put(subjectClass, result);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found " + result));
        }
        return result;
    }

    private Object searchForAdaptor(Class subjectClass) {
        int i;
        int length;
        Class<?>[] interfaces;
        LinkedList queue = null;
        Object result = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Searching for adaptor for class " + Tapestry.getClassName(subjectClass)));
        }
        Class searchClass = subjectClass;
        while (searchClass != (class$java$lang$Object == null ? AdaptorRegistry.class$("java.lang.Object") : class$java$lang$Object) && searchClass != null) {
            result = this.registrations.get(searchClass);
            if (result != null) {
                return result;
            }
            interfaces = searchClass.getInterfaces();
            length = interfaces.length;
            if (queue == null && length > 0) {
                queue = new LinkedList();
            }
            for (i = 0; i < length; ++i) {
                queue.addLast(interfaces[i]);
            }
            searchClass = this.getSuperclass(searchClass);
        }
        if (queue != null) {
            while (!queue.isEmpty()) {
                searchClass = (Class)queue.removeFirst();
                result = this.registrations.get(searchClass);
                if (result != null) {
                    return result;
                }
                interfaces = searchClass.getInterfaces();
                length = interfaces.length;
                for (i = 0; i < length; ++i) {
                    queue.addLast(interfaces[i]);
                }
            }
        }
        if ((result = this.registrations.get(class$java$lang$Object == null ? (class$java$lang$Object = AdaptorRegistry.class$("java.lang.Object")) : class$java$lang$Object)) != null) {
            return result;
        }
        throw new IllegalArgumentException(Tapestry.format("AdaptorRegistry.adaptor-not-found", Tapestry.getClassName(subjectClass)));
    }

    private Class getSuperclass(Class searchClass) {
        Class<?> componentType;
        if (searchClass.isArray() && !(componentType = searchClass.getComponentType()).isPrimitive() && componentType != (class$java$lang$Object == null ? (class$java$lang$Object = AdaptorRegistry.class$("java.lang.Object")) : class$java$lang$Object)) {
            return array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = AdaptorRegistry.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object;
        }
        return searchClass.getSuperclass();
    }

    public synchronized String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("AdaptorRegistry[");
        Iterator i = this.registrations.entrySet().iterator();
        boolean showSep = false;
        while (i.hasNext()) {
            if (showSep) {
                buffer.append(' ');
            }
            Map.Entry entry = i.next();
            Class registeredClass = (Class)entry.getKey();
            buffer.append(Tapestry.getClassName(registeredClass));
            buffer.append("=");
            buffer.append(entry.getValue());
            showSep = true;
        }
        buffer.append("]");
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

