/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.util.pool;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.util.AdaptorRegistry;
import org.apache.tapestry.util.ICleanable;
import org.apache.tapestry.util.IRenderDescription;
import org.apache.tapestry.util.JanitorThread;
import org.apache.tapestry.util.pool.DefaultPoolableAdaptor;
import org.apache.tapestry.util.pool.IPoolableAdaptor;
import org.apache.tapestry.util.pool.NullPoolableAdaptor;
import org.apache.tapestry.util.pool.PoolList;
import org.apache.tapestry.util.pool.StringBufferAdaptor;

public class Pool
implements ICleanable,
IRenderDescription {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$tapestry$util$pool$Pool == null ? (class$org$apache$tapestry$util$pool$Pool = Pool.class$("org.apache.tapestry.util.pool.Pool")) : class$org$apache$tapestry$util$pool$Pool));
    private AdaptorRegistry _adaptors = new AdaptorRegistry();
    private int _generation;
    private int _window = 10;
    private int _pooledCount;
    private Map _map;
    static /* synthetic */ Class class$org$apache$tapestry$util$pool$Pool;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$apache$tapestry$util$pool$IPoolable;
    static /* synthetic */ Class class$java$lang$StringBuffer;

    public Pool() {
        this(true);
    }

    public Pool(int mapSize) {
        this(mapSize, true);
    }

    public Pool(boolean useSharedJanitor) {
        if (useSharedJanitor) {
            JanitorThread.getSharedJanitorThread().add(this);
        }
        this.registerAdaptors();
    }

    public Pool(int mapSize, boolean useSharedJanitor) {
        this(useSharedJanitor);
        this._map = new HashMap(mapSize);
    }

    public int getWindow() {
        return this._window;
    }

    public void setWindow(int value) {
        if (value < 1) {
            throw new IllegalArgumentException("Pool window may not be less than 1.");
        }
        this._window = value;
    }

    public synchronized Object retrieve(Object key) {
        PoolList list;
        Object result = null;
        if (this._map == null) {
            this._map = new HashMap();
        }
        if ((list = (PoolList)this._map.get(key)) != null) {
            result = list.retrieve();
        }
        if (result != null) {
            --this._pooledCount;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Retrieved " + result + " from " + key));
        }
        return result;
    }

    public Object retrieve(Class objectClass) {
        Object result = this.retrieve((Object)objectClass);
        if (result == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No instance of " + objectClass.getName() + " is available, instantiating one."));
            }
            try {
                result = objectClass.newInstance();
            }
            catch (Exception ex) {
                throw new ApplicationRuntimeException(Tapestry.format("Pool.unable-to-instantiate-instance", objectClass.getName()), ex);
            }
        }
        return result;
    }

    public void store(Object object) {
        this.store(object.getClass(), object);
    }

    public synchronized void store(Object key, Object object) {
        PoolList list;
        this.getAdaptor(object).resetForPool(object);
        if (this._map == null) {
            this._map = new HashMap();
        }
        if ((list = (PoolList)this._map.get(key)) == null) {
            list = new PoolList(this);
            this._map.put(key, list);
        }
        int count = list.store(this._generation, object);
        ++this._pooledCount;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Stored " + object + " into " + key + " (" + count + " pooled)"));
        }
    }

    public synchronized void clear() {
        if (this._map != null) {
            Iterator i = this._map.values().iterator();
            while (i.hasNext()) {
                PoolList list = (PoolList)i.next();
                list.discardAll();
            }
            this._map.clear();
        }
        this._pooledCount = 0;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Cleared");
        }
    }

    public synchronized int getPooledCount() {
        return this._pooledCount;
    }

    public synchronized int getKeyCount() {
        if (this._map == null) {
            return 0;
        }
        return this._map.size();
    }

    public synchronized void executeCleanup() {
        if (this._map == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Executing cleanup of " + this));
        }
        ++this._generation;
        int oldestGeneration = this._generation - this._window;
        if (oldestGeneration < 0) {
            return;
        }
        int oldCount = this._pooledCount;
        int culledKeys = 0;
        int newCount = 0;
        Iterator i = this._map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            PoolList list = (PoolList)e.getValue();
            int count = list.cleanup(oldestGeneration);
            if (count == 0) {
                i.remove();
                ++culledKeys;
                continue;
            }
            newCount += count;
        }
        this._pooledCount = newCount;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Culled " + (oldCount - this._pooledCount) + " pooled objects and " + culledKeys + " keys."));
        }
    }

    public synchronized String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("generation", this._generation);
        builder.append("pooledCount", this._pooledCount);
        return builder.toString();
    }

    public synchronized void renderDescription(IMarkupWriter writer) {
        writer.begin("table");
        writer.attribute("border", "1");
        writer.println();
        writer.begin("tr");
        writer.begin("th");
        writer.attribute("colspan", "2");
        writer.print(this.toString());
        writer.end();
        writer.end();
        writer.println();
        if (this._map != null) {
            Iterator i = this._map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                PoolList list = (PoolList)entry.getValue();
                writer.begin("tr");
                writer.begin("td");
                writer.print(entry.getKey().toString());
                writer.end();
                writer.begin("td");
                writer.print(list.getPooledCount());
                writer.end();
                writer.end();
                writer.println();
            }
        }
    }

    protected void registerAdaptors() {
        this.registerAdaptor(class$java$lang$Object == null ? (class$java$lang$Object = Pool.class$("java.lang.Object")) : class$java$lang$Object, new NullPoolableAdaptor());
        this.registerAdaptor(class$org$apache$tapestry$util$pool$IPoolable == null ? (class$org$apache$tapestry$util$pool$IPoolable = Pool.class$("org.apache.tapestry.util.pool.IPoolable")) : class$org$apache$tapestry$util$pool$IPoolable, new DefaultPoolableAdaptor());
        this.registerAdaptor(class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = Pool.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer, new StringBufferAdaptor());
    }

    public void registerAdaptor(Class registrationClass, IPoolableAdaptor adaptor) {
        this._adaptors.register(registrationClass, adaptor);
    }

    public IPoolableAdaptor getAdaptor(Object object) {
        return (IPoolableAdaptor)this._adaptors.getAdaptor(object.getClass());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

