/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.saas.google;

import com.google.gdata.data.appsforyourdomain.AppsForYourDomainException;
import com.google.gdata.util.AuthenticationException;
import com.pingidentity.provisioner.saas.SaasException;

public class GoogleException
extends SaasException {
    public GoogleException(String message, Exception exception) {
        super(GoogleException.formatGoogleException(message, exception), (Throwable)exception);
        this.checkStopLoop(exception);
    }

    public GoogleException(Exception exception) {
        super(GoogleException.formatGoogleException(exception), (Throwable)exception);
        this.checkStopLoop(exception);
    }

    private static String formatGoogleException(String message, Exception exception) {
        if (exception instanceof AppsForYourDomainException) {
            return message + "; " + GoogleException.formatGoogleException(exception);
        }
        return message;
    }

    private static String formatGoogleException(Exception exception) {
        if (exception instanceof AppsForYourDomainException) {
            AppsForYourDomainException appsException = (AppsForYourDomainException)exception;
            return "ErrorCode: " + appsException.getErrorCode() + "; Invalid Input: " + appsException.getInvalidInput();
        }
        return "";
    }

    private void checkStopLoop(Exception exception) {
        if (exception instanceof AuthenticationException) {
            this.setStopSession(true);
        }
    }
}

