/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.console;

import com.pingidentity.common.util.ConsoleUtils;
import com.pingidentity.crypto.Password;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;
import org.jose4j.jwk.JsonWebKey;
import org.sourceid.common.IDGenerator;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.ModeSupport;

public class GenerateClusterKey {
    private static final String RUN_PROPERTIES = "run.properties";
    private static final String CLUSTER_AUTH_PWD = "pf.cluster.auth.pwd";
    private static final String PF_JWK_PATH = Paths.get("server", "default", "data", "pf.jwk").toString();
    private static final int KEY_LENGTH = 22;

    public static void main(String[] args) {
        try {
            ConsoleUtils.doConsoleUtilityInitialization();
        }
        catch (IOException e) {
            System.out.println("Failed to load run.properties: " + e.getMessage());
            return;
        }
        if (!ModeSupport.isConsole()) {
            System.out.println("WARNING: this utility should be run on the administrative console.");
        }
        String clusterKey = IDGenerator.rndAlphaNumeric((int)22);
        String obfuscatedKey = Password.obfuscateAndEncode((String)clusterKey);
        List masterKeySet = MgmtFactory.getMasterKeySet().getJsonWebKeySet().getJsonWebKeys();
        if (masterKeySet.isEmpty()) {
            System.out.println("Unexpected error: could not locate master key that was used to encrypt cluster encryption key");
            return;
        }
        String keyId = ((JsonWebKey)masterKeySet.get(0)).getKeyId();
        System.out.println("Cluster encryption key generated:");
        System.out.println();
        System.out.println(obfuscatedKey);
        System.out.println();
        System.out.println("- Use this key to set pf.cluster.auth.pwd in run.properties.");
        System.out.println("- All nodes in the cluster must have the same cluster encryption key.");
        System.out.println("- To ensure this, you should copy this key to the run.properties file on the engine nodes.");
        System.out.println("- The cluster encryption key was encrypted with master key " + keyId + " from " + PF_JWK_PATH + ".");
        System.out.println("- When copying the cluster encryption key to engine nodes, you must ensure the " + keyId + " master key is present on those nodes.");
        System.out.println("- For fresh engines that do not already have a pf.jwk file, you can copy the file from this node.");
        System.out.println("- If an engine already has its own pf.jwk file and it does not include the key " + keyId + ", you will need to manually merge this key into the engine's file.");
        System.out.println("- When using a MasterKeyEncryptor, a manual merge is not possible, so starting with fresh engine nodes is recommended. In addition to pf.jwk, the file com.pingidentity.crypto.jwk.MasterKeySet.xml must also be copied to the engine nodes.");
    }
}

