/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.console;

import com.pingidentity.common.util.ConsoleUtils;
import com.pingidentity.console.PasswordReader;
import com.pingidentity.crypto.PasswordFile;
import java.io.File;
import java.io.IOException;

class PasswordChanger {
    private static final String FILE_LOCATION = "password.file";

    PasswordChanger() {
    }

    private static void printAppInfo() {
        System.out.println("PingFederate Password Changer");
        System.out.println("--------------------------------------------");
    }

    private static String getPassword(boolean showMsg) {
        if (showMsg && !PasswordReader.supportConsoleReadPassword()) {
            System.out.println("NOTE: Java echoes all input to the console. Your password will display when you type it.");
            System.out.println("      Please ensure that there is no one looking over your shoulder. Hit Ctrl-C to cancel.");
            System.out.println();
        }
        try {
            return PasswordReader.readPassword("Password: ");
        }
        catch (IOException e) {
            return "";
        }
    }

    public static void main(String[] args) {
        ConsoleUtils.disableWarning();
        ConsoleUtils.initializeCommandLineProperties();
        PasswordChanger.printAppInfo();
        if (System.getProperty(FILE_LOCATION) == null) {
            System.out.println("ERROR: No password filename provided!");
            return;
        }
        File passwdFile = new File(System.getProperty(FILE_LOCATION));
        if (!passwdFile.isFile() || !passwdFile.exists()) {
            System.out.println("WARNING: Password file does not exist: " + passwdFile.getAbsolutePath());
        }
        if (args.length < 1 || args[0].length() < 1) {
            System.out.println("ERROR: Missing command line argument. You must provide the username for the password to set.");
            return;
        }
        String username = args[0];
        String newPassword = null;
        if (args.length > 1) {
            newPassword = args[1];
        }
        if (newPassword == null) {
            newPassword = PasswordChanger.getPassword(true);
        }
        try {
            ConsoleUtils.loadHivemodule();
            PasswordFile.obfuscatePassword((File)passwdFile, (String)username, (String)newPassword);
        }
        catch (Exception ex) {
            System.err.println("Error occurred while updating the password file: " + passwdFile);
            ex.printStackTrace();
        }
    }
}

