/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.console.configkeymgr;

import com.pingidentity.console.configkeymgr.CommandArgument;
import com.pingidentity.console.configkeymgr.ConfigKeyCommand;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.List;

public abstract class ConfigKeyBaseCommand
implements ConfigKeyCommand {
    protected CommandArgument SKIP_CONFIRMATION_PROMPT = new CommandArgument("skip-confirmation", null, "Skip the confirmation prompt when running the utility", false);
    String[] cmdLineArgs;
    List<CommandArgument> commandArguments;

    abstract List<CommandArgument> initializeArguments();

    public boolean checkForFlag(CommandArgument argumentToCheck) {
        for (String arg : this.cmdLineArgs) {
            if (argumentToCheck.getLongArg() != null && ("--" + argumentToCheck.getLongArg()).equals(arg)) {
                return true;
            }
            if (argumentToCheck.getShortArg() == null || !("-" + argumentToCheck.getShortArg()).equals(arg)) continue;
            return true;
        }
        return false;
    }

    public String getArgument(CommandArgument argument) {
        for (int i = 0; i < this.cmdLineArgs.length - 1; ++i) {
            if (argument.getLongArg() != null && ("--" + argument.getLongArg()).equals(this.cmdLineArgs[i])) {
                return this.cmdLineArgs[i + 1];
            }
            if (argument.getShortArg() == null || !("-" + argument.getShortArg()).equals(this.cmdLineArgs[i])) continue;
            return this.cmdLineArgs[i + 1];
        }
        return null;
    }

    public boolean getConfirmation(String message) throws IOException {
        System.out.print(message + " ");
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));
        String response = reader.readLine();
        return "yes".equals(response);
    }

    public void outputCmdLineArgumentErrors(List<String> errors) {
        if (errors.size() > 1) {
            System.out.println("There were errors parsing the arguments:");
        } else {
            System.out.println("There was an error parsing the arguments:");
        }
        for (String error : errors) {
            System.out.println(error);
        }
    }

    public void checkForInvalidArguments(List<String> validationErrors) {
        for (int i = 1; i < this.cmdLineArgs.length; ++i) {
            boolean match = this.isCommandArgument(this.cmdLineArgs[i]);
            if (!(match || this.cmdLineArgs[i].startsWith("-") || this.cmdLineArgs[i].startsWith("--"))) {
                match = this.isCommandArgument(this.cmdLineArgs[i - 1]);
            }
            if (match || this.cmdLineArgs[i].equals(this.getCommand())) continue;
            validationErrors.add("Unrecognized argument: " + this.cmdLineArgs[i]);
        }
    }

    public boolean isCommandArgument(String arg) {
        for (CommandArgument cmdArgument : this.commandArguments) {
            if (!cmdArgument.equalsCmdArg(arg)) continue;
            return true;
        }
        return false;
    }

    public String getPreambleLogString(String[] args, String command) {
        StringBuilder sb = new StringBuilder();
        sb.append("Running the " + command + " command");
        if (args.length > 1) {
            sb.append(" with the arguments: ");
            for (int i = 1; i < args.length; ++i) {
                sb.append(args[i]).append(" ");
            }
        }
        return sb.toString();
    }

    @Override
    public List<CommandArgument> getArguments() {
        return this.commandArguments;
    }
}

