/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.console.configkeymgr;

import com.pingidentity.console.configkeymgr.CommandArgument;
import com.pingidentity.console.configkeymgr.ConfigKeyBaseCommand;
import com.pingidentity.console.configkeymgr.ConfigKeyCommand;
import com.pingidentity.console.configkeymgr.ConfigKeyManager;
import com.pingidentity.console.configkeymgr.OAuthClientScanner;
import com.pingidentity.reencryption.KeyInUseHandler;
import com.pingidentity.reencryption.PFEncryptionFilter;
import com.pingidentity.reencryption.ReencryptUtils;
import com.pingidentity.reencryption.ValueHandler;
import com.pingidentity.reencryption.filescanner.FileScanner;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class DeleteCommand
extends ConfigKeyBaseCommand
implements ConfigKeyCommand {
    private static final Logger log = LogManager.getLogger(DeleteCommand.class);
    private final CommandArgument TIMESTAMP_ARG = new CommandArgument("before-timestamp", null, "Any keys that were created before the specified time will be deleted", true);
    private final CommandArgument KEY_ID_ARG = new CommandArgument("keyid", null, "Deletes the key with the specified key id", true);
    private final CommandArgument BEFORE_KEY_ID_ARG = new CommandArgument("before-keyid", null, "Any keys that were created before the specified key will be deleted", true);
    private final CommandArgument DRY_RUN_ARG = new CommandArgument("dry-run", null, "Perform a dry run of the delete command. No keys will be deleted", false);
    private final CommandArgument SKIP_KEY_USAGE_CHECK = new CommandArgument("skip-key-usage-check", null, "Optionally bypass a scan of configuration data that ensures no in-use keys are deleted", false);
    private boolean dryRun;
    boolean skipKeyUsageCheck;
    boolean skipConfirmation;
    String timestamp;
    String keyId;
    String beforeKeyId;

    public DeleteCommand() {
        this.commandArguments = this.initializeArguments();
    }

    @Override
    public void execute(String[] args) throws IOException {
        log.info(this.getPreambleLogString(args, "Delete Keys"));
        this.cmdLineArgs = Arrays.copyOf(args, args.length);
        this.dryRun = this.checkForFlag(this.DRY_RUN_ARG);
        this.skipKeyUsageCheck = this.checkForFlag(this.SKIP_KEY_USAGE_CHECK);
        this.skipConfirmation = this.checkForFlag(this.SKIP_CONFIRMATION_PROMPT);
        this.timestamp = this.getArgument(this.TIMESTAMP_ARG);
        this.keyId = this.getArgument(this.KEY_ID_ARG);
        this.beforeKeyId = this.getArgument(this.BEFORE_KEY_ID_ARG);
        List<String> argumentValidationErrors = this.validateArguments();
        if (!argumentValidationErrors.isEmpty()) {
            this.outputCmdLineArgumentErrors(argumentValidationErrors);
            return;
        }
        StringBuilder message = new StringBuilder("The delete utility will permanently delete configuration keys which may cause data loss and configuration errors if any deleted keys are still in use.\n");
        if (!this.skipKeyUsageCheck) {
            message.append("Note that this utility does not check key usage by persistent authentication sessions or persistent grants. If these optional capabilities apply, review their expiry information prior to key deletion.\n");
        }
        if (!this.skipConfirmation && !this.dryRun) {
            if (!this.dryRun) {
                message.append("Run the tool with the dry-run argument to see which keys will be deleted, without performing any deletions.\n");
            }
            if (ConfigKeyManager.isEngine()) {
                message.append("Warning: The delete utility is being run on an engine node. Please ensure that configuration has been replicated from the Administrative Console before deleting keys.\n");
            }
            if (this.skipKeyUsageCheck) {
                message.append("Warning: Running the delete utility with the skip-key-usage-check argument may result in the deletion of in-use keys, causing data loss or configuration errors.\n");
            }
            message.append("Do you wish to proceed? [yes/no]:");
            if (!this.getConfirmation(message.toString())) {
                System.out.println("Exiting...");
                return;
            }
        }
        if (this.timestamp != null) {
            this.deleteKeysByTimestamp(this.timestamp, this.dryRun, this.skipKeyUsageCheck);
        } else if (this.beforeKeyId != null) {
            this.deleteKeysBeforeKeyId(this.beforeKeyId, this.dryRun, this.skipKeyUsageCheck);
        } else if (this.keyId != null) {
            this.deleteKeyById(this.keyId, this.dryRun, this.skipKeyUsageCheck);
        }
    }

    public void deleteKeysBeforeKeyId(String keyId, boolean dryRun, boolean skipKeyUsageCheck) throws IOException {
        Long timestamp = this.getTimestampOfKey(keyId);
        if (this.getKeyById(keyId) == null) {
            System.out.println("Could not find a key with the id " + keyId);
            return;
        }
        if (timestamp != null) {
            List<JsonWebKey> keysToDelete = this.getKeysToDelete(timestamp);
            this.doDeleteKeys(keysToDelete, dryRun, skipKeyUsageCheck);
        } else {
            System.out.println("The specified key does not have a creation date. Use the --keyid argument to delete a specific key.");
        }
    }

    public void deleteKeyById(String keyId, boolean dryRun, boolean skipKeyUsageCheck) throws IOException {
        if (this.getKeyById(keyId) == null) {
            System.out.println("Could not find a key with the id " + keyId);
            return;
        }
        this.doDeleteKeys(Collections.singletonList(this.getKeyById(keyId)), dryRun, skipKeyUsageCheck);
    }

    public void deleteKeysByTimestamp(String timestamp, boolean dryRun, boolean skipKeyUsageCheck) throws IOException {
        Long epochSecondsTimestamp = this.convertTimestampToEpochSeconds(timestamp);
        if (epochSecondsTimestamp == null) {
            System.out.println("Could not parse the provided timestamp of " + timestamp);
            return;
        }
        List<JsonWebKey> keysToDelete = this.getKeysToDelete(epochSecondsTimestamp);
        this.doDeleteKeys(keysToDelete, dryRun, skipKeyUsageCheck);
    }

    public void doDeleteKeys(List<JsonWebKey> keysToDelete, boolean dryRun, boolean skipKeyUsageCheck) throws IOException {
        if (!skipKeyUsageCheck) {
            List<String> keysInUse = this.getKeysInUse();
            List<JsonWebKey> inUseKeysToDelete = keysToDelete.stream().filter(key -> keysInUse.contains(key.getKeyId())).collect(Collectors.toList());
            if (inUseKeysToDelete.size() != 0) {
                ConfigKeyManager.logAndOutputMessage("WARNING: The following keys are currently used to encrypt configuration data.", log);
                ConfigKeyManager.logAndOutputMessage(this.getKeyListMessage(inUseKeysToDelete), log);
                if (this.willPrimaryKeyBeDeleted(keysToDelete)) {
                    System.out.println("The current primary configuration encryption key with id " + ReencryptUtils.getCurrentKeyId() + " was marked for deletion. The configuration encryption key must be rotated and the reencryption utility must be run before this key can be deleted.");
                }
                ConfigKeyManager.logAndOutputMessage("The deletion process has been aborted as deleting these keys will result in configuration errors.", log);
                return;
            }
            System.out.println("No keys marked for deletion were found to be in-use.");
        }
        if (dryRun) {
            if (keysToDelete.isEmpty()) {
                System.out.println("Dry run complete, no keys would be deleted.");
            } else {
                System.out.println("Dry run complete, the following keys would be deleted: ");
                System.out.println(this.getKeyListMessage(keysToDelete));
                if (this.willPrimaryKeyBeDeleted(keysToDelete)) {
                    System.out.println("The current primary configuration encryption key with id " + ReencryptUtils.getCurrentKeyId() + " was marked for deletion. The configuration encryption key must be rotated and the reencryption utility must be run before this key can be deleted.");
                }
            }
        } else if (keysToDelete.isEmpty()) {
            ConfigKeyManager.logAndOutputMessage("No keys were deleted.", log);
        } else {
            ConfigKeyManager.logAndOutputMessage("The following keys will be deleted:\n" + this.getKeyListMessage(keysToDelete), log);
            if (this.willPrimaryKeyBeDeleted(keysToDelete)) {
                ConfigKeyManager.logAndOutputMessage("The deletion process has been aborted as the current primary configuration encryption key with id " + ReencryptUtils.getCurrentKeyId() + " would have been deleted. The configuration encryption key must be rotated and the reencryption utility must be run before this key can be deleted.\nNo keys have been deleted.", log);
            } else {
                this.deleteKeys(keysToDelete);
                ConfigKeyManager.logAndOutputMessage("Deletion complete.", log);
            }
        }
    }

    public List<String> getKeysInUse() {
        ArrayList<String> keysInUse = new ArrayList<String>();
        String defaultDir = System.getProperty("pf.home");
        Collection pfFiles = FileUtils.listFiles((File)new File(defaultDir), (IOFileFilter)PFEncryptionFilter.FILE_FILTER, (IOFileFilter)PFEncryptionFilter.CONSOLE_FILTER);
        for (File file : pfFiles) {
            KeyInUseHandler valueHandler = new KeyInUseHandler();
            FileScanner fileScanner = ReencryptUtils.getFileScanner((File)file);
            if (fileScanner == null) continue;
            List keysUsedInFile = (List)fileScanner.scanFile(file, (ValueHandler)valueHandler);
            keysUsedInFile.forEach(keyId -> {
                if (!keysInUse.contains(keyId)) {
                    keysInUse.add((String)keyId);
                }
            });
        }
        try {
            OAuthClientScanner clientScanner = new OAuthClientScanner();
            if (clientScanner.isExternalClientStorage()) {
                System.out.println("Scanning OAuth clients stored in external datastore. This may take a while if there are a lot of clients...");
                List<String> keysUsedByClients = clientScanner.getKeysInUse();
                keysInUse.addAll(keysUsedByClients);
            }
        }
        catch (Exception e) {
            System.out.println("There was an error scanning external OAuth clients. Please check the configkeymgr.log for more details.");
            log.error("There was an error scanning external OAuth clients.", (Throwable)e);
            throw new RuntimeException("There was an error scanning external OAuth clients.");
        }
        return keysInUse;
    }

    public List<JsonWebKey> getKeysToDelete(long timestamp) {
        List initialList = MgmtFactory.getMasterKeySet().getJsonWebKeySet().getJsonWebKeys();
        ArrayList<JsonWebKey> keysToDelete = new ArrayList<JsonWebKey>();
        boolean keyWithTimestampFound = false;
        for (JsonWebKey key : initialList) {
            if (key.getOtherParameterValue("creationDate", Long.class) != null) {
                keyWithTimestampFound = true;
            }
            if (!this.keyHasEarlierTimestamp(key, timestamp) || !keyWithTimestampFound) continue;
            keysToDelete.add(key);
        }
        return keysToDelete;
    }

    public boolean keyHasEarlierTimestamp(JsonWebKey key, long timestamp) {
        Long t1 = (Long)key.getOtherParameterValue("creationDate", Long.class);
        if (t1 != null) {
            return t1 < timestamp;
        }
        return true;
    }

    public void deleteKeys(List<JsonWebKey> keys) {
        for (JsonWebKey keyToDelete : keys) {
            log.info("Deleting " + keyToDelete.getKeyId());
        }
        MgmtFactory.getMasterKeySet().deleteKeysFromKeySet(new JsonWebKeySet(keys));
    }

    public JsonWebKey getKeyById(String keyId) {
        List keys = MgmtFactory.getMasterKeySet().getJsonWebKeySet().getJsonWebKeys();
        for (JsonWebKey key : keys) {
            if (!key.getKeyId().equals(keyId)) continue;
            return key;
        }
        return null;
    }

    public Long getTimestampOfKey(String keyId) {
        List keys = MgmtFactory.getMasterKeySet().getJsonWebKeySet().getJsonWebKeys();
        for (JsonWebKey key : keys) {
            if (!key.getKeyId().equals(keyId)) continue;
            Long timestamp = (Long)key.getOtherParameterValue("creationDate", Long.class);
            return timestamp;
        }
        return null;
    }

    private boolean willPrimaryKeyBeDeleted(List<JsonWebKey> keysToDelete) {
        String primaryKeyId = ReencryptUtils.getCurrentKeyId();
        return keysToDelete.stream().allMatch(key -> key.getKeyId().equals(primaryKeyId));
    }

    private Long convertTimestampToEpochSeconds(String timestamp) {
        Long epochSecondsTimestamp = null;
        if (this.convertUIFormatTimestamp(timestamp) != null) {
            epochSecondsTimestamp = this.convertUIFormatTimestamp(timestamp);
        } else if (this.convertAPIFormatTimestamp(timestamp) != null) {
            epochSecondsTimestamp = this.convertAPIFormatTimestamp(timestamp);
        } else if (this.convertEpochSecondsTimestamp(timestamp) != null) {
            epochSecondsTimestamp = this.convertEpochSecondsTimestamp(timestamp);
        }
        return epochSecondsTimestamp;
    }

    private Long convertAPIFormatTimestamp(String timestamp) {
        try {
            int tIndex = timestamp.indexOf(84);
            if (tIndex > 0) {
                Object reformattedTimestamp = timestamp.substring(0, tIndex);
                String timeidx = timestamp.substring(tIndex + 1);
                int dotIdx = ((String)(reformattedTimestamp = (String)reformattedTimestamp + " " + timeidx)).indexOf(46);
                if (dotIdx > 0) {
                    reformattedTimestamp = ((String)reformattedTimestamp).substring(0, dotIdx);
                    DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
                    LocalDateTime localDateTime = LocalDateTime.parse((CharSequence)reformattedTimestamp, format);
                    return localDateTime.toEpochSecond(ZoneOffset.UTC);
                }
            }
        }
        catch (StringIndexOutOfBoundsException | DateTimeParseException e) {
            return null;
        }
        return null;
    }

    private Long convertUIFormatTimestamp(String timestamp) {
        try {
            DateTimeFormatter format = DateTimeFormatter.ofPattern("E MMM dd HH:mm:ss z yyyy", Locale.ENGLISH);
            ZonedDateTime zonedDateTime = ZonedDateTime.parse(timestamp, format);
            return zonedDateTime.toEpochSecond();
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }

    private Long convertEpochSecondsTimestamp(String timestamp) {
        try {
            return Long.parseLong(timestamp);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private List<String> validateArguments() {
        String timestampError;
        ArrayList<String> errors = new ArrayList<String>();
        if (this.checkForFlag(this.TIMESTAMP_ARG) && this.timestamp == null) {
            errors.add("The before-timestamp arg requires a timestamp");
        }
        if (this.checkForFlag(this.KEY_ID_ARG) && this.keyId == null) {
            errors.add("The before-keyid arg requires a key id");
        }
        if (this.numArgsProvided(this.checkForFlag(this.KEY_ID_ARG), this.checkForFlag(this.BEFORE_KEY_ID_ARG), this.checkForFlag(this.TIMESTAMP_ARG)) > 1) {
            errors.add("Only one of the before-timestamp, before-keyid or keyid arguments should be provided");
        }
        if (this.numArgsProvided(this.checkForFlag(this.KEY_ID_ARG), this.checkForFlag(this.BEFORE_KEY_ID_ARG), this.checkForFlag(this.TIMESTAMP_ARG)) == 0) {
            errors.add("The delete utility requires one of the following arguments: before-timestamp, keyid or before-keyid");
        }
        this.checkForInvalidArguments(errors);
        if (!errors.isEmpty()) {
            return errors;
        }
        if (this.timestamp != null && (timestampError = this.validateTimestamp(this.timestamp)) != null) {
            errors.add(timestampError);
        }
        if (this.keyId != null && this.getKeyById(this.keyId) == null) {
            errors.add("Could not find a key with the id " + this.keyId);
        }
        return errors;
    }

    private int numArgsProvided(boolean ... args) {
        int numProvided = 0;
        for (boolean arg : args) {
            if (!arg) continue;
            ++numProvided;
        }
        return numProvided;
    }

    private String getKeyListMessage(List<JsonWebKey> keyIds) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < keyIds.size() - 1; ++i) {
            sb.append(keyIds.get(i).getKeyId() + "\n");
        }
        sb.append(keyIds.get(keyIds.size() - 1).getKeyId());
        return sb.toString();
    }

    public String validateTimestamp(String timestamp) {
        String error = null;
        if (this.convertAPIFormatTimestamp(timestamp) == null && this.convertEpochSecondsTimestamp(timestamp) == null && this.convertUIFormatTimestamp(timestamp) == null) {
            error = "Could not parse the provided timestamp of " + timestamp;
        }
        return error;
    }

    @Override
    public String getCommand() {
        return "--delete";
    }

    @Override
    public String getCommandDescription() {
        return "Deletes configuration encryption keys";
    }

    @Override
    protected List<CommandArgument> initializeArguments() {
        return Arrays.asList(this.TIMESTAMP_ARG, this.KEY_ID_ARG, this.BEFORE_KEY_ID_ARG, this.DRY_RUN_ARG, this.SKIP_KEY_USAGE_CHECK, this.SKIP_CONFIRMATION_PROMPT);
    }
}

