/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.console.configkeymgr;

import com.pingidentity.common.util.ObfuscationException;
import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.console.configkeymgr.OAuthClientHandler;
import com.pingidentity.reencryption.ReencryptUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.ClientSecondarySecretSet;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.domain.SearchCriteria;

public class OAuthClientScanner {
    private static final Logger log = LogManager.getLogger(OAuthClientScanner.class);
    ClientManager clientManager = MgmtFactory.getClientManager();
    private final int BATCH_SIZE = 100;

    public boolean isExternalClientStorage() {
        try {
            return this.clientManager.isBackendDatabase();
        }
        catch (ApplicationRuntimeException e) {
            return false;
        }
    }

    public List<String> getKeysInUse() {
        KeysInUseHandler keysInUseHandler = new KeysInUseHandler();
        this.scanOAuthClients(keysInUseHandler);
        return (List)keysInUseHandler.getResult();
    }

    public List<String> reencryptClients() {
        ReencryptorHandler reencryptorHandler = new ReencryptorHandler();
        this.scanOAuthClients(reencryptorHandler);
        return (List)reencryptorHandler.getResult();
    }

    public List<String> getOAuthClientsWithReversibleSecrets() {
        ReversibleSecretFinder reversibleSecretFinder = new ReversibleSecretFinder();
        this.scanOAuthClients(reversibleSecretFinder);
        return (List)reversibleSecretFinder.getResult();
    }

    public void scanOAuthClients(OAuthClientHandler handler) {
        int searchStartIndex = 0;
        boolean doContinue = true;
        while (doContinue) {
            SearchCriteria searchCriteria = new SearchCriteria.Builder(searchStartIndex, 100).build();
            List clients = this.clientManager.search(searchCriteria).getResults();
            if (clients.isEmpty()) {
                doContinue = false;
            } else {
                for (Client client : clients) {
                    handler.handle(client);
                }
                System.out.println(handler.getProgressMessage());
                handler.resetBatchProgress();
            }
            searchStartIndex += 100;
        }
    }

    private static class ReversibleSecretFinder
    implements OAuthClientHandler {
        List<String> clientsWithReversibleSecrets = new ArrayList<String>();
        int numClientsScanned = 0;
        int numClientsWithReversibleSecrets = 0;

        private ReversibleSecretFinder() {
        }

        @Override
        public void handle(Client client) {
            boolean containsReversibleSecret = false;
            ++this.numClientsScanned;
            String reversibleSecret = client.getObfuscatedReversableSecret();
            if (reversibleSecret != null && !this.clientsWithReversibleSecrets.contains(client.getClientId())) {
                containsReversibleSecret = true;
            }
            for (ClientSecondarySecretSet.ClientSecondarySecret secondarySecret : client.getSecondarySecrets().getSecondarySecrets()) {
                if (secondarySecret.getReversibleSecret() == null) continue;
                containsReversibleSecret = true;
            }
            if (containsReversibleSecret) {
                this.clientsWithReversibleSecrets.add(client.getClientId());
                ++this.numClientsWithReversibleSecrets;
            }
        }

        @Override
        public Object getResult() {
            return this.clientsWithReversibleSecrets;
        }

        @Override
        public String getProgressMessage() {
            return this.numClientsScanned + " OAuth clients scanned. " + this.numClientsWithReversibleSecrets + " clients contain encrypted data";
        }

        @Override
        public void resetBatchProgress() {
            this.numClientsScanned = 0;
            this.numClientsWithReversibleSecrets = 0;
        }
    }

    private class ReencryptorHandler
    implements OAuthClientHandler {
        List<String> reencryptedClients = new ArrayList<String>();
        int numClientsScanned = 0;
        int numClientsReencrypted = 0;

        private ReencryptorHandler() {
        }

        @Override
        public void handle(Client client) {
            ++this.numClientsScanned;
            try {
                boolean clientUpdated = false;
                String reversibleSecret = client.getReversableSecretAsString();
                if (reversibleSecret != null) {
                    String reencrytedSecret = Obfuscator.obfuscate((String)reversibleSecret);
                    client.setObfuscatedReversableSecret(reencrytedSecret);
                    clientUpdated = true;
                }
                if (client.getSecondarySecrets() != null) {
                    for (ClientSecondarySecretSet.ClientSecondarySecret secondarySecret : client.getSecondarySecrets().getSecondarySecrets()) {
                        String reversibleSecondary = secondarySecret.getReversibleSecret();
                        if (reversibleSecondary == null) continue;
                        String deobfuscatedSecret = Obfuscator.deobfuscate((String)reversibleSecondary);
                        secondarySecret.setReversibleSecret(Obfuscator.obfuscate((String)deobfuscatedSecret));
                        clientUpdated = true;
                    }
                }
                if (clientUpdated) {
                    log.info("Reencrypting client " + client.getClientId());
                    OAuthClientScanner.this.clientManager.updateClient(client);
                    this.reencryptedClients.add(client.getClientId());
                    ++this.numClientsReencrypted;
                }
            }
            catch (ObfuscationException e) {
                log.error("Client " + client.getClientId() + " could not be decrypted.", (Throwable)e);
            }
        }

        @Override
        public Object getResult() {
            return this.reencryptedClients;
        }

        @Override
        public String getProgressMessage() {
            return this.numClientsScanned + " OAuth clients scanned. " + this.numClientsReencrypted + " clients were reencrypted";
        }

        @Override
        public void resetBatchProgress() {
            this.numClientsScanned = 0;
            this.numClientsReencrypted = 0;
        }
    }

    private static class KeysInUseHandler
    implements OAuthClientHandler {
        List<String> keyIds = new ArrayList<String>();
        int numClientsScanned = 0;

        private KeysInUseHandler() {
        }

        @Override
        public void handle(Client client) {
            ++this.numClientsScanned;
            String reversibleSecret = client.getObfuscatedReversableSecret();
            this.trackKeyUsedToEncrypt(reversibleSecret);
            for (ClientSecondarySecretSet.ClientSecondarySecret secondarySecret : client.getSecondarySecrets().getSecondarySecrets()) {
                String reversibleSecondary = secondarySecret.getReversibleSecret();
                this.trackKeyUsedToEncrypt(reversibleSecondary);
            }
        }

        @Override
        public Object getResult() {
            return this.keyIds;
        }

        @Override
        public String getProgressMessage() {
            return this.numClientsScanned + " clients scanned for in-use keys";
        }

        @Override
        public void resetBatchProgress() {
            this.numClientsScanned = 0;
        }

        private void trackKeyUsedToEncrypt(String reversibleSecret) {
            String keyId;
            if (reversibleSecret != null && (keyId = ReencryptUtils.getKeyUsedToEncrypt((String)reversibleSecret)) != null && !this.keyIds.contains(keyId)) {
                this.keyIds.add(keyId);
            }
        }
    }
}

