/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.console.configkeymgr;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.console.configkeymgr.CommandArgument;
import com.pingidentity.console.configkeymgr.ConfigKeyBaseCommand;
import com.pingidentity.console.configkeymgr.ConfigKeyCommand;
import com.pingidentity.console.configkeymgr.ConfigKeyManager;
import com.pingidentity.console.configkeymgr.OAuthClientScanner;
import com.pingidentity.reencryption.PFEncryptionFilter;
import com.pingidentity.reencryption.ReencryptUtils;
import com.pingidentity.reencryption.ReencryptionTarget;
import com.pingidentity.reencryption.ValueHandler;
import com.pingidentity.reencryption.ValueReencryptor;
import com.pingidentity.reencryption.filescanner.FileScanner;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ReencryptCommand
extends ConfigKeyBaseCommand
implements ConfigKeyCommand {
    private static final Logger log = LogManager.getLogger(ReencryptCommand.class);
    private final CommandArgument DRY_RUN_ARG = new CommandArgument("dry-run", null, "Perform a dry run of the reencrypt command, listing which files contain encrypted data. No data will be reencrypted", false);
    private final CommandArgument SKIP_EXTERNAL_DATA = new CommandArgument("skip-external-data", null, "Do not reencrypt OAuth client data stored in an external datastore", false);
    boolean dryRun;
    boolean skipConfirmation;
    boolean skipExternalData;

    public ReencryptCommand() {
        this.commandArguments = this.initializeArguments();
    }

    @Override
    public void execute(String[] args) throws IOException {
        IOFileFilter dirFilter;
        boolean isPassiveConsole;
        log.info(this.getPreambleLogString(args, "Reencrypt"));
        this.cmdLineArgs = Arrays.copyOf(args, args.length);
        this.dryRun = this.checkForFlag(this.DRY_RUN_ARG);
        this.skipConfirmation = this.checkForFlag(this.SKIP_CONFIRMATION_PROMPT);
        this.skipExternalData = this.checkForFlag(this.SKIP_EXTERNAL_DATA);
        List<String> argumentValidationErrors = this.validateArguments();
        if (!argumentValidationErrors.isEmpty()) {
            this.outputCmdLineArgumentErrors(argumentValidationErrors);
            return;
        }
        boolean bl = isPassiveConsole = ConfigKeyManager.isActivePassiveFeatureEnabled() && ConfigKeyManager.isPassiveNode();
        if (!this.skipConfirmation && !this.dryRun) {
            String message = "The Reencryption utility will reencrypt all data that is encrypted with a configuration encryption key.\n" + (isPassiveConsole ? "Please ensure synchronization has occurred between this passive console and the active console before proceeding.\n" : "") + "Do you wish to proceed? [yes/no]:";
            if (!this.skipConfirmation && !this.getConfirmation(message)) {
                System.out.println("Exiting...");
                return;
            }
        }
        this.checkBCFIPSMode();
        System.out.println("Scanning deployment...");
        String rootDir = MgmtFactory.getSysDirInfo().getRootDir();
        if (ConfigKeyManager.isEngine()) {
            System.out.println("Running on an engine, the data directory will not be reencrypted.");
            dirFilter = PFEncryptionFilter.ENGINE_FILTER;
        } else if (isPassiveConsole) {
            System.out.println("Running on a passive console. The data directory will not be reencrypted, because it should have synchronized from the active node.");
            dirFilter = PFEncryptionFilter.ENGINE_FILTER;
        } else {
            dirFilter = PFEncryptionFilter.CONSOLE_FILTER;
        }
        Collection pfFiles = FileUtils.listFiles((File)new File(rootDir), (IOFileFilter)PFEncryptionFilter.FILE_FILTER, (IOFileFilter)dirFilter);
        ArrayList<ReencryptionTarget> targets = new ArrayList<ReencryptionTarget>();
        ArrayList<ReencryptionTarget> legacyEncryptedFiles = new ArrayList<ReencryptionTarget>();
        for (File file : pfFiles) {
            log.debug("Scanning file: {}", (Object)file.getAbsolutePath());
            FileScanner fileScanner = ReencryptUtils.getFileScanner((File)file);
            if (fileScanner == null) continue;
            ValueReencryptor valueHandler = new ValueReencryptor();
            ReencryptionTarget reencryptionTarget = (ReencryptionTarget)fileScanner.scanFile(file, (ValueHandler)valueHandler);
            if (reencryptionTarget.hasAnyEncryptedFields()) {
                targets.add(reencryptionTarget);
            }
            if (!reencryptionTarget.getHasLegacyEncryptedField()) continue;
            legacyEncryptedFiles.add(reencryptionTarget);
        }
        this.outputScanResults(targets);
        if (!targets.isEmpty() && !this.dryRun) {
            try {
                boolean backupSuccess = this.createBackup(targets);
                if (backupSuccess) {
                    System.out.println("Performing file reencryption with key " + ReencryptUtils.getCurrentKeyId() + "...");
                    ReencryptUtils.performReencryption(targets);
                    this.clearIndexDirectory(targets);
                }
            }
            catch (IOException e) {
                System.out.println("There was an error reencrypting data. Please check the configkeymgr.log for more details.");
                log.error("There was an error reencrypting data.", (Throwable)e);
            }
            System.out.println("File reencryption complete.");
        }
        this.outputLegacyEncryptedResults(legacyEncryptedFiles);
        if (!this.skipExternalData && !ConfigKeyManager.isEngine()) {
            try {
                OAuthClientScanner clientScanner = new OAuthClientScanner();
                if (clientScanner.isExternalClientStorage()) {
                    if (this.dryRun) {
                        System.out.println("Scanning OAuth clients stored in external datastore. This may take a while if there are a lot of clients...");
                        List<String> clientsWithReversibleSecrets = clientScanner.getOAuthClientsWithReversibleSecrets();
                        this.outputExternalClientResults(clientsWithReversibleSecrets, true);
                    } else {
                        System.out.println("Reencrypting OAuth clients stored in external datastore. This may take a while if there are a lot of clients...");
                        List<String> reencryptedClients = clientScanner.reencryptClients();
                        this.outputExternalClientResults(reencryptedClients, false);
                    }
                }
            }
            catch (Exception e) {
                System.out.println("There was an error scanning external OAuth clients. Please check the configkeymgr.log for more details.");
                log.error("There was an error scanning external OAuth clients.", (Throwable)e);
                throw new RuntimeException("There was an error scanning external OAuth clients.");
            }
        }
    }

    public void outputScanResults(List<ReencryptionTarget> targets) {
        if (!targets.isEmpty()) {
            ConfigKeyManager.logAndOutputMessage("Encrypted values were found in the following files: ", log);
            for (ReencryptionTarget target : targets) {
                System.out.println(ReencryptUtils.getRelativeFilePath((String)target.getFile().getPath()));
                log.info(ReencryptUtils.getRelativeFilePath((String)target.getFile().getPath()));
            }
        } else {
            ConfigKeyManager.logAndOutputMessage("No files with reencryptable data were found.", log);
        }
    }

    public void outputLegacyEncryptedResults(List<ReencryptionTarget> legacyEncryptedFiles) {
        if (!legacyEncryptedFiles.isEmpty()) {
            System.out.println("Warning: Files containing data encrypted with a legacy AES or Blowfish mechanism have been found:");
            log.info("Files containing data encrypted with a legacy AES or Blowfish mechanism have been found:");
            for (ReencryptionTarget target : legacyEncryptedFiles) {
                System.out.println(ReencryptUtils.getRelativeFilePath((String)target.getFile().getPath()));
                log.info(ReencryptUtils.getRelativeFilePath((String)target.getFile().getPath()));
            }
            System.out.println("This data cannot be reencrypted with this tool.");
        }
    }

    public void outputExternalClientResults(List<String> clients, boolean dryRun) {
        System.out.println("Scan complete.");
        if (clients.isEmpty() && dryRun) {
            System.out.println("No OAuth clients with encrypted data were found.");
        } else if (clients.isEmpty() && !dryRun) {
            System.out.println("No OAuth clients were reencrypted");
        } else {
            if (dryRun) {
                System.out.println("A total of " + clients.size() + " OAuth clients with encrypted data were found.");
            } else {
                System.out.println("A total of " + clients.size() + " OAuth clients with encrypted data were reencrypted.");
            }
            String pfRootDir = MgmtFactory.getSysDirInfo().getRootDir();
            String binPath = StringUtils.join(Arrays.asList(pfRootDir, "bin"), (String)File.separator);
            String clientResultsFileName = dryRun ? "dry-run-oauth-clients-reencrypted-" + this.getCurrentDateString() + ".txt" : "oauth-clients-reencrypted-" + this.getCurrentDateString() + ".txt";
            File f = new File(binPath, clientResultsFileName);
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f, true), StandardCharsets.UTF_8));){
                for (String clientId : clients) {
                    writer.append(clientId).append("\n");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (dryRun) {
                System.out.println("Check the file " + ReencryptUtils.getRelativeFilePath((String)f.getPath()) + " to see the list of clients that would be reencrypted.");
            } else {
                System.out.println("Check the file " + ReencryptUtils.getRelativeFilePath((String)f.getPath()) + " to see the list of clients that have been reencrypted.");
            }
        }
    }

    private boolean createBackup(List<ReencryptionTarget> filesToBackup) {
        File output = this.getBackupFile();
        boolean backupError = false;
        try {
            List files = filesToBackup.stream().map(ReencryptionTarget::getFile).collect(Collectors.toList());
            try (FileOutputStream outputStream = new FileOutputStream(output);
                 ZipOutputStream zipOut = new ZipOutputStream(outputStream);){
                byte[] buffer = new byte[8192];
                for (File file : files) {
                    try (FileInputStream inputStream = new FileInputStream(file);){
                        int nRead;
                        zipOut.putNextEntry(new ZipEntry(ReencryptUtils.getRelativeFilePath((String)file.getPath())));
                        while ((nRead = inputStream.read(buffer, 0, buffer.length)) != -1) {
                            zipOut.write(buffer, 0, nRead);
                        }
                        zipOut.closeEntry();
                    }
                }
            }
        }
        catch (IOException e) {
            backupError = true;
            log.error("Error creating backup.", (Throwable)e);
        }
        if (!output.isFile() || backupError) {
            System.out.println("Error creating backup. Please check the configkeymgr.log for more details. Reencryption will not be performed.");
            return false;
        }
        System.out.println("A backup of reencrypted files has been created at: " + ReencryptUtils.getRelativeFilePath((String)output.getPath()));
        log.info("A backup of reencrypted files has been created at: {}", (Object)ReencryptUtils.getRelativeFilePath((String)output.getPath()));
        return true;
    }

    private File getBackupFile() {
        String binPath = MgmtFactory.getSysDirInfo().getBinDirectory();
        String backupFileName = "reencrypt-backup-" + this.getCurrentDateString() + ".zip";
        return new File(binPath, backupFileName);
    }

    public String getCurrentDateString() {
        String formatPattern = "MM-dd-yyyy.kk.mm.ss";
        SimpleDateFormat format = new SimpleDateFormat(formatPattern);
        return format.format(new Date());
    }

    private List<String> validateArguments() {
        ArrayList<String> errors = new ArrayList<String>();
        this.checkForInvalidArguments(errors);
        return errors;
    }

    private void checkBCFIPSMode() {
        if (PropertyInfo.isBCFIPSMode()) {
            log.info("BCFIPS mode is enabled. Data encrypted via a legacy method will not be identified.");
            System.out.println("Warning: BCFIPS mode is enabled. Data encrypted via a legacy method will not be identified.");
        }
    }

    private void clearIndexDirectory(List<ReencryptionTarget> targets) {
        if (targets.isEmpty()) {
            return;
        }
        if (ConfigKeyManager.isEngine()) {
            return;
        }
        log.debug("clearing Index directory");
        String indexDirStr = MgmtFactory.getSysDirInfo().getDataDirectory() + "/index";
        File indexDir = new File(indexDirStr);
        if (!indexDir.exists()) {
            log.debug("Index directory not found");
            return;
        }
        try {
            FileUtils.cleanDirectory((File)indexDir);
            log.debug("Index directory content removed");
            ConfigKeyManager.logAndOutputMessage("Index Directory cleanup operation succeeded", log);
        }
        catch (IOException e) {
            String msg = "Index directory cleanup operation failed";
            System.out.println(msg);
            log.error(msg, (Throwable)e);
        }
    }

    @Override
    public List<CommandArgument> getArguments() {
        return this.commandArguments;
    }

    @Override
    protected List<CommandArgument> initializeArguments() {
        return Arrays.asList(this.DRY_RUN_ARG, this.SKIP_CONFIRMATION_PROMPT, this.SKIP_EXTERNAL_DATA);
    }

    @Override
    public String getCommandDescription() {
        return "Reencrypts encrypted configuration data using the primary encryption key";
    }

    @Override
    public String getCommand() {
        return "--reencrypt";
    }
}

