/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.connection.template.pingone;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.common.util.Closer;
import com.pingidentity.common.util.xml.InvalidXmlException;
import com.pingidentity.module.connection.ConnectionModuleConfiguration;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerConfig;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerManager;
import com.pingidentity.provisioner.integrations.pingone.ProvisionerInformationKey;
import com.pingidentity.provisioner.integrations.pingone.pf.template.PingOneConfiguration;
import com.pingidentity.provisioner.integrations.pingone.pf.template.PingOneInformation;
import com.pingidentity.templates.connection.ConnectionTemplate;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlException;
import org.sourceid.saml20.adapter.conf.SimpleFieldList;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.util.api.ConnectionDeserializer;
import org.sourceid.util.license.LicenseManager;

public class PingOneTemplate
implements ConnectionTemplate {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(PingOneTemplate.class);
    public static final String TEMPLATE_ID = ProvisionerInformationKey.PROVISIONER_INFORMATION.getKey();
    public static final String TEMPLATE_DESCRIPTION = ProvisionerInformationKey.PROVISIONER_INFORMATION.getDisplayName();
    private static final String PINGONE_USER_STORE_CONNECTION = "pingone-connection.xml";
    private transient Optional<PingOneInformation> info;

    public PingOneTemplate() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            PingOneConfiguration config = (PingOneConfiguration)mapper.readValue(this.getClass().getClassLoader().getResourceAsStream("pingone-attributes.json"), PingOneConfiguration.class);
            this.info = Optional.ofNullable(config.getProvisionerInformation());
        }
        catch (IOException e) {
            log.error((Object)"Unable to read from pingone-attributes.json");
        }
    }

    public List<FieldDescriptor> getFieldDescriptors() {
        return null;
    }

    public String getId() {
        if (this.info.isPresent()) {
            return this.info.get().getKey();
        }
        return TEMPLATE_ID;
    }

    public String getDescription() {
        if (this.info.isPresent()) {
            return this.info.get().getDisplayName();
        }
        return TEMPLATE_DESCRIPTION;
    }

    public ConnectionBase getConnection(SimpleFieldList fieldList) {
        SpConnection spConnection = null;
        try {
            ConnectionDeserializer deserializer = this.getConnectionDeserializer();
            if (deserializer != null) {
                List problems = deserializer.getProblems();
                if (problems.isEmpty()) {
                    spConnection = (SpConnection)deserializer.getConnection();
                } else {
                    log.error((Object)("Unable to load PingOne User Store Connection Template: " + problems.toString()));
                }
                if (spConnection != null) {
                    spConnection.setOrganization(null);
                    if (LicenseManager.isSaasProvisioningEnabled() && ProvisionerManager.getProvisionerGlobalSettings().isEnabledInGui()) {
                        ProvisionerConfig provisionerConfig = new ProvisionerConfig(spConnection.getEntityId());
                        spConnection.addConnectionModuleConfiguration((ConnectionModuleConfiguration)provisionerConfig);
                    }
                }
            }
        }
        catch (InvalidXmlException | IOException | XmlException e) {
            log.error((Object)("Unable to load PingOne User Store Connection Template: " + e.getMessage()));
        }
        return spConnection;
    }

    public String getNote() {
        return null;
    }

    public List<String> checkPrerequisites() {
        return null;
    }

    private ConnectionDeserializer getConnectionDeserializer() throws InvalidXmlException, XmlException, IOException {
        ConnectionDeserializer deserializer = null;
        Enumeration<URL> resources = null;
        InputStream googleInputStream = null;
        try {
            Object content;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            resources = classLoader.getResources(PINGONE_USER_STORE_CONNECTION);
            URL url = resources.nextElement();
            if (resources.hasMoreElements()) {
                log.warn((Object)"Multiple xml template files detected. Loading the first found. (pingone-connection.xml)");
            }
            if ((content = url.getContent()) instanceof InputStream) {
                googleInputStream = (InputStream)content;
                deserializer = new ConnectionDeserializer(googleInputStream);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            Closer.close(googleInputStream);
        }
        return deserializer;
    }
}

