/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.io.cpl.pingone.retry;

import com.pingidentity.io.cpl.pingone.retry.RetryDelayCalculator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public final class ExponentialBackOffCalculator
implements RetryDelayCalculator {
    private static final double DELAY_IN_MILLIS = 5000.0;
    private static final double MULTIPLIER = 1.5;
    private static final int MAX_RETRY_ATTEMPTS = 10;
    private static final long MAX_DELAY = 0x6DDD00L;

    @Override
    public long calculateRetryDelay(int retryAttemptNumber) {
        try {
            SecureRandom randomGenerator = SecureRandom.getInstance("SHA1PRNG");
            return (long)(Math.pow(1.5, retryAttemptNumber) * 5000.0 + (double)randomGenerator.nextInt(1001));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public boolean shouldRetry(int retryAttemptNumber) {
        boolean exceededMaxRetryAttempts = retryAttemptNumber > 10;
        boolean exceedMaxWaitTime = this.calculateRetryDelay(retryAttemptNumber) > 0x6DDD00L;
        return !exceededMaxRetryAttempts && !exceedMaxWaitTime;
    }

    @Override
    public int getSuggestedMaxRetryAttempts() {
        return Integer.MAX_VALUE;
    }
}

