/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.prov.saas.pingone;

import com.pingidentity.io.cpl.pingone.IWorker;
import com.pingidentity.io.cpl.pingone.exception.ResourceException;
import com.pingidentity.io.cpl.pingone.exception.ResourceNotFoundException;
import com.pingidentity.io.cpl.pingone.exception.ServiceException;
import com.pingidentity.io.cpl.pingone.metadata.CapabilityType;
import com.pingidentity.io.cpl.pingone.request.ConnectionFields;
import com.pingidentity.io.cpl.pingone.request.Request;
import com.pingidentity.io.cpl.pingone.resource.Group;
import com.pingidentity.io.cpl.pingone.resource.Values;
import com.pingidentity.io.cpl.pingone.response.CreateGroupsResponse;
import com.pingidentity.io.cpl.pingone.response.DeleteGroupsResponse;
import com.pingidentity.io.cpl.pingone.response.GetGroupsResponse;
import com.pingidentity.io.cpl.pingone.response.GroupAttempt;
import com.pingidentity.io.cpl.pingone.response.UpdateGroupsResponse;
import com.pingidentity.prov.saas.pingone.CPLv3PluginWorker;
import com.pingidentity.prov.saas.pingone.GroupsPluginWorker;
import com.pingidentity.prov.saas.pingone.request.RequestBuilder;
import com.pingidentity.prov.saas.pingone.request.RequestBuilderFactory;
import com.pingidentity.prov.saas.pingone.request.groups.GroupRequestBuilderFactory;
import com.pingidentity.prov.saas.pingone.request.groups.GroupRequestParameters;
import com.pingidentity.provisioner.sdk.SaasGroupData;

public class CPLv3GroupsPluginWorker
extends CPLv3PluginWorker
implements GroupsPluginWorker {
    protected final GroupRequestBuilderFactory groupRequestBuilderFactory;
    protected String groupNameAttributeName;

    public CPLv3GroupsPluginWorker(IWorker worker, GroupRequestBuilderFactory requestBuilderFactory) {
        super(worker, (RequestBuilderFactory)((Object)requestBuilderFactory));
        this.groupRequestBuilderFactory = requestBuilderFactory;
    }

    public CPLv3GroupsPluginWorker(IWorker worker, GroupRequestBuilderFactory requestBuilderFactory, String groupNameAttributeName) {
        super(worker, (RequestBuilderFactory)((Object)requestBuilderFactory));
        this.groupRequestBuilderFactory = requestBuilderFactory;
        this.groupNameAttributeName = groupNameAttributeName;
    }

    @Override
    public String executeCreateGroup(SaasGroupData groupData, ConnectionFields connectionFields) throws ServiceException, ResourceException {
        GroupRequestParameters reqParams = new GroupRequestParameters(connectionFields, groupData);
        Request request = this.groupRequestBuilderFactory.make(CapabilityType.CREATE_GROUPS).build(reqParams);
        CreateGroupsResponse response = (CreateGroupsResponse)this.worker.doWork(request);
        if (response.hasServiceExceptions()) {
            throw (ServiceException)response.getServiceExceptions().get(0);
        }
        GroupAttempt attempt = (GroupAttempt)response.getGroupAttempts().get(0);
        if (attempt.getResourceExceptions().size() > 0) {
            throw (ResourceException)attempt.getResourceExceptions().get(0);
        }
        Group createdGroup = attempt.getGroup();
        return createdGroup.getResourceUniqueId().getId();
    }

    @Override
    public SaasGroupData executeGetGroup(SaasGroupData groupData, ConnectionFields connectionFields) throws ServiceException, ResourceException {
        GroupRequestParameters reqParams = new GroupRequestParameters(connectionFields, groupData);
        RequestBuilder requestBuilder = this.groupRequestBuilderFactory.make(CapabilityType.GET_GROUPS);
        Request request = requestBuilder.build(reqParams);
        GetGroupsResponse response = (GetGroupsResponse)this.worker.doWork(request);
        if (response.hasServiceExceptions()) {
            throw (ServiceException)response.getServiceExceptions().get(0);
        }
        GroupAttempt attempt = (GroupAttempt)response.getGroupAttempts().get(0);
        if (attempt.getResourceExceptions().size() > 0) {
            ResourceException e = (ResourceException)attempt.getResourceExceptions().get(0);
            if (e instanceof ResourceNotFoundException) {
                return null;
            }
            throw e;
        }
        Group createdGroup = attempt.getGroup();
        return this.convertCplGroup(createdGroup);
    }

    @Override
    public String executeUpdateGroup(SaasGroupData groupData, ConnectionFields connectionFields) throws ServiceException, ResourceException {
        GroupRequestParameters reqParams = new GroupRequestParameters(connectionFields, groupData);
        Request request = this.groupRequestBuilderFactory.make(CapabilityType.UPDATE_GROUPS).build(reqParams);
        UpdateGroupsResponse response = (UpdateGroupsResponse)this.worker.doWork(request);
        if (response.hasServiceExceptions()) {
            throw (ServiceException)response.getServiceExceptions().get(0);
        }
        GroupAttempt attempt = (GroupAttempt)response.getGroupAttempts().get(0);
        if (attempt.getResourceExceptions().size() > 0) {
            throw (ResourceException)attempt.getResourceExceptions().get(0);
        }
        Group updatedGroup = attempt.getGroup();
        return updatedGroup.getResourceUniqueId().getId();
    }

    @Override
    public void executeDeleteGroup(SaasGroupData groupData, ConnectionFields connectionFields) throws ServiceException, ResourceException {
        GroupRequestParameters reqParams = new GroupRequestParameters(connectionFields, groupData);
        Request request = this.groupRequestBuilderFactory.make(CapabilityType.DELETE_GROUPS).build(reqParams);
        DeleteGroupsResponse response = (DeleteGroupsResponse)this.worker.doWork(request);
        if (response.hasServiceExceptions()) {
            throw (ServiceException)response.getServiceExceptions().get(0);
        }
        GroupAttempt attempt = (GroupAttempt)response.getGroupAttempts().get(0);
        if (attempt.getResourceExceptions().size() > 0) {
            throw (ResourceException)attempt.getResourceExceptions().get(0);
        }
    }

    private SaasGroupData convertCplGroup(Group group) {
        if (group != null) {
            String saasGuid = null;
            String groupName = null;
            if (group.getResourceUniqueId() != null) {
                saasGuid = group.getResourceUniqueId().getId();
            }
            for (String key : group.getResourceAttributes().keySet()) {
                if (!key.equalsIgnoreCase(this.getGroupNameAttributeName())) continue;
                Values values = (Values)group.getResourceAttributes().get(key);
                if (values.size() <= 0) break;
                groupName = (String)values.get(0);
                break;
            }
            SaasGroupData data = new SaasGroupData(saasGuid, groupName);
            return data;
        }
        return null;
    }

    protected String getGroupNameAttributeName() {
        if (this.groupNameAttributeName == null) {
            return "name";
        }
        return this.groupNameAttributeName;
    }
}

