/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.prov.saas.pingone.cplv3Mock;

import com.pingidentity.io.cpl.pingone.Worker;
import com.pingidentity.io.cpl.pingone.request.CreateGroupsRequest;
import com.pingidentity.io.cpl.pingone.request.CreateUsersRequest;
import com.pingidentity.io.cpl.pingone.request.DeleteGroupsRequest;
import com.pingidentity.io.cpl.pingone.request.DeleteUsersRequest;
import com.pingidentity.io.cpl.pingone.request.GetAttributesRequest;
import com.pingidentity.io.cpl.pingone.request.GetConnectionProfilesRequest;
import com.pingidentity.io.cpl.pingone.request.GetGroupsRequest;
import com.pingidentity.io.cpl.pingone.request.GetInfoRequest;
import com.pingidentity.io.cpl.pingone.request.GetUsersRequest;
import com.pingidentity.io.cpl.pingone.request.UpdateGroupsRequest;
import com.pingidentity.io.cpl.pingone.request.UpdateUsersRequest;
import com.pingidentity.io.cpl.pingone.resource.Group;
import com.pingidentity.io.cpl.pingone.resource.ResourceUniqueId;
import com.pingidentity.io.cpl.pingone.resource.User;
import com.pingidentity.io.cpl.pingone.response.CreateGroupsResponse;
import com.pingidentity.io.cpl.pingone.response.CreateUsersResponse;
import com.pingidentity.io.cpl.pingone.response.DeleteGroupsResponse;
import com.pingidentity.io.cpl.pingone.response.DeleteUsersResponse;
import com.pingidentity.io.cpl.pingone.response.GetAttributesResponse;
import com.pingidentity.io.cpl.pingone.response.GetConnectionProfilesResponse;
import com.pingidentity.io.cpl.pingone.response.GetGroupsResponse;
import com.pingidentity.io.cpl.pingone.response.GetInfoResponse;
import com.pingidentity.io.cpl.pingone.response.GetUsersResponse;
import com.pingidentity.io.cpl.pingone.response.GroupAttempt;
import com.pingidentity.io.cpl.pingone.response.GroupAttempts;
import com.pingidentity.io.cpl.pingone.response.UpdateGroupsResponse;
import com.pingidentity.io.cpl.pingone.response.UpdateUsersResponse;
import com.pingidentity.io.cpl.pingone.response.UserAttempt;
import com.pingidentity.io.cpl.pingone.response.UserAttempts;
import com.pingidentity.prov.saas.pingone.cplv3Mock.MockMetadataBuilder;
import java.util.HashMap;
import java.util.Map;

public class MockWorker
extends Worker {
    private final Map<String, User> users = new HashMap<String, User>();
    private final Map<String, Group> groups = new HashMap<String, Group>();
    private final MockMetadataBuilder mdBuilder = new MockMetadataBuilder();

    @Override
    protected GetInfoResponse getInfo(GetInfoRequest request) {
        GetInfoResponse response = new GetInfoResponse();
        response.setInformation(this.mdBuilder.getInfo());
        return response;
    }

    @Override
    protected GetConnectionProfilesResponse getConnectionProfiles(GetConnectionProfilesRequest request) {
        GetConnectionProfilesResponse response = new GetConnectionProfilesResponse();
        response.setConnectionProfiles(this.mdBuilder.getConnectionProfiles());
        return response;
    }

    @Override
    protected GetAttributesResponse getAttributes(GetAttributesRequest request) {
        GetAttributesResponse response = new GetAttributesResponse();
        response.setAttributeMetadata(this.mdBuilder.getAttributeMetadata());
        return response;
    }

    @Override
    protected UpdateUsersResponse updateUsers(UpdateUsersRequest request) {
        User reqUser = (User)request.getUsers().get(0);
        ResourceUniqueId ruid = reqUser.getResourceUniqueId();
        this.users.put(ruid.getId(), reqUser);
        UserAttempts attempts = this.getUserAttempts(ruid);
        UpdateUsersResponse response = new UpdateUsersResponse(attempts);
        return response;
    }

    @Override
    protected GetUsersResponse getUsers(GetUsersRequest request) {
        User reqUser = (User)request.getUsers().get(0);
        ResourceUniqueId ruid = reqUser.getResourceUniqueId();
        GetUsersResponse response = new GetUsersResponse(this.getUserAttempts(ruid));
        return response;
    }

    @Override
    protected CreateUsersResponse createUsers(CreateUsersRequest request) {
        User user = (User)request.getUsers().get(0);
        ResourceUniqueId ruid = user.getResourceUniqueId();
        String key = user.getResourceUniqueId().getId();
        this.users.put(key, user);
        UserAttempts attempts = this.getUserAttempts(ruid);
        CreateUsersResponse response = new CreateUsersResponse(attempts);
        return response;
    }

    @Override
    protected DeleteUsersResponse deleteUsers(DeleteUsersRequest request) {
        User user = (User)request.getUsers().get(0);
        String key = user.getResourceUniqueId().getId();
        DeleteUsersResponse response = new DeleteUsersResponse(this.getUserAttempts(user.getResourceUniqueId()));
        this.users.remove(key);
        return response;
    }

    @Override
    protected CreateGroupsResponse createGroups(CreateGroupsRequest request) {
        Group group = (Group)request.getGroups().get(0);
        ResourceUniqueId ruid = group.getResourceUniqueId();
        String key = ruid.getId();
        this.groups.put(key, group);
        CreateGroupsResponse response = new CreateGroupsResponse(this.getGroupAttempts(ruid));
        return response;
    }

    @Override
    protected GetGroupsResponse getGroups(GetGroupsRequest request) {
        Group group = (Group)request.getGroups().get(0);
        ResourceUniqueId id = group.getResourceUniqueId();
        return new GetGroupsResponse(this.getGroupAttempts(id));
    }

    @Override
    protected UpdateGroupsResponse updateGroups(UpdateGroupsRequest request) {
        Group group = (Group)request.getGroups().get(0);
        ResourceUniqueId id = group.getResourceUniqueId();
        this.groups.put(id.getId(), group);
        return new UpdateGroupsResponse(this.getGroupAttempts(id));
    }

    @Override
    protected DeleteGroupsResponse deleteGroups(DeleteGroupsRequest request) {
        Group group = (Group)request.getGroups().get(0);
        String key = group.getResourceUniqueId().getId();
        DeleteGroupsResponse response = new DeleteGroupsResponse(this.getGroupAttempts(group.getResourceUniqueId()));
        this.groups.remove(key);
        return response;
    }

    private UserAttempts getUserAttempts(ResourceUniqueId ruid) {
        UserAttempt attempt = new UserAttempt();
        attempt.setUser(this.users.get(ruid.getId()));
        UserAttempts attempts = new UserAttempts();
        attempts.add(attempt);
        return attempts;
    }

    private GroupAttempts getGroupAttempts(ResourceUniqueId ruid) {
        GroupAttempt attempt = new GroupAttempt();
        attempt.setGroup(this.groups.get(ruid.getId()));
        GroupAttempts attempts = new GroupAttempts();
        attempts.add(attempt);
        return attempts;
    }
}

