/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.prov.saas.pingone.metadata;

import com.pingidentity.io.cpl.pingone.metadata.ConnectionAttribute;
import com.pingidentity.io.cpl.pingone.metadata.ConnectionAttributes;
import com.pingidentity.prov.saas.pingone.metadata.ConnectionFieldsBuilder;
import com.pingidentity.prov.saas.pingone.metadata.FieldDescriptorComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;

public class CPLv3ConnectionFieldsBuilder
implements ConnectionFieldsBuilder {
    private final Comparator<FieldDescriptor> comparator = new FieldDescriptorComparator();

    @Override
    public List<FieldDescriptor> build(ConnectionAttributes connectionAttributes) {
        ArrayList<FieldDescriptor> descriptors = new ArrayList<FieldDescriptor>();
        for (ConnectionAttribute attribute : connectionAttributes) {
            TextFieldDescriptor fieldDescriptor = null;
            String desc = attribute.getDescription();
            String key = attribute.getKey();
            boolean encryptFlag = false;
            if (attribute.isSensitive() != null) {
                encryptFlag = attribute.isSensitive();
            }
            boolean doEncrypt = encryptFlag;
            String[] values = attribute.getPossibleValues();
            if (values != null && values.length > 1) {
                fieldDescriptor = new SelectFieldDescriptor(key, desc, values);
            } else if (attribute.isTypeBoolean() != null && attribute.isTypeBoolean().booleanValue()) {
                fieldDescriptor = new CheckBoxFieldDescriptor(key, desc);
                fieldDescriptor.setDefaultValue(Boolean.TRUE.toString());
            } else {
                fieldDescriptor = new TextFieldDescriptor(key, desc, doEncrypt);
            }
            if (attribute.isRequired() != null && attribute.isRequired().booleanValue()) {
                fieldDescriptor.addValidator((FieldValidator)new RequiredFieldValidator());
            }
            if (fieldDescriptor == null) continue;
            descriptors.add((FieldDescriptor)fieldDescriptor);
        }
        Collections.sort(descriptors, this.comparator);
        return descriptors;
    }
}

