/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.prov.saas.pingone.request;

import com.pingidentity.io.cpl.pingone.metadata.Attributes;
import com.pingidentity.io.cpl.pingone.metadata.BaseAttribute;
import com.pingidentity.io.cpl.pingone.request.ConnectionFields;
import com.pingidentity.io.cpl.pingone.request.CreateUsersRequest;
import com.pingidentity.io.cpl.pingone.request.Request;
import com.pingidentity.io.cpl.pingone.resource.ResourceAttributes;
import com.pingidentity.io.cpl.pingone.resource.ResourceUniqueId;
import com.pingidentity.io.cpl.pingone.resource.User;
import com.pingidentity.prov.saas.pingone.request.RequestBuilder;
import com.pingidentity.prov.saas.pingone.request.RequestParameters;
import com.pingidentity.prov.saas.pingone.request.UserRequestBuilder;
import com.pingidentity.prov.saas.pingone.request.UserRequestParameters;
import com.pingidentity.provisioner.sdk.SaasUserData;

public class CreateUserRequestBuilder
extends UserRequestBuilder
implements RequestBuilder {
    protected final Attributes attributes;

    public CreateUserRequestBuilder(Attributes attributes, String activationAttributeName, boolean activeState) {
        super(activationAttributeName, activeState);
        this.attributes = attributes;
    }

    @Override
    public Request build(RequestParameters requestParameters) {
        Attributes createableAttributes = new Attributes();
        for (String userAttributeKey : this.attributes.keySet()) {
            BaseAttribute attribute = (BaseAttribute)this.attributes.get(userAttributeKey);
            boolean createable = attribute.isCreatable();
            boolean required = attribute.isRequiredOnCreate();
            if (!required && !createable) continue;
            createableAttributes.add(attribute);
        }
        UserRequestParameters parameters = (UserRequestParameters)requestParameters;
        SaasUserData saasUserData = parameters.getSaasUserData();
        ConnectionFields connectionFields = parameters.getConnectionFields();
        ResourceAttributes userAttributes = this.buildAttributes(saasUserData, createableAttributes);
        User user = new User(userAttributes, new ResourceUniqueId(saasUserData.getSaasUserGuid()));
        return new CreateUsersRequest(connectionFields, user);
    }
}

