/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.prov.saas.pingone.request;

import com.pingidentity.io.cpl.pingone.metadata.Attributes;
import com.pingidentity.io.cpl.pingone.metadata.BaseAttribute;
import com.pingidentity.io.cpl.pingone.request.ConnectionFields;
import com.pingidentity.io.cpl.pingone.request.Request;
import com.pingidentity.io.cpl.pingone.request.UpdateUsersRequest;
import com.pingidentity.io.cpl.pingone.resource.ResourceAttributes;
import com.pingidentity.io.cpl.pingone.resource.ResourceUniqueId;
import com.pingidentity.io.cpl.pingone.resource.User;
import com.pingidentity.prov.saas.pingone.request.RequestBuilder;
import com.pingidentity.prov.saas.pingone.request.RequestParameters;
import com.pingidentity.prov.saas.pingone.request.UserRequestBuilder;
import com.pingidentity.prov.saas.pingone.request.UserRequestParameters;
import com.pingidentity.provisioner.sdk.SaasUserData;

public class UpdateUserRequestBuilder
extends UserRequestBuilder
implements RequestBuilder {
    private final Attributes userAttributes;

    public UpdateUserRequestBuilder(Attributes userAttributes, String activationAttributeName, boolean activeState) {
        super(activationAttributeName, activeState);
        this.userAttributes = userAttributes;
    }

    @Override
    public Request build(RequestParameters requestParameters) {
        Attributes updateableAttributes = new Attributes();
        for (String userAttributeKey : this.userAttributes.keySet()) {
            BaseAttribute attribute = (BaseAttribute)this.userAttributes.get(userAttributeKey);
            boolean updateable = attribute.isUpdateable();
            boolean required = attribute.isRequiredOnUpdate();
            if (!required && !updateable) continue;
            updateableAttributes.add(attribute);
        }
        UserRequestParameters parameters = (UserRequestParameters)requestParameters;
        SaasUserData saasUserData = parameters.getSaasUserData();
        ConnectionFields connectionFields = parameters.getConnectionFields();
        ResourceAttributes userAttributes = this.buildAttributes(saasUserData, updateableAttributes);
        User user = new User(userAttributes, new ResourceUniqueId(saasUserData.getSaasUserGuid()));
        return new UpdateUsersRequest(connectionFields, user);
    }
}

