/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.pingone;

import com.pingidentity.io.cpl.pingone.Worker;
import com.pingidentity.io.cpl.pingone.exception.ResourceException;
import com.pingidentity.io.cpl.pingone.exception.ResourceNotFoundException;
import com.pingidentity.io.cpl.pingone.exception.ServiceAuthenticationException;
import com.pingidentity.io.cpl.pingone.exception.ServiceException;
import com.pingidentity.io.cpl.pingone.metadata.AttributeMetadata;
import com.pingidentity.io.cpl.pingone.metadata.Attributes;
import com.pingidentity.io.cpl.pingone.metadata.BaseAttribute;
import com.pingidentity.io.cpl.pingone.metadata.ConnectionProfiles;
import com.pingidentity.io.cpl.pingone.metadata.ProvisionerInformation;
import com.pingidentity.io.cpl.pingone.request.CheckConnectionRequest;
import com.pingidentity.io.cpl.pingone.request.ConnectionFields;
import com.pingidentity.io.cpl.pingone.request.CreateGroupsRequest;
import com.pingidentity.io.cpl.pingone.request.CreateMembershipsRequest;
import com.pingidentity.io.cpl.pingone.request.CreateUsersRequest;
import com.pingidentity.io.cpl.pingone.request.DeleteGroupsRequest;
import com.pingidentity.io.cpl.pingone.request.DeleteMembershipsRequest;
import com.pingidentity.io.cpl.pingone.request.DeleteUsersRequest;
import com.pingidentity.io.cpl.pingone.request.GetAllUsersRequest;
import com.pingidentity.io.cpl.pingone.request.GetAttributesRequest;
import com.pingidentity.io.cpl.pingone.request.GetConnectionProfilesRequest;
import com.pingidentity.io.cpl.pingone.request.GetGroupsRequest;
import com.pingidentity.io.cpl.pingone.request.GetInfoRequest;
import com.pingidentity.io.cpl.pingone.request.GetMembersOfGroupRequest;
import com.pingidentity.io.cpl.pingone.request.GetUsersRequest;
import com.pingidentity.io.cpl.pingone.request.PageFields;
import com.pingidentity.io.cpl.pingone.request.UpdateGroupsRequest;
import com.pingidentity.io.cpl.pingone.request.UpdateMembershipsRequest;
import com.pingidentity.io.cpl.pingone.request.UpdateUsersRequest;
import com.pingidentity.io.cpl.pingone.resource.Group;
import com.pingidentity.io.cpl.pingone.resource.Membership;
import com.pingidentity.io.cpl.pingone.resource.Memberships;
import com.pingidentity.io.cpl.pingone.resource.ResourceAttributes;
import com.pingidentity.io.cpl.pingone.resource.ResourceUniqueId;
import com.pingidentity.io.cpl.pingone.resource.User;
import com.pingidentity.io.cpl.pingone.resource.Users;
import com.pingidentity.io.cpl.pingone.response.CheckConnectionResponse;
import com.pingidentity.io.cpl.pingone.response.CreateGroupsResponse;
import com.pingidentity.io.cpl.pingone.response.CreateMembershipsResponse;
import com.pingidentity.io.cpl.pingone.response.CreateUsersResponse;
import com.pingidentity.io.cpl.pingone.response.DeleteGroupsResponse;
import com.pingidentity.io.cpl.pingone.response.DeleteMembershipsResponse;
import com.pingidentity.io.cpl.pingone.response.DeleteUsersResponse;
import com.pingidentity.io.cpl.pingone.response.GetAllUsersResponse;
import com.pingidentity.io.cpl.pingone.response.GetAttributesResponse;
import com.pingidentity.io.cpl.pingone.response.GetConnectionProfilesResponse;
import com.pingidentity.io.cpl.pingone.response.GetGroupsResponse;
import com.pingidentity.io.cpl.pingone.response.GetInfoResponse;
import com.pingidentity.io.cpl.pingone.response.GetMembersOfGroupResponse;
import com.pingidentity.io.cpl.pingone.response.GetUsersResponse;
import com.pingidentity.io.cpl.pingone.response.GroupAttempt;
import com.pingidentity.io.cpl.pingone.response.MembershipAttempt;
import com.pingidentity.io.cpl.pingone.response.UpdateGroupsResponse;
import com.pingidentity.io.cpl.pingone.response.UpdateMembershipsResponse;
import com.pingidentity.io.cpl.pingone.response.UpdateUsersResponse;
import com.pingidentity.io.cpl.pingone.response.UserAttempt;
import com.pingidentity.provisioner.integrations.pingone.ComplexUserAttribute;
import com.pingidentity.provisioner.integrations.pingone.ConnectionFieldKey;
import com.pingidentity.provisioner.integrations.pingone.PingOneLogEvents;
import com.pingidentity.provisioner.integrations.pingone.PingOneWorkerFactory;
import com.pingidentity.provisioner.integrations.pingone.Region;
import com.pingidentity.provisioner.integrations.pingone.ResourceFieldKey;
import com.pingidentity.provisioner.integrations.pingone.metadata.AttributeMetadataBuilder;
import com.pingidentity.provisioner.integrations.pingone.metadata.PingOneAttributeMetadataBuilder;
import com.pingidentity.provisioner.integrations.pingone.metadata.PingOneProvisionerInformationBuilder;
import com.pingidentity.provisioner.integrations.pingone.metadata.ProvisionerInformationBuilder;
import com.pingidentity.provisioner.integrations.pingone.metadata.attribute.ConnectionProfilesBuilder;
import com.pingidentity.provisioner.integrations.pingone.metadata.attribute.PingOneConnectionProfileBuilder;
import com.pingidentity.provisioner.integrations.pingone.metadata.attribute.PingOneGroupAttributeBuilder;
import com.pingidentity.provisioner.integrations.pingone.metadata.attribute.PingOneMembershipAttributeBuilder;
import com.pingidentity.provisioner.integrations.pingone.metadata.attribute.PingOneSchemaAttributeConverter;
import com.pingidentity.provisioner.integrations.pingone.metadata.attribute.PingOneUserAttributeBuilder;
import com.pingidentity.provisioner.integrations.pingone.metadata.capability.PingOneCapabilityBuilder;
import com.pingidentity.provisioner.integrations.pingone.metadata.enhancement.PingOneEnhancementBuilder;
import com.pingidentity.provisioner.integrations.pingone.saas.SaasGroup;
import com.pingidentity.provisioner.integrations.pingone.saas.SaasMembership;
import com.pingidentity.provisioner.integrations.pingone.saas.SaasUser;
import com.pingidentity.provisioner.integrations.pingone.saas.SaasUserGroupApi;
import com.pingidentity.provisioner.integrations.pingone.saas.request_builder.PingOneEndpoint;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.CrudException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.device.crud.exception.LimitExceededException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.idp.IdpAttribute;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.oauth.OAuthClient;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.oauth.OAuthException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.oauth.PingOneOAuthClient;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.population.PopulationAttribute;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.Schema;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.SchemaAttribute;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.SchemaAttributeProperty;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.SchemaProperty;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.crud.dto.response.SchemaType;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.integrations.logger.LogEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class PingOneWorker
extends Worker {
    private static final IntegrationsLogger logger = new IntegrationsLogger(PingOneWorker.class);
    private final ProvisionerInformationBuilder provisionerInformationBuilder;
    private final ConnectionProfilesBuilder connectionProfilesBuilder;
    private final AttributeMetadataBuilder attributeMetadataBuilder;
    private final SaasUserGroupApi saasWrapper;
    private final OAuthClient oauthClient;

    public PingOneWorker() {
        this(new PingOneProvisionerInformationBuilder(), new PingOneConnectionProfileBuilder(), new PingOneAttributeMetadataBuilder(new PingOneCapabilityBuilder(), new PingOneEnhancementBuilder(), new PingOneUserAttributeBuilder(), new PingOneGroupAttributeBuilder(), new PingOneMembershipAttributeBuilder()), new PingOneWorkerFactory().make(), new PingOneOAuthClient());
    }

    public PingOneWorker(ProvisionerInformationBuilder provisionerInformationBuilder, ConnectionProfilesBuilder connectionProfilesBuilder, AttributeMetadataBuilder attributeMetadataBuilder, SaasUserGroupApi saasWrapper, OAuthClient oauthClient) {
        this.provisionerInformationBuilder = provisionerInformationBuilder;
        this.connectionProfilesBuilder = connectionProfilesBuilder;
        this.attributeMetadataBuilder = attributeMetadataBuilder;
        this.saasWrapper = saasWrapper;
        this.oauthClient = oauthClient;
    }

    @Override
    public GetInfoResponse getInfo(GetInfoRequest request) {
        logger.log(PingOneLogEvents.GET_INFO);
        ProvisionerInformation information = this.provisionerInformationBuilder.build();
        GetInfoResponse response = new GetInfoResponse();
        response.setInformation(information);
        return response;
    }

    @Override
    public GetConnectionProfilesResponse getConnectionProfiles(GetConnectionProfilesRequest request) {
        logger.log(PingOneLogEvents.GET_CONN_PROFILES);
        ConnectionProfiles connectionProfiles = this.connectionProfilesBuilder.build();
        GetConnectionProfilesResponse response = new GetConnectionProfilesResponse();
        response.setConnectionProfiles(connectionProfiles);
        return response;
    }

    @Override
    public GetAttributesResponse getAttributes(GetAttributesRequest request) {
        logger.log(PingOneLogEvents.GET_ATTRIBUTES);
        AttributeMetadata attributeMetadata = this.attributeMetadataBuilder.build();
        GetAttributesResponse response = new GetAttributesResponse();
        ConnectionFields connectionFields = request.getConnectionFields();
        if (connectionFields != null && connectionFields.size() > 0) {
            List<Object> idps = new ArrayList();
            List<Object> pops = new ArrayList();
            try {
                connectionFields = this.convergeLegacyConnectionFields(connectionFields);
                idps = this.saasWrapper.getIdps(connectionFields);
                pops = this.saasWrapper.getPopulations(connectionFields);
                List<SchemaAttribute> userSchemaAttributes = this.getUserSchemaAttributes(connectionFields);
                Attributes customAttributes = this.getCustomAttributes(userSchemaAttributes);
                for (Map.Entry entry : customAttributes.entrySet()) {
                    attributeMetadata.getUserAttributes().add((BaseAttribute)entry.getValue());
                }
                if (connectionFields.containsKey(ConnectionFieldKey.FILTER_DISABLED_USER_ATTRIBUTES.getKey()) && ((String)connectionFields.get(ConnectionFieldKey.FILTER_DISABLED_USER_ATTRIBUTES.getKey())).equalsIgnoreCase(Boolean.TRUE.toString())) {
                    Set<String> disabledAttributesNames = this.getAllDisabledAttributesNames(userSchemaAttributes, attributeMetadata.getUserAttributes().keySet());
                    for (String disabledAttributeName : disabledAttributesNames) {
                        attributeMetadata.getUserAttributes().remove(disabledAttributeName);
                    }
                }
            }
            catch (CrudException e) {
                logger.log((LogEvent)PingOneLogEvents.DYNAMIC_METADATA_ERROR, e);
                response.addServiceException(new ServiceException(e.getMessage()));
            }
            catch (ServiceException e) {
                response.addServiceException(e);
            }
            String separator = "||";
            String pingOneLabel = "PingOne";
            BaseAttribute authIdp = (BaseAttribute)attributeMetadata.getUserAttributes().get(ResourceFieldKey.AUTHORITATIVE_IDP.getLabel());
            List<String> list = idps.stream().map(idp -> idp.getId() + "||" + idp.getOne(IdpAttribute.NAME)).collect(Collectors.toList());
            list.add("||PingOne");
            String[] idpArr = new String[list.size()];
            authIdp.setPicklistValues(list.toArray(idpArr));
            BaseAttribute populationsAttr = (BaseAttribute)attributeMetadata.getUserAttributes().get(ResourceFieldKey.POPULATION_ID.getLabel());
            List<String> popList = pops.stream().map(pop -> pop.getId() + "||" + pop.getOne(PopulationAttribute.NAME)).collect(Collectors.toList());
            String[] popArr = new String[popList.size()];
            populationsAttr.setPicklistValues(popList.toArray(popArr));
        }
        response.setAttributeMetadata(attributeMetadata);
        return response;
    }

    @Override
    public CheckConnectionResponse checkConnection(CheckConnectionRequest request) {
        logger.log(PingOneLogEvents.CHECK_CONNECTION);
        CheckConnectionResponse response = new CheckConnectionResponse();
        try {
            ConnectionFields connectionFields = this.convergeLegacyConnectionFields(request.getConnectionFields());
            this.saasWrapper.checkConnection(connectionFields);
        }
        catch (ServiceException e) {
            response.addServiceException(e);
        }
        return response;
    }

    @Override
    public GetUsersResponse getUsers(GetUsersRequest request) {
        ConnectionFields connectionFields;
        logger.log(PingOneLogEvents.USER_GET);
        GetUsersResponse response = new GetUsersResponse();
        try {
            connectionFields = this.convergeLegacyConnectionFields(request.getConnectionFields());
        }
        catch (ServiceException e) {
            response.addServiceException(e);
            return response;
        }
        User requestUser = (User)request.getUsers().get(0);
        ResourceUniqueId resourceUniqueId = requestUser.getResourceUniqueId();
        String secondaryGetAttribute = null;
        ResourceAttributes attributes = requestUser.getResourceAttributes();
        if (attributes != null && attributes.containsKey(ResourceFieldKey.getSecondaryId().getLabel())) {
            secondaryGetAttribute = attributes.getValueOf(ResourceFieldKey.getSecondaryId().getLabel());
        }
        SaasUser user = null;
        String id = null;
        UserAttempt userAttempt = new UserAttempt();
        response.addUserAttempt(userAttempt);
        if (resourceUniqueId != null) {
            id = resourceUniqueId.getId();
        }
        try {
            boolean attemptSecondaryGet = false;
            if (id != null && !id.isEmpty()) {
                try {
                    user = this.saasWrapper.getUserBySaasGuid(connectionFields, requestUser);
                }
                catch (ResourceNotFoundException e) {
                    if (secondaryGetAttribute == null || secondaryGetAttribute.isEmpty()) {
                        return this.add404UserToResponse(resourceUniqueId, response);
                    }
                    attemptSecondaryGet = true;
                }
            } else {
                attemptSecondaryGet = true;
            }
            if (attemptSecondaryGet) {
                try {
                    user = this.saasWrapper.getUserBySecondaryId(connectionFields, requestUser);
                }
                catch (ResourceNotFoundException e) {
                    if (resourceUniqueId != null) {
                        response = this.add404UserToResponse(resourceUniqueId, response);
                    } else {
                        userAttempt.addResourceException(e);
                    }
                    return response;
                }
            }
            if (user != null) {
                userAttempt.setUser(user.getCplUser());
            }
        }
        catch (ServiceException e) {
            response.addServiceException(e);
            return response;
        }
        catch (ResourceException e) {
            userAttempt.addResourceException(e);
        }
        return response;
    }

    @Override
    public GetAllUsersResponse getAllUsers(GetAllUsersRequest request) {
        logger.log(PingOneLogEvents.USERS_GET);
        PageFields pageFields = request.getPageFields();
        Users users = new Users();
        GetAllUsersResponse response = null;
        try {
            ConnectionFields connectionFields = this.convergeLegacyConnectionFields(request.getConnectionFields());
            users = this.saasWrapper.getAllUsers(connectionFields, pageFields);
            response = new GetAllUsersResponse(users, pageFields);
        }
        catch (ServiceException e) {
            response = new GetAllUsersResponse();
            response.addServiceException(e);
        }
        return response;
    }

    @Override
    public CreateUsersResponse createUsers(CreateUsersRequest request) {
        logger.log(PingOneLogEvents.USER_CREATE);
        User requestUser = (User)request.getUsers().get(0);
        CreateUsersResponse response = new CreateUsersResponse();
        UserAttempt userAttempt = new UserAttempt();
        response.addUserAttempt(userAttempt);
        SaasUser user = null;
        try {
            ConnectionFields connectionFields = this.convergeLegacyConnectionFields(request.getConnectionFields());
            Attributes customAttributes = this.getCustomAttributes(connectionFields);
            user = this.saasWrapper.createUser(connectionFields, requestUser, customAttributes);
            userAttempt.setUser(user.getCplUser());
            this.saasWrapper.createUserMfaDevices(connectionFields, requestUser.getResourceAttributes(), userAttempt.getUser().getResourceUniqueId());
        }
        catch (ServiceException e) {
            response.addServiceException(e);
            return response;
        }
        catch (ResourceException e) {
            userAttempt.addResourceException(e);
        }
        catch (LimitExceededException e) {
            logger.log(PingOneLogEvents.DEVICE_LIMIT_EXCEEDED);
        }
        catch (CrudException e) {
            userAttempt.addResourceException(new ResourceException(requestUser, e.getMessage()));
        }
        return response;
    }

    @Override
    public UpdateUsersResponse updateUsers(UpdateUsersRequest request) {
        logger.log(PingOneLogEvents.USER_UPDATE);
        User user = (User)request.getUsers().get(0);
        UpdateUsersResponse response = new UpdateUsersResponse();
        UserAttempt userAttempt = new UserAttempt();
        response.addUserAttempt(userAttempt);
        SaasUser saasUser = null;
        try {
            ConnectionFields connectionFields = this.convergeLegacyConnectionFields(request.getConnectionFields());
            Attributes customAttributes = this.getCustomAttributes(connectionFields);
            saasUser = this.saasWrapper.updateUser(connectionFields, user, customAttributes);
            userAttempt.setUser(saasUser.getCplUser());
            this.saasWrapper.updateUserMfaDevices(connectionFields, user);
        }
        catch (ServiceException e) {
            response.addServiceException(e);
            return response;
        }
        catch (ResourceException e) {
            userAttempt.addResourceException(e);
        }
        catch (LimitExceededException e) {
            logger.log(PingOneLogEvents.DEVICE_LIMIT_EXCEEDED);
        }
        catch (CrudException e) {
            userAttempt.addResourceException(new ResourceException(user, e.getMessage()));
        }
        return response;
    }

    @Override
    public DeleteUsersResponse deleteUsers(DeleteUsersRequest request) {
        logger.log(PingOneLogEvents.USER_DELETE);
        User user = (User)request.getUsers().get(0);
        DeleteUsersResponse response = new DeleteUsersResponse();
        UserAttempt userAttempt = new UserAttempt();
        response.addUserAttempt(userAttempt);
        try {
            ConnectionFields connectionFields = this.convergeLegacyConnectionFields(request.getConnectionFields());
            this.saasWrapper.deleteUser(connectionFields, user);
        }
        catch (ServiceException e) {
            response.addServiceException(e);
            return response;
        }
        catch (ResourceException e) {
            userAttempt.addResourceException(e);
        }
        return response;
    }

    @Override
    public GetGroupsResponse getGroups(GetGroupsRequest request) {
        logger.log(PingOneLogEvents.GROUP_GET);
        Group requestGroup = (Group)request.getGroups().get(0);
        ResourceUniqueId resourceUniqueId = requestGroup.getResourceUniqueId();
        String secondaryGetAttribute = null;
        ResourceAttributes attributes = requestGroup.getResourceAttributes();
        if (attributes != null && attributes.containsKey(ResourceFieldKey.GROUP_NAME.getLabel())) {
            secondaryGetAttribute = attributes.getValueOf(ResourceFieldKey.GROUP_NAME.getLabel());
        }
        GetGroupsResponse response = new GetGroupsResponse();
        GroupAttempt groupAttempt = new GroupAttempt();
        response.addGroupAttempt(groupAttempt);
        String id = null;
        if (resourceUniqueId != null) {
            id = resourceUniqueId.getId();
        }
        try {
            boolean attemptSecondaryGet = false;
            ConnectionFields connectionFields = this.convergeLegacyConnectionFields(request.getConnectionFields());
            SaasGroup group = null;
            if (id != null && !id.isEmpty()) {
                try {
                    group = this.saasWrapper.getGroupBySaasGuid(connectionFields, requestGroup);
                }
                catch (ResourceNotFoundException e) {
                    if (secondaryGetAttribute == null || secondaryGetAttribute.isEmpty()) {
                        return this.add404GroupToResponse(resourceUniqueId, response, null);
                    }
                    attemptSecondaryGet = true;
                }
            } else {
                attemptSecondaryGet = true;
            }
            if (attemptSecondaryGet) {
                try {
                    group = this.saasWrapper.getGroupBySecondaryId(connectionFields, requestGroup);
                }
                catch (ResourceNotFoundException e) {
                    if (resourceUniqueId != null) {
                        response = this.add404GroupToResponse(resourceUniqueId, response, secondaryGetAttribute);
                    } else {
                        groupAttempt.addResourceException(e);
                    }
                    return response;
                }
            }
            if (group != null) {
                groupAttempt.setGroup(group.getCplGroup());
            }
        }
        catch (ServiceException e) {
            response.addServiceException(e);
        }
        catch (ResourceException e) {
            groupAttempt.addResourceException(e);
        }
        return response;
    }

    @Override
    public CreateGroupsResponse createGroups(CreateGroupsRequest request) {
        logger.log(PingOneLogEvents.GROUP_CREATE);
        Group requestGroup = (Group)request.getGroups().get(0);
        CreateGroupsResponse response = new CreateGroupsResponse();
        GroupAttempt groupAttempt = new GroupAttempt();
        response.addGroupAttempt(groupAttempt);
        try {
            ConnectionFields connectionFields = this.convergeLegacyConnectionFields(request.getConnectionFields());
            SaasGroup group = this.saasWrapper.createGroup(connectionFields, requestGroup);
            groupAttempt.setGroup(group.getCplGroup());
        }
        catch (ServiceException e) {
            response.addServiceException(e);
        }
        catch (ResourceException e) {
            groupAttempt.addResourceException(e);
        }
        return response;
    }

    @Override
    public UpdateGroupsResponse updateGroups(UpdateGroupsRequest request) {
        logger.log(PingOneLogEvents.GROUP_UPDATE);
        Group group = (Group)request.getGroups().get(0);
        UpdateGroupsResponse response = new UpdateGroupsResponse();
        GroupAttempt groupAttempt = new GroupAttempt();
        response.addGroupAttempt(groupAttempt);
        try {
            ConnectionFields connectionFields = this.convergeLegacyConnectionFields(request.getConnectionFields());
            SaasGroup saasGroup = this.saasWrapper.updateGroup(connectionFields, group);
            groupAttempt.setGroup(saasGroup.getCplGroup());
        }
        catch (ServiceException e) {
            response.addServiceException(e);
        }
        catch (ResourceException e) {
            groupAttempt.addResourceException(e);
        }
        return response;
    }

    @Override
    public DeleteGroupsResponse deleteGroups(DeleteGroupsRequest request) {
        logger.log(PingOneLogEvents.GROUP_DELETE);
        Group group = (Group)request.getGroups().get(0);
        DeleteGroupsResponse response = new DeleteGroupsResponse();
        GroupAttempt groupAttempt = new GroupAttempt();
        response.addGroupAttempt(groupAttempt);
        try {
            ConnectionFields connectionFields = this.convergeLegacyConnectionFields(request.getConnectionFields());
            this.saasWrapper.deleteGroup(connectionFields, group);
        }
        catch (ServiceException e) {
            response.addServiceException(e);
        }
        catch (ResourceException e) {
            groupAttempt.addResourceException(e);
        }
        return response;
    }

    @Override
    public GetMembersOfGroupResponse getMembersOfGroup(GetMembersOfGroupRequest request) {
        GetMembersOfGroupResponse response;
        logger.log(PingOneLogEvents.GROUP_MEMBERS_GET);
        Group group = request.getGroup();
        PageFields pageFields = request.getPageFields();
        try {
            ConnectionFields connectionFields = this.convergeLegacyConnectionFields(request.getConnectionFields());
            Memberships memberships = this.saasWrapper.getAllMembersOfGroup(connectionFields, group, pageFields);
            response = new GetMembersOfGroupResponse(memberships, group, pageFields);
        }
        catch (ServiceException e) {
            response = new GetMembersOfGroupResponse();
            response.addServiceException(e);
        }
        catch (ResourceException e) {
            response = new GetMembersOfGroupResponse();
            response.addServiceException(new ServiceException(e.getFormattedMessage()));
        }
        return response;
    }

    @Override
    public CreateMembershipsResponse createMemberships(CreateMembershipsRequest request) {
        logger.log(PingOneLogEvents.GROUP_MEMBER_CREATE);
        Membership requestMembership = (Membership)request.getMemberships().get(0);
        CreateMembershipsResponse response = new CreateMembershipsResponse();
        MembershipAttempt membershipAttempt = new MembershipAttempt();
        response.addMembershipAttempt(membershipAttempt);
        try {
            ConnectionFields connectionFields = this.convergeLegacyConnectionFields(request.getConnectionFields());
            SaasMembership membership = this.saasWrapper.createMembership(connectionFields, requestMembership);
            membershipAttempt.setMembership(membership.getCplMembership());
        }
        catch (ServiceException e) {
            response.addServiceException(e);
        }
        catch (ResourceException e) {
            membershipAttempt.addResourceException(e);
        }
        return response;
    }

    @Override
    public UpdateMembershipsResponse updateMemberships(UpdateMembershipsRequest request) {
        logger.log(PingOneLogEvents.GROUP_MEMBER_UPDATE);
        return super.updateMemberships(request);
    }

    @Override
    public DeleteMembershipsResponse deleteMemberships(DeleteMembershipsRequest request) {
        logger.log(PingOneLogEvents.GROUP_MEMBER_DELETE);
        Membership membership = (Membership)request.getMemberships().get(0);
        DeleteMembershipsResponse response = new DeleteMembershipsResponse();
        MembershipAttempt membershipAttempt = new MembershipAttempt();
        response.addMembershipAttempt(membershipAttempt);
        try {
            ConnectionFields connectionFields = this.convergeLegacyConnectionFields(request.getConnectionFields());
            this.saasWrapper.deleteMembership(connectionFields, membership);
        }
        catch (ServiceException e) {
            response.addServiceException(e);
        }
        catch (ResourceException e) {
            membershipAttempt.addResourceException(e);
        }
        return response;
    }

    private GetUsersResponse add404UserToResponse(ResourceUniqueId resourceUniqueId, GetUsersResponse response) {
        ResourceNotFoundException ex = new ResourceNotFoundException(new User(resourceUniqueId), String.format("%s User Not Found", PingOneLogEvents.ERR_RESOURCE_NOT_FOUND.getCode()));
        ((UserAttempt)response.getUserAttempts().get(0)).addResourceException(ex);
        return response;
    }

    private GetGroupsResponse add404GroupToResponse(ResourceUniqueId resourceUniqueId, GetGroupsResponse response, String secondaryId) {
        ResourceNotFoundException ex = new ResourceNotFoundException(new Group(resourceUniqueId), String.format("%s Group Not Found", PingOneLogEvents.ERR_RESOURCE_NOT_FOUND.getCode()), secondaryId);
        ((GroupAttempt)response.getGroupAttempts().get(0)).addResourceException(ex);
        return response;
    }

    private String getAccessToken(ConnectionFields cf) throws OAuthException, ServiceAuthenticationException {
        String at = (String)cf.get(ConnectionFieldKey.ACCESS_TOKEN.getKey());
        if (at != null && !at.isEmpty()) {
            return at;
        }
        String clientId = (String)cf.get(ConnectionFieldKey.CLIENT_ID.getKey());
        String clientSecret = (String)cf.get(ConnectionFieldKey.CLIENT_SECRET.getKey());
        String environmentId = (String)cf.get(ConnectionFieldKey.ENV_ID.getKey());
        String oauthUrl = (String)cf.get(ConnectionFieldKey.AUTH_URL.getKey());
        logger.log((LogEvent)PingOneLogEvents.GET_ACCESS_TOKEN, oauthUrl, environmentId);
        return this.oauthClient.getAccessToken(clientId, clientSecret, oauthUrl);
    }

    private String getAuthUrl(ConnectionFields cf) throws ServiceAuthenticationException {
        String authUrl = (String)cf.get(ConnectionFieldKey.P1_AUTH_URL.getKey());
        if (!this.isBlank(authUrl)) {
            return authUrl;
        }
        String envId = this.getEnvironmentId(cf);
        String uiAuthValue = (String)cf.get(ConnectionFieldKey.AUTH_URL.getKey());
        if (!this.isBlank(uiAuthValue)) {
            return this.appendAuthEndpoint(uiAuthValue, envId);
        }
        String uiRegionValue = (String)cf.get(ConnectionFieldKey.REGION.getKey());
        if (!this.isBlank(uiRegionValue)) {
            return this.appendAuthEndpoint(this.getRegion(uiRegionValue).getAuthUrl(), envId);
        }
        String uiLegacyValue = (String)cf.get(ConnectionFieldKey.OAUTH_URL.getKey());
        if (!this.isBlank(uiLegacyValue)) {
            return this.appendAuthEndpoint(uiLegacyValue, envId);
        }
        return this.appendAuthEndpoint(Region.NA.getAuthUrl(), envId);
    }

    private boolean isBlank(String s) {
        return s == null || s.isEmpty();
    }

    private String appendAuthEndpoint(String authBaseUrl, String envId) {
        String authEndpoint = String.format(PingOneEndpoint.OAUTH_PATH.getEndpoint(), envId);
        return authBaseUrl != null ? authBaseUrl + authEndpoint : null;
    }

    private String getMgmtHost(ConnectionFields cf) {
        String uiMgmtValue = (String)cf.get(ConnectionFieldKey.MGMT_URL.getKey());
        if (!this.isBlank(uiMgmtValue)) {
            return this.appendApiVersion(uiMgmtValue);
        }
        String uiRegionValue = (String)cf.get(ConnectionFieldKey.REGION.getKey());
        if (!this.isBlank(uiRegionValue)) {
            return this.getRegion(uiRegionValue).getApiUrl();
        }
        String uiLegacyValue = (String)cf.get(ConnectionFieldKey.P14C_URL.getKey());
        if (!this.isBlank(uiLegacyValue)) {
            return this.appendApiVersion(uiLegacyValue);
        }
        return Region.NA.getApiUrl();
    }

    private String appendApiVersion(String apiBaseUrl) {
        String versionPath = PingOneEndpoint.VERSION_PATH.getEndpoint();
        return apiBaseUrl != null && !apiBaseUrl.endsWith(versionPath) ? apiBaseUrl + versionPath : apiBaseUrl;
    }

    private String getEnvironmentId(ConnectionFields cf) throws ServiceAuthenticationException {
        String envValue = (String)cf.get(ConnectionFieldKey.ENV_ID.getKey());
        if (!this.isBlank(envValue)) {
            return envValue;
        }
        String legacyValue = (String)cf.get(ConnectionFieldKey.ENVIRONMENT_ID.getKey());
        if (!this.isBlank(legacyValue)) {
            return legacyValue;
        }
        throw new ServiceAuthenticationException("No Environment ID was specified.");
    }

    private Region getRegion(String name) {
        return Optional.ofNullable(Region.valueOfName(name)).orElse(Region.NA);
    }

    private ConnectionFields convergeLegacyConnectionFields(ConnectionFields cf) throws ServiceException {
        ConnectionFields newCf = new ConnectionFields();
        cf.forEach((k, v) -> newCf.put(k, v));
        newCf.put(ConnectionFieldKey.AUTH_URL.getKey(), this.getAuthUrl(cf));
        newCf.put(ConnectionFieldKey.MGMT_URL.getKey(), this.getMgmtHost(cf));
        newCf.put(ConnectionFieldKey.ENV_ID.getKey(), this.getEnvironmentId(cf));
        try {
            newCf.put(ConnectionFieldKey.ACCESS_TOKEN.getKey(), this.getAccessToken(newCf));
        }
        catch (OAuthException e) {
            throw new ServiceException(e.getMessage());
        }
        return newCf;
    }

    private List<SchemaAttribute> getUserSchemaAttributes(ConnectionFields connectionFields) throws CrudException, ServiceException {
        List<Schema> schemas = this.saasWrapper.getSchemas(connectionFields);
        Schema userSchema = schemas.stream().filter(s -> "User".equals(s.getOne(SchemaProperty.NAME))).findFirst().orElseThrow(() -> {
            logger.log((LogEvent)PingOneLogEvents.MISSING_SCHEMA_ERROR, "User");
            return new ServiceException(String.format("Couldn't get custom attributes from the PingOne '%s' schema", "User"));
        });
        return this.saasWrapper.getSchemaAttributes(connectionFields, userSchema);
    }

    private Attributes getCustomAttributes(ConnectionFields connectionFields) throws CrudException, ServiceException {
        List<SchemaAttribute> schemaAttributes = this.getUserSchemaAttributes(connectionFields);
        return this.getCustomAttributes(schemaAttributes);
    }

    private Attributes getCustomAttributes(List<SchemaAttribute> schemaAttributes) throws CrudException, ServiceException {
        return PingOneSchemaAttributeConverter.convert(new ArrayList<SchemaAttribute>(schemaAttributes), SchemaType.CUSTOM);
    }

    private Set<String> getAllDisabledAttributesNames(List<SchemaAttribute> userSchemaAttributes, Set<String> currentUserAttributeNames) throws CrudException, ServiceException {
        Map<String, String> caseInsensitiveAttributeNames = currentUserAttributeNames.stream().filter(Objects::nonNull).collect(Collectors.toMap(String::toLowerCase, k -> k));
        HashSet<String> disabledAttributesNames = new HashSet<String>();
        for (SchemaAttribute a : userSchemaAttributes) {
            if (!a.getAttributes().containsKey((Object)SchemaAttributeProperty.NAME) || a.getAttributes().get((Object)SchemaAttributeProperty.NAME) == null || a.getAttributes().get((Object)SchemaAttributeProperty.NAME).size() != 1 || !a.getAttributes().containsKey((Object)SchemaAttributeProperty.SCHEMA_TYPE) || a.getAttributes().get((Object)SchemaAttributeProperty.SCHEMA_TYPE) == null || a.getAttributes().get((Object)SchemaAttributeProperty.SCHEMA_TYPE).size() != 1) continue;
            String schemaType = a.getOne(SchemaAttributeProperty.SCHEMA_TYPE);
            if (!SchemaType.STANDARD.name().equalsIgnoreCase(schemaType) && !SchemaType.CUSTOM.name().equalsIgnoreCase(schemaType) || a.isAttributeEnabled().orElse(true).booleanValue()) continue;
            disabledAttributesNames.addAll(this.getSchemaAttributeOrSubAttributeNames(caseInsensitiveAttributeNames, a));
        }
        return disabledAttributesNames;
    }

    private Set<String> getSchemaAttributeOrSubAttributeNames(Map<String, String> caseInsensitiveAttributeNames, SchemaAttribute schemaAttribute) {
        Optional<ComplexUserAttribute> complexAttr;
        List<String> subAttributes;
        HashSet<String> attributeNames = new HashSet<String>();
        String attributeNameLowerCase = schemaAttribute.getOne(SchemaAttributeProperty.NAME).toLowerCase();
        if (caseInsensitiveAttributeNames.containsKey(attributeNameLowerCase)) {
            attributeNames.add(caseInsensitiveAttributeNames.get(attributeNameLowerCase));
        }
        if ((subAttributes = schemaAttribute.getAttributes().get((Object)SchemaAttributeProperty.SUB_ATTRIBUTES)) != null && !subAttributes.isEmpty()) {
            for (String subAttributeName : subAttributes) {
                if (!caseInsensitiveAttributeNames.containsKey(subAttributeName.toLowerCase())) continue;
                attributeNames.add(caseInsensitiveAttributeNames.get(subAttributeName.toLowerCase()));
            }
        }
        if ((complexAttr = ComplexUserAttribute.of(attributeNameLowerCase)).isPresent()) {
            for (String subAttributeName : complexAttr.get().getSubAttributes()) {
                if (!caseInsensitiveAttributeNames.containsKey(subAttributeName.toLowerCase())) continue;
                attributeNames.add(caseInsensitiveAttributeNames.get(subAttributeName.toLowerCase()));
            }
        }
        return attributeNames;
    }
}

