/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.pingone.metadata.attribute;

import com.pingidentity.io.cpl.pingone.metadata.Attributes;
import com.pingidentity.io.cpl.pingone.metadata.StringAttribute;
import com.pingidentity.provisioner.integrations.pingone.PingOneLogEvents;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.SchemaAttribute;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.SchemaAttributeProperty;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.crud.dto.response.AttributeType;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.crud.dto.response.SchemaType;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.integrations.logger.LogEvent;
import java.util.Arrays;
import java.util.List;

public class PingOneSchemaAttributeConverter {
    private static final IntegrationsLogger logger = new IntegrationsLogger(PingOneSchemaAttributeConverter.class);

    public static Attributes convert(List<SchemaAttribute> srcAttributes, SchemaType ... schemaTypes) {
        if (null == srcAttributes) {
            return null;
        }
        List<SchemaType> targetSchemaTypes = schemaTypes.length > 0 ? Arrays.asList(schemaTypes) : Arrays.asList(SchemaType.values());
        Attributes destAttributes = new Attributes();
        srcAttributes.stream().filter(a -> targetSchemaTypes.contains((Object)SchemaType.valueOf(a.getOne(SchemaAttributeProperty.SCHEMA_TYPE)))).forEach(a -> {
            AttributeType type = null;
            try {
                type = AttributeType.valueOf(a.getOne(SchemaAttributeProperty.TYPE));
            }
            catch (IllegalArgumentException e) {
                logger.log((LogEvent)PingOneLogEvents.UNKNOWN_ATTRIBUTE_TYPE, a.getOne(SchemaAttributeProperty.TYPE));
                return;
            }
            switch (type) {
                case STRING: {
                    StringAttribute b = new StringAttribute(a.getOne(SchemaAttributeProperty.NAME));
                    b.setCaseSensitive(false);
                    b.setMaxLength(256);
                    b.setMinLength(1);
                    b.setCreatable(true);
                    b.setUpdateable(true);
                    b.setNillable(true);
                    b.setUnique(Boolean.valueOf(a.getOne(SchemaAttributeProperty.UNIQUE)));
                    b.setDisplayName(a.getOne(SchemaAttributeProperty.DISPLAY_NAME));
                    b.setRequiredOnCreate(Boolean.valueOf(a.getOne(SchemaAttributeProperty.REQUIRED)));
                    b.setRequiredOnUpdate(false);
                    b.setMaxNumberOfValues(Boolean.valueOf(a.getOne(SchemaAttributeProperty.MULTIVALUED)) != false ? 1000 : 1);
                    b.setMinNumberOfValues(0);
                    b.setDerived(true);
                    destAttributes.add(b);
                    break;
                }
            }
        });
        return destAttributes;
    }
}

