/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.pingone.pf;

import com.pingidentity.provisioner.integrations.pingone.pf.DisabledAppException;
import com.pingidentity.provisioner.integrations.pingone.pf.ReflectionException;
import java.beans.Expression;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class ReflectedPingOneEnvironmentAccessor {
    private static final String ACCESSOR_CLASS_NAME = "com.pingidentity.access.PingOneEnvironmentAccessor";
    private static final String MGMT_ENDPOINT_GETTER_METHOD_NAME = "getManagementEndpoint";
    private static final String AUTH_ENDPOINT_GETTER_METHOD_NAME = "getAuthenticationEndpoint";
    private static final String ENV_ID_GETTER_METHOD_NAME = "getEnvironmentId";
    private static final String ACCESS_TOKEN_GETTER_METHOD_NAME = "getAccessToken";
    private final Object reflectedPingOneAccessor;

    public ReflectedPingOneEnvironmentAccessor(String connEnvFieldValue) throws ReflectionException {
        try {
            Class<?> clazz = Class.forName(ACCESSOR_CLASS_NAME);
            Constructor<?> constructor = clazz.getConstructor(String.class);
            this.reflectedPingOneAccessor = constructor.newInstance(connEnvFieldValue);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ReflectionException(e);
        }
    }

    public String getAuthenticationEndpoint() throws ReflectionException {
        return this.getReflectedGetterValue(this.reflectedPingOneAccessor, AUTH_ENDPOINT_GETTER_METHOD_NAME, false);
    }

    public String getManagementEndpoint() throws ReflectionException {
        return this.getReflectedGetterValue(this.reflectedPingOneAccessor, MGMT_ENDPOINT_GETTER_METHOD_NAME, new Object[0]);
    }

    public String getEnvironmentId() throws ReflectionException {
        return this.getReflectedGetterValue(this.reflectedPingOneAccessor, ENV_ID_GETTER_METHOD_NAME, new Object[0]);
    }

    public String getAccessToken() throws ReflectionException {
        try {
            Expression expression = new Expression(this.reflectedPingOneAccessor, ACCESS_TOKEN_GETTER_METHOD_NAME, null);
            Object o = expression.getValue();
            return o != null ? o.toString() : null;
        }
        catch (RuntimeException e) {
            throw new DisabledAppException("The app in PingFederate or in PingOne is disabled.", e);
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    private String getReflectedGetterValue(Object reflectedClass, String methodName, Object ... args) throws ReflectionException {
        try {
            Expression expression = new Expression(reflectedClass, methodName, args);
            Object o = expression.getValue();
            return o != null ? o.toString() : null;
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    public static boolean isClassAvailable() {
        try {
            Class.forName(ACCESSOR_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }
}

