/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.pingone.pf;

import com.pingidentity.provisioner.integrations.pingone.pf.PingOneEnvironmentUtil;
import com.pingidentity.provisioner.saas.BaseSaasPlugin;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.SimpleFieldList;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class SaasParameterValidation {
    private static final String VALIDATOR_CLASS_NAME = "com.pingidentity.provisioner.validation.SaasParametersValidator";

    public SaasParameterValidation(BaseSaasPlugin baseSaasPlugin) {
        try {
            Class<?> validatorClass = Class.forName(VALIDATOR_CLASS_NAME);
            Object pingOneEnvironmentConfigurationValidator = Proxy.newProxyInstance(SaasParameterValidation.class.getClassLoader(), new Class[]{validatorClass}, (proxy, method, args) -> {
                SimpleFieldList fieldList = (SimpleFieldList)args[0];
                if (!PingOneEnvironmentUtil.isPingOneEnvironmentConfigured(fieldList)) {
                    throw new ValidationException("PingOne Environment should be configured.");
                }
                return null;
            });
            Object pingOneEnvironmentFieldConfigurationValidator = Proxy.newProxyInstance(SaasParameterValidation.class.getClassLoader(), new Class[]{validatorClass}, (proxy, method, args) -> {
                block3: {
                    SimpleFieldList fieldList = (SimpleFieldList)args[0];
                    String pingOneEnvironmentField = fieldList.getFieldValue("PINGONE_ENVIRONMENT");
                    if (StringUtils.isNotBlank((String)pingOneEnvironmentField)) {
                        try {
                            Class<?> pingOneEnvironmentValidatorClass = Class.forName("org.sourceid.saml20.adapter.gui.validation.impl.PingOneEnvironmentValidator");
                            Constructor<?> pingOneEnvironmentValidatorConstructor = pingOneEnvironmentValidatorClass.getConstructor(new Class[0]);
                            Object pingOneEnvironmentValidator = pingOneEnvironmentValidatorConstructor.newInstance(new Object[0]);
                            Method validateMethod = pingOneEnvironmentValidatorClass.getMethod("validate", Field.class);
                            validateMethod.invoke(pingOneEnvironmentValidator, fieldList.getField("PINGONE_ENVIRONMENT"));
                        }
                        catch (InvocationTargetException e) {
                            if (!(e.getTargetException() instanceof ValidationException)) break block3;
                            throw e.getTargetException();
                        }
                    }
                }
                return null;
            });
            Method addValidatorMethod = baseSaasPlugin.getClass().getMethod("addSaasParametersValidator", validatorClass);
            addValidatorMethod.invoke((Object)baseSaasPlugin, pingOneEnvironmentConfigurationValidator);
            addValidatorMethod.invoke((Object)baseSaasPlugin, pingOneEnvironmentFieldConfigurationValidator);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    public static boolean isClassAvailable() {
        try {
            Class.forName(VALIDATOR_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }
}

