/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.pingone.pf.cpl;

import com.pingidentity.io.cpl.pingone.metadata.ConnectionAttribute;
import com.pingidentity.io.cpl.pingone.metadata.ConnectionAttributes;
import com.pingidentity.prov.saas.pingone.metadata.CPLv3ConnectionFieldsBuilder;
import com.pingidentity.provisioner.integrations.pingone.ConnectionFieldKey;
import com.pingidentity.provisioner.integrations.pingone.pf.ReflectedFieldDescriptor;
import com.pingidentity.provisioner.integrations.pingone.pf.ReflectedPingOneEnvironmentAccessor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;

public class PingOneConnectionFieldsBuilder
extends CPLv3ConnectionFieldsBuilder {
    private static Logger logger = Logger.getLogger(PingOneConnectionFieldsBuilder.class);
    public static final String PINGONE_ENV_FIELD_NAME = "PINGONE_ENVIRONMENT";
    public static final String PINGONE_ENV_FIELD_DESC = "PingOne Environment";
    private static final String PROVISIONING_OPTIONS = "Provisioning Options";
    private ReflectedFieldDescriptor fieldDescriptorHelper = new ReflectedFieldDescriptor();

    @Override
    public List<FieldDescriptor> build(ConnectionAttributes connectionAttributes) {
        ArrayList<FieldDescriptor> descriptors = new ArrayList<FieldDescriptor>();
        String[] suspendUsersPossibleValues = new String[]{};
        String[] mfaDeviceManagementPossibleValues = new String[]{};
        String[] regionPossibleValues = new String[]{};
        String[] defaultAuthMethodPossibleValues = new String[]{};
        for (ConnectionAttribute attribute : connectionAttributes) {
            if (attribute.getKey().equals(ConnectionFieldKey.REMOVE_ACTION.getKey())) {
                suspendUsersPossibleValues = attribute.getPossibleValues();
                continue;
            }
            if (attribute.getKey().equals(ConnectionFieldKey.MFA_USER_DEVICE_MANAGEMENT.getKey())) {
                mfaDeviceManagementPossibleValues = attribute.getPossibleValues();
                continue;
            }
            if (attribute.getKey().equals(ConnectionFieldKey.REGION.getKey())) {
                regionPossibleValues = attribute.getPossibleValues();
                continue;
            }
            if (!attribute.getKey().equals(ConnectionFieldKey.DEFAULT_AUTH_METHOD.getKey())) continue;
            defaultAuthMethodPossibleValues = attribute.getPossibleValues();
        }
        boolean canLoadPingOneFieldDescriptor = ReflectedPingOneEnvironmentAccessor.isClassAvailable();
        if (canLoadPingOneFieldDescriptor) {
            try {
                Class<?> clazz = Class.forName("org.sourceid.saml20.adapter.gui.PingOneEnvironmentFieldDescriptor");
                Constructor<?> constructor = clazz.getConstructor(String.class, String.class);
                FieldDescriptor fd = (FieldDescriptor)constructor.newInstance(PINGONE_ENV_FIELD_NAME, PINGONE_ENV_FIELD_DESC);
                descriptors.add(fd);
                this.addInLegacyPingOneEnvironmentFields(descriptors, regionPossibleValues, true);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                logger.debug((Object)"PingFederate version is less than 10.2, showing legacy configuration options.", (Throwable)e);
                canLoadPingOneFieldDescriptor = false;
            }
        }
        if (!canLoadPingOneFieldDescriptor) {
            this.addInLegacyPingOneEnvironmentFields(descriptors, regionPossibleValues, false);
        }
        descriptors.add(this.addLabel(PROVISIONING_OPTIONS, PROVISIONING_OPTIONS));
        descriptors.add(this.addCheckbox(ConnectionFieldKey.CREATE_USERS_PROV_OPT.getKey(), ConnectionFieldKey.CREATE_USERS_PROV_OPT.getDesc()));
        descriptors.add(this.addCheckbox(ConnectionFieldKey.UPDATE_USERS_PROV_OPT.getKey(), ConnectionFieldKey.UPDATE_USERS_PROV_OPT.getDesc()));
        descriptors.add(this.addCheckbox(ConnectionFieldKey.REMOVE_USERS_PROV_OPT.getKey(), ConnectionFieldKey.REMOVE_USERS_PROV_OPT.getDesc()));
        descriptors.add(this.addCheckbox(ConnectionFieldKey.PROVISION_DISABLED_USERS_PROV_OPT.getKey(), ConnectionFieldKey.PROVISION_DISABLED_USERS_PROV_OPT.getDesc()));
        descriptors.add(this.addSelectField(ConnectionFieldKey.REMOVE_ACTION.getKey(), ConnectionFieldKey.REMOVE_ACTION.getDesc(), suspendUsersPossibleValues));
        descriptors.add(this.addSelectField(ConnectionFieldKey.MFA_USER_DEVICE_MANAGEMENT.getKey(), ConnectionFieldKey.MFA_USER_DEVICE_MANAGEMENT.getDesc(), mfaDeviceManagementPossibleValues));
        descriptors.add(this.addSelectField(ConnectionFieldKey.DEFAULT_AUTH_METHOD.getKey(), ConnectionFieldKey.DEFAULT_AUTH_METHOD.getDesc(), defaultAuthMethodPossibleValues));
        return descriptors;
    }

    private FieldDescriptor addLabel(String key, String desc) {
        ProvisioningTargetLabelFieldDescriptor field = new ProvisioningTargetLabelFieldDescriptor(key, desc);
        return field;
    }

    private FieldDescriptor addCheckbox(String key, String desc) {
        CheckBoxFieldDescriptor field = new CheckBoxFieldDescriptor(key, desc);
        field.setDefaultValue(Boolean.TRUE.toString());
        return field;
    }

    private FieldDescriptor addTextField(ConnectionFieldKey connectionField) {
        TextFieldDescriptor field = new TextFieldDescriptor(connectionField.getKey(), connectionField.getDesc(), connectionField.isSensitive());
        if (connectionField.isRequired()) {
            field.addValidator((FieldValidator)new RequiredFieldValidator());
        }
        return field;
    }

    private FieldDescriptor addSelectField(String key, String desc, String[] values) {
        SelectFieldDescriptor field = new SelectFieldDescriptor(key, desc, values);
        return field;
    }

    private void addInLegacyPingOneEnvironmentFields(List<FieldDescriptor> descriptors, String[] regionPossibleValues, boolean isHidden) {
        FieldDescriptor regionFd = this.addSelectField(ConnectionFieldKey.REGION.getKey(), ConnectionFieldKey.REGION.getDesc(), regionPossibleValues);
        this.fieldDescriptorHelper.setHidden(regionFd, isHidden);
        if (!isHidden) {
            regionFd.addValidator((FieldValidator)new RequiredFieldValidator());
        }
        descriptors.add(regionFd);
        FieldDescriptor envIdFd = this.addTextField(ConnectionFieldKey.ENVIRONMENT_ID);
        this.fieldDescriptorHelper.setHidden(envIdFd, isHidden);
        if (!isHidden) {
            envIdFd.addValidator((FieldValidator)new RequiredFieldValidator());
        }
        descriptors.add(envIdFd);
        FieldDescriptor clientIdFd = this.addTextField(ConnectionFieldKey.CLIENT_ID);
        this.fieldDescriptorHelper.setHidden(clientIdFd, isHidden);
        if (!isHidden) {
            clientIdFd.addValidator((FieldValidator)new RequiredFieldValidator());
        }
        descriptors.add(clientIdFd);
        FieldDescriptor clientSecretFd = this.addTextField(ConnectionFieldKey.CLIENT_SECRET);
        this.fieldDescriptorHelper.setHidden(clientSecretFd, isHidden);
        if (!isHidden) {
            clientSecretFd.addValidator((FieldValidator)new RequiredFieldValidator());
        }
        descriptors.add(clientSecretFd);
    }

    private void addInternalFields(List<FieldDescriptor> descriptors, boolean isHidden) {
        for (ConnectionFieldKey key : ConnectionFieldKey.getInternalConnectionFieldKeys()) {
            FieldDescriptor fd = this.addTextField(key);
            this.fieldDescriptorHelper.setHidden(fd, isHidden);
            descriptors.add(fd);
        }
    }

    public class ProvisioningTargetLabelFieldDescriptor
    extends FieldDescriptor {
        private static final long serialVersionUID = 6029695094471889487L;

        public ProvisioningTargetLabelFieldDescriptor(String name, String description) {
            super(name, description);
        }
    }
}

