/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.pingone.pf.cpl;

import com.pingidentity.io.cpl.pingone.metadata.Attributes;
import com.pingidentity.io.cpl.pingone.metadata.BaseAttribute;
import com.pingidentity.io.cpl.pingone.metadata.BooleanAttribute;
import com.pingidentity.io.cpl.pingone.metadata.ReferenceAttribute;
import com.pingidentity.io.cpl.pingone.metadata.StringAttribute;
import com.pingidentity.prov.saas.pingone.metadata.ProvisionerFieldsBuilder;
import com.pingidentity.provisioner.integrations.pingone.ResourceFieldKey;
import com.pingidentity.provisioner.integrations.pingone.pf.cpl.PingOneProvisionerFieldComparator;
import com.pingidentity.provisioner.mapping.FieldInfo;
import com.pingidentity.provisioner.sdk.SaasPluginFieldInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class PingOneProvisionerFieldsBuilder
implements ProvisionerFieldsBuilder {
    protected static final String CUSTOM_NOTE = "Custom attribute";
    private final Comparator<FieldInfo> comparator = new PingOneProvisionerFieldComparator();

    @Override
    public List<SaasPluginFieldInfo> build(Attributes userAttributes, Attributes groupAttributes) {
        BaseAttribute ba;
        ArrayList<SaasPluginFieldInfo> listToReturn = new ArrayList<SaasPluginFieldInfo>();
        ArrayList<String> addedKeys = new ArrayList<String>();
        for (String attrKey : userAttributes.keySet()) {
            if (ReferenceAttribute.ACTIVE.getKey().equals(attrKey)) continue;
            ba = (BaseAttribute)userAttributes.get(attrKey);
            listToReturn.add(this.make(ba));
            addedKeys.add(attrKey);
        }
        for (String attrKey : groupAttributes.keySet()) {
            ba = (BaseAttribute)groupAttributes.get(attrKey);
            if (addedKeys.contains(attrKey)) continue;
            listToReturn.add(this.make(ba));
        }
        Collections.sort(listToReturn, this.comparator);
        return listToReturn;
    }

    private SaasPluginFieldInfo make(BaseAttribute attribute) {
        BooleanAttribute boolAttribute;
        String code = attribute.getKey();
        String label = attribute.getDisplayName();
        boolean requiredOnCreate = false;
        boolean requiredOnUpdate = false;
        if (attribute.isRequiredOnCreate() != null) {
            requiredOnCreate = attribute.isRequiredOnCreate();
        }
        if (attribute.isRequiredOnUpdate() != null) {
            requiredOnUpdate = attribute.isRequiredOnUpdate();
        }
        boolean required = requiredOnCreate || requiredOnUpdate;
        boolean uniqueFlag = false;
        if (attribute.isUnique() != null) {
            uniqueFlag = attribute.isUnique();
        }
        boolean unique = uniqueFlag;
        String defaultValue = null;
        ArrayList<FieldInfo.Option> options = null;
        HashSet<String> uniqueOptionCodes = new HashSet<String>();
        if (attribute instanceof StringAttribute) {
            StringAttribute strAttribute = (StringAttribute)attribute;
            if (strAttribute.getDefaultValue() != null) {
                defaultValue = strAttribute.getDefaultValue();
            }
            if (strAttribute.getPicklistValues() != null && strAttribute.getPicklistValues().length > 0) {
                options = new ArrayList<FieldInfo.Option>();
                for (String name : strAttribute.getPicklistValues()) {
                    String optionCode;
                    FieldInfo.Option option = new FieldInfo.Option(name, name);
                    boolean isAuthIdpAttr = ResourceFieldKey.AUTHORITATIVE_IDP.getLabel().equalsIgnoreCase(code);
                    boolean isPopIdAttr = ResourceFieldKey.POPULATION_ID.getLabel().equalsIgnoreCase(code);
                    if (isAuthIdpAttr && name.contains("||") && name.indexOf("||") == 0) continue;
                    if ((isAuthIdpAttr || isPopIdAttr) && name.contains("||")) {
                        int idx = name.indexOf("||");
                        String id = name.substring(0, idx);
                        String optionName = name.substring(idx + 2);
                        option = new FieldInfo.Option(id, optionName);
                    }
                    if (uniqueOptionCodes.contains(optionCode = option.getCode())) continue;
                    options.add(option);
                    uniqueOptionCodes.add(option.getCode());
                }
            }
        } else if (attribute instanceof BooleanAttribute && (boolAttribute = (BooleanAttribute)attribute).getDefaultValue() != null) {
            defaultValue = boolAttribute.getDefaultValue().toString();
        }
        SaasPluginFieldInfo newField = null;
        newField = new SaasPluginFieldInfo(code, label, required, unique);
        newField.setDefault(defaultValue);
        if (attribute.getMaxNumberOfValues() != null) {
            newField.setMultiValue(attribute.getMaxNumberOfValues() > 1);
        }
        if (options != null) {
            newField.setOptions(options);
        }
        if (Boolean.TRUE.equals(attribute.isDerived())) {
            newField.addNote(CUSTOM_NOTE);
        }
        return newField;
    }
}

