/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.pingone.saas.http;

import com.pingidentity.io.cpl.pingone.exception.ResourceException;
import com.pingidentity.io.cpl.pingone.exception.ServiceException;
import com.pingidentity.io.cpl.pingone.exception.ServiceUnavailableException;
import com.pingidentity.io.cpl.pingone.resource.Resource;
import com.pingidentity.provisioner.integrations.pingone.PingOneLogEvents;
import com.pingidentity.provisioner.integrations.pingone.saas.SaasHttpService;
import com.pingidentity.provisioner.integrations.pingone.saas.http.HttpClientFactory;
import com.pingidentity.provisioner.integrations.pingone.saas.http.Validator;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.ClassicHttpResponse;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.HttpEntity;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.ParseException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.io.entity.EntityUtils;
import java.io.IOException;

public class PingOneHttpService
implements SaasHttpService {
    private final Validator validator;
    private HttpClientFactory clientFactory;

    public PingOneHttpService(Validator validator, HttpClientFactory clientFactory) {
        this.validator = validator;
        this.clientFactory = clientFactory;
    }

    @Override
    public String executeFullRequest(Resource resource, HttpUriRequest request) throws ServiceException, ResourceException {
        CloseableHttpClient httpClient = this.clientFactory.buildClient();
        CloseableHttpResponse response = null;
        HttpEntity entity = null;
        String body = "";
        try {
            response = httpClient.execute(request);
            entity = response.getEntity();
            if (entity != null) {
                body = EntityUtils.toString(entity);
            }
            this.validator.validateFullRequest(resource, response, body);
        }
        catch (ParseException | IOException e) {
            throw new ServiceUnavailableException(String.format("%1s There was a problem with the HTTP Request sent to PingOne, PingOnes responded with the message: %2s", PingOneLogEvents.ERR_SERVER_ERROR.getCode(), e.getMessage()));
        }
        finally {
            this.tidyUpHttpClient(httpClient, response, entity);
        }
        return body;
    }

    @Override
    public String executeServiceOnlyRequest(Resource resource, HttpUriRequest request) throws ServiceException {
        CloseableHttpClient httpClient = this.clientFactory.buildClient();
        CloseableHttpResponse response = null;
        HttpEntity entity = null;
        String body = "";
        try {
            response = httpClient.execute(request);
            entity = response.getEntity();
            if (entity != null) {
                body = EntityUtils.toString(entity);
            }
            this.validator.validateServiceRequest(resource, response, body);
        }
        catch (ParseException | IOException e) {
            throw new ServiceUnavailableException(String.format("%1s There was a problem with the HTTP Request sent to PingOne, PingOne responsed with the message: %2s", PingOneLogEvents.ERR_SERVER_ERROR.getCode(), e.getMessage()));
        }
        finally {
            this.tidyUpHttpClient(httpClient, response, entity);
        }
        return body;
    }

    private void tidyUpHttpClient(CloseableHttpClient httpClient, ClassicHttpResponse response, HttpEntity entity) throws ServiceUnavailableException {
        if (entity != null) {
            EntityUtils.consumeQuietly(entity);
        }
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException e) {
                throw new ServiceUnavailableException(String.format("%1s here was a problem closing the PingOne http response: %2s", PingOneLogEvents.ERR_SERVER_ERROR.getCode(), e.getMessage()));
            }
        }
        if (httpClient != null) {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                throw new ServiceUnavailableException(String.format("%1s There was a problem closing the http client: %2s", PingOneLogEvents.ERR_SERVER_ERROR.getCode(), e.getMessage()));
            }
        }
    }
}

