/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.pingone.saas.wrapper;

import com.pingidentity.io.cpl.pingone.exception.ResourceException;
import com.pingidentity.io.cpl.pingone.exception.ResourceNotFoundException;
import com.pingidentity.io.cpl.pingone.exception.ServiceException;
import com.pingidentity.io.cpl.pingone.exception.ServiceUnknownStateException;
import com.pingidentity.io.cpl.pingone.metadata.Attributes;
import com.pingidentity.io.cpl.pingone.request.ConnectionFields;
import com.pingidentity.io.cpl.pingone.request.PageFields;
import com.pingidentity.io.cpl.pingone.resource.Group;
import com.pingidentity.io.cpl.pingone.resource.Groups;
import com.pingidentity.io.cpl.pingone.resource.Membership;
import com.pingidentity.io.cpl.pingone.resource.Memberships;
import com.pingidentity.io.cpl.pingone.resource.ResourceAttributes;
import com.pingidentity.io.cpl.pingone.resource.ResourceUniqueId;
import com.pingidentity.io.cpl.pingone.resource.User;
import com.pingidentity.io.cpl.pingone.resource.Users;
import com.pingidentity.io.cpl.pingone.resource.Values;
import com.pingidentity.provisioner.integrations.pingone.ConnectionFieldKey;
import com.pingidentity.provisioner.integrations.pingone.DeviceMgmtOption;
import com.pingidentity.provisioner.integrations.pingone.PingOneLogEvents;
import com.pingidentity.provisioner.integrations.pingone.ResourceFieldKey;
import com.pingidentity.provisioner.integrations.pingone.saas.SaasGroup;
import com.pingidentity.provisioner.integrations.pingone.saas.SaasHttpService;
import com.pingidentity.provisioner.integrations.pingone.saas.SaasMembership;
import com.pingidentity.provisioner.integrations.pingone.saas.SaasUser;
import com.pingidentity.provisioner.integrations.pingone.saas.SaasUserGroupApi;
import com.pingidentity.provisioner.integrations.pingone.saas.SaasUserGroupBuilder;
import com.pingidentity.provisioner.integrations.pingone.saas.UserRequestBuilder;
import com.pingidentity.provisioner.integrations.pingone.saas.cache.SchemaCache;
import com.pingidentity.provisioner.integrations.pingone.saas.http.PingOneHttpClientFactory;
import com.pingidentity.provisioner.integrations.pingone.saas.http.PingOneHttpService;
import com.pingidentity.provisioner.integrations.pingone.saas.http.PingOneValidator;
import com.pingidentity.provisioner.integrations.pingone.saas.request_builder.PingOneUserRequestBuilder;
import com.pingidentity.provisioner.integrations.pingone.saas.resource_builder.PingOneResourceBuilder;
import com.pingidentity.provisioner.integrations.pingone.saas.serialization.PingOneDeserializer;
import com.pingidentity.provisioner.integrations.pingone.saas.serialization.PingOneSerializer;
import com.pingidentity.provisioner.integrations.pingone.saas.wrapper.IdaasDirectoryPassword;
import com.pingidentity.provisioner.integrations.pingone.saas.wrapper.MfaMethod;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.CrudClient;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.CrudException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.ClientConfig;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.device.Device;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.device.DeviceAttribute;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.device.DeviceCrudClientFactory;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.device.DeviceType;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.device.crud.exception.InvalidDataException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.idp.IdentityProvider;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.idp.IdpCrudClientFactory;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.population.Population;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.population.PopulationCrudClientFactory;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.Schema;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.SchemaAttribute;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.SchemaAttributeCrudClientFactory;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.SchemaAttributeProperty;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.SchemaCrudClientFactory;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PingOneSaasApi
implements SaasUserGroupApi {
    public static final String USER_SCHEMA_NAME = "User";
    private UserRequestBuilder requestBuilder;
    private SaasHttpService httpService;
    private SaasUserGroupBuilder userBuilder;
    private CrudClient<ClientConfig, Device> deviceClient;
    private CrudClient<ClientConfig, IdentityProvider> idpClient;
    private CrudClient<ClientConfig, Population> populationClient;
    private CrudClient<ClientConfig, Schema> schemaClient;
    private CrudClient<ClientConfig, SchemaAttribute> schemaAttributeClient;
    private final SchemaCache schemaCache;
    private static final IntegrationsLogger logger = new IntegrationsLogger(PingOneSaasApi.class);

    public PingOneSaasApi() {
        this.requestBuilder = new PingOneUserRequestBuilder(new PingOneSerializer());
        this.httpService = new PingOneHttpService(new PingOneValidator(), new PingOneHttpClientFactory());
        this.userBuilder = new PingOneResourceBuilder(new PingOneDeserializer());
        this.deviceClient = new DeviceCrudClientFactory().make();
        this.idpClient = new IdpCrudClientFactory().make();
        this.populationClient = new PopulationCrudClientFactory().make();
        this.schemaClient = new SchemaCrudClientFactory().make();
        this.schemaAttributeClient = new SchemaAttributeCrudClientFactory().make();
        this.schemaCache = SchemaCache.getInstance();
    }

    public PingOneSaasApi(UserRequestBuilder requestBuilder, SaasHttpService httpService, SaasUserGroupBuilder userBuilder, CrudClient<ClientConfig, Device> deviceClient, CrudClient<ClientConfig, IdentityProvider> idpClient, CrudClient<ClientConfig, Population> popClient, CrudClient<ClientConfig, Schema> schemaClient, CrudClient<ClientConfig, SchemaAttribute> schemaAttributeClient) {
        this.requestBuilder = requestBuilder;
        this.httpService = httpService;
        this.userBuilder = userBuilder;
        this.deviceClient = deviceClient;
        this.idpClient = idpClient;
        this.populationClient = popClient;
        this.schemaClient = schemaClient;
        this.schemaAttributeClient = schemaAttributeClient;
        this.schemaCache = SchemaCache.getInstance();
    }

    @Override
    public SaasUser createUser(ConnectionFields connectionFields, User user, Attributes customAttributes) throws ServiceException, ResourceException {
        logger.log(PingOneLogEvents.CREATE_USER);
        if (this.passwordMigrationEnabled(connectionFields)) {
            this.userPasswordMigration(connectionFields, user);
        }
        ResourceAttributes resourceAttributes = user.getResourceAttributes();
        HttpUriRequest request = this.requestBuilder.buildCreateUserRequest(connectionFields, resourceAttributes, customAttributes);
        String userString = this.httpService.executeFullRequest(user, request);
        SaasUser saasUser = this.userBuilder.buildUser(userString, user);
        return saasUser;
    }

    @Override
    public void createUserMfaDevices(ConnectionFields connectionFields, ResourceAttributes ra, ResourceUniqueId ruid) throws CrudException {
        if (DeviceMgmtOption.UNMANAGED != PingOneSaasApi.getDeviceMgmtOption(connectionFields)) {
            this.createDevices(connectionFields, this.getDirectoryMfaAttrs(ra), ruid);
        }
    }

    private static DeviceMgmtOption getDeviceMgmtOption(ConnectionFields connectionFields) {
        String optionName = (String)connectionFields.get(ConnectionFieldKey.MFA_USER_DEVICE_MANAGEMENT.getKey());
        DeviceMgmtOption deviceMgmtOption = optionName != null ? DeviceMgmtOption.valueOfName(optionName) : DeviceMgmtOption.MERGE;
        logger.log((LogEvent)PingOneLogEvents.DEVICE_MGMT_OPTION, deviceMgmtOption.getName());
        return deviceMgmtOption;
    }

    public void userPasswordMigration(ConnectionFields connectionFields, User user) throws ResourceException, ServiceException {
        logger.log(PingOneLogEvents.PASSWORD_MIGRATION_ENABLED);
        HttpUriRequest request = this.requestBuilder.buildPasswordMigrationRequest(connectionFields, user.getResourceAttributes().getValueOf(ResourceFieldKey.USERNAME.getLabel()));
        String passwordMigrationJson = this.httpService.executeServiceOnlyRequest(user, request);
        IdaasDirectoryPassword directoryPassword = this.userBuilder.buildIdaasDirectoryPassword(passwordMigrationJson, user);
        if (directoryPassword != null && directoryPassword.getPassword() != null && !directoryPassword.getPassword().trim().isEmpty() && directoryPassword.isPasswordExpired() != null) {
            logger.log(PingOneLogEvents.SETTING_PASSWORD);
            user.getResourceAttributes().add(ResourceFieldKey.PASSWORD.getLabel(), directoryPassword.getPassword());
            Boolean isPasswordExpired = directoryPassword.isPasswordExpired();
            user.getResourceAttributes().add(ResourceFieldKey.FORCE_CHANGE_PASSWORD.getLabel(), isPasswordExpired.toString());
        } else {
            logger.log(PingOneLogEvents.PASSWORD_NOT_SET);
        }
    }

    @Override
    public SaasUser getUserBySaasGuid(ConnectionFields connectionFields, User user) throws ResourceException, ServiceException {
        return this.userBuilder.buildUser(this.httpService.executeFullRequest(user, this.requestBuilder.buildGetUserRequest(connectionFields, user.getResourceUniqueId())), user);
    }

    @Override
    public SaasUser getUserBySecondaryId(ConnectionFields connectionFields, User user) throws ResourceException, ServiceException {
        String secondaryId = user.getResourceAttributes().getValueOf(ResourceFieldKey.getSecondaryId().getLabel());
        HttpUriRequest request = this.requestBuilder.buildGetUserRequest(connectionFields, secondaryId);
        String userString = this.httpService.executeFullRequest(user, request);
        return this.userBuilder.buildUserByFilter(userString, user);
    }

    @Override
    public Users getAllUsers(ConnectionFields connectionFields, PageFields pageFields) throws ServiceException {
        HttpUriRequest request = this.requestBuilder.buildGetAllUsers(connectionFields, pageFields);
        String usersString = this.httpService.executeServiceOnlyRequest(new User(), request);
        return this.userBuilder.buildUsers(usersString, pageFields);
    }

    @Override
    public SaasUser updateUser(ConnectionFields connectionFields, User user, Attributes customAttributes) throws ServiceException, ResourceException {
        SaasUser pingoneUser = this.getUserBySaasGuid(connectionFields, user);
        Values activeValueCurrentlyInSaas = (Values)pingoneUser.getCplUser().getResourceAttributes().get(ResourceFieldKey.ENABLED.getLabel());
        Values newActiveValue = (Values)user.getResourceAttributes().get(ResourceFieldKey.ENABLED.getLabel());
        if (this.notAllowedToUpdateUsers(connectionFields)) {
            user = pingoneUser.getCplUser();
        } else {
            this.addMissingResourceAttributes(user, pingoneUser.getCplUser());
        }
        Values newMfaEnabledValue = (Values)user.getResourceAttributes().get(ResourceFieldKey.MFA_ENABLED.getLabel());
        Values mfaEnabledValueCurrentlyInSaas = (Values)pingoneUser.getCplUser().getResourceAttributes().get(ResourceFieldKey.MFA_ENABLED.getLabel());
        user.getResourceAttributes().add(ResourceFieldKey.ENABLED.getLabel(), activeValueCurrentlyInSaas);
        user.getResourceAttributes().add(ResourceFieldKey.MFA_ENABLED.getLabel(), mfaEnabledValueCurrentlyInSaas);
        HttpUriRequest request = this.requestBuilder.buildUpdateUserRequest(connectionFields, user, customAttributes);
        this.httpService.executeFullRequest(user, request);
        Values populationValueCurrentlyInSaas = (Values)pingoneUser.getCplUser().getResourceAttributes().get(ResourceFieldKey.POPULATION_ID.getLabel());
        Values newPopulationValue = (Values)user.getResourceAttributes().get(ResourceFieldKey.POPULATION_ID.getLabel());
        if (this.valueChanged(populationValueCurrentlyInSaas, newPopulationValue)) {
            this.updatePopulation(connectionFields, user);
        }
        if (this.valueChanged(activeValueCurrentlyInSaas, newActiveValue)) {
            user.getResourceAttributes().add(ResourceFieldKey.ENABLED.getLabel(), newActiveValue);
            this.updateEnabled(connectionFields, user);
        }
        if (this.passwordMigrationEnabled(connectionFields)) {
            this.userPasswordMigration(connectionFields, user);
        }
        if (this.attributeHasValue(user, ResourceFieldKey.PASSWORD.getLabel())) {
            this.updatePassword(connectionFields, user);
        }
        if (this.valueChanged(mfaEnabledValueCurrentlyInSaas, newMfaEnabledValue)) {
            user.getResourceAttributes().add(ResourceFieldKey.MFA_ENABLED.getLabel(), newMfaEnabledValue);
            this.updateMfaEnabled(connectionFields, user);
        }
        Values newIdpValue = (Values)user.getResourceAttributes().get(ResourceFieldKey.AUTHORITATIVE_IDP.getLabel());
        Values idpValueCurrentlyInSaas = (Values)pingoneUser.getCplUser().getResourceAttributes().get(ResourceFieldKey.AUTHORITATIVE_IDP.getLabel());
        if (this.valueChanged(idpValueCurrentlyInSaas, newIdpValue)) {
            this.updateUsersIdentityProvider(connectionFields, user);
        }
        return this.getUserBySaasGuid(connectionFields, user);
    }

    @Override
    public void updateUserMfaDevices(ConnectionFields connectionFields, User user) throws CrudException {
        DeviceMgmtOption deviceMgmtOption = PingOneSaasApi.getDeviceMgmtOption(connectionFields);
        if (!this.notAllowedToUpdateUsers(connectionFields) && DeviceMgmtOption.UNMANAGED != deviceMgmtOption) {
            this.updateDevices(connectionFields, this.getDirectoryMfaAttrs(user.getResourceAttributes()), user.getResourceUniqueId(), deviceMgmtOption);
        }
    }

    @Override
    public void deleteUser(ConnectionFields connectionFields, User user) throws ServiceException, ResourceException {
        HttpUriRequest request = this.requestBuilder.buildDeleteUserRequest(connectionFields, user.getResourceUniqueId());
        this.httpService.executeFullRequest(user, request);
    }

    @Override
    public void checkConnection(ConnectionFields connectionFields) throws ServiceException {
        block2: {
            try {
                String nonExistentValidUUID = "00000000-0000-0000-0000-000000000000";
                HttpUriRequest request = this.requestBuilder.buildGetUserRequest(connectionFields, new ResourceUniqueId(nonExistentValidUUID));
                this.httpService.executeFullRequest(new User(), request);
            }
            catch (ResourceException e) {
                if (e.getClass() == ResourceNotFoundException.class) break block2;
                logger.log((LogEvent)PingOneLogEvents.CHECK_CONNECTION_ERROR, e);
                throw new ServiceUnknownStateException(String.format("%1s Unknown Server state. Message returned: %2s", PingOneLogEvents.CHECK_CONNECTION_ERROR.getCode(), e.getMessage()));
            }
        }
    }

    public void updatePopulation(ConnectionFields connectionFields, User user) throws ResourceException, ServiceException {
        HttpUriRequest request = this.requestBuilder.buildUpdatePopulationRequest(connectionFields, user);
        this.httpService.executeFullRequest(user, request);
    }

    public void updateEnabled(ConnectionFields connectionFields, User user) throws ResourceException, ServiceException {
        HttpUriRequest request = this.requestBuilder.buildUpdateEnabledRequest(connectionFields, user);
        this.httpService.executeFullRequest(user, request);
    }

    public void updateMfaEnabled(ConnectionFields connectionFields, User user) throws ResourceException, ServiceException {
        HttpUriRequest request = this.requestBuilder.buildUpdateMfaEnabledRequest(connectionFields, user);
        this.httpService.executeFullRequest(user, request);
    }

    public void updatePassword(ConnectionFields connectionFields, User user) throws ResourceException, ServiceException {
        HttpUriRequest request = this.requestBuilder.buildUpdatePasswordRequest(connectionFields, user);
        this.httpService.executeFullRequest(user, request);
    }

    private boolean passwordMigrationEnabled(ConnectionFields connectionFields) {
        String passwordMigrationValue = (String)connectionFields.get(ConnectionFieldKey.P14E_DIRECTORY_PASSWORD_MIGRATION.getKey());
        boolean isPasswordMigrationEnabled = Boolean.TRUE.toString().equalsIgnoreCase(passwordMigrationValue);
        logger.log((LogEvent)PingOneLogEvents.PASSWORD_MIGRATION_SETTINGS, String.format("Connection Fields P14E_DIRECTORY_PASSWORD_MIGRATION value: %s\nConnectionFields P14E_DIRECTORY_PASSWORD_MIGRATION result: %s", passwordMigrationValue, isPasswordMigrationEnabled));
        return isPasswordMigrationEnabled;
    }

    private boolean notAllowedToUpdateUsers(ConnectionFields connectionFields) {
        return connectionFields.containsKey(ConnectionFieldKey.UPDATE_USERS_PROV_OPT.getKey()) && !((String)connectionFields.get(ConnectionFieldKey.UPDATE_USERS_PROV_OPT.getKey())).equalsIgnoreCase(Boolean.TRUE.toString());
    }

    private boolean attributeHasValue(User user, String key) {
        return user.getResourceAttributes() != null && user.getResourceAttributes().containsKey(key) && user.getResourceAttributes().getValueOf(key) != null && !user.getResourceAttributes().getValueOf(key).trim().isEmpty();
    }

    private User addMissingResourceAttributes(User update, User original) {
        ResourceAttributes attributes = original.getResourceAttributes();
        for (Map.Entry entry : attributes.entrySet()) {
            String key = (String)entry.getKey();
            Values val = (Values)entry.getValue();
            if (update.getResourceAttributes().containsKey(key) && (!update.getResourceAttributes().containsKey(key) || update.getResourceAttributes().get(key) != null && !((Values)update.getResourceAttributes().get(key)).isEmpty() && !((Values)update.getResourceAttributes().get(key)).contains("null"))) continue;
            update.getResourceAttributes().add(key, val);
        }
        return update;
    }

    private void createDevices(ConnectionFields connectionFields, Map<MfaMethod, String> mfaAttrs, ResourceUniqueId userId) throws CrudException {
        if (mfaAttrs.isEmpty()) {
            return;
        }
        Map<ClientConfig, String> clientConfig = this.buildClientConfig(connectionFields);
        MfaMethod defaultMethod = this.getDefaultMfaMethod(connectionFields);
        ArrayList<InvalidDataException> allExceptions = new ArrayList<InvalidDataException>();
        for (MfaMethod mfaMethod : MfaMethod.getMethodOrder(defaultMethod)) {
            Device device;
            InvalidDataException exception;
            String mfaValue = mfaAttrs.get((Object)mfaMethod);
            if (mfaValue == null || (exception = this.createDeviceInternal(clientConfig, device = this.buildDevice(userId, mfaMethod, mfaValue))) == null) continue;
            allExceptions.add(exception);
        }
        if (!allExceptions.isEmpty()) {
            throw (CrudException)allExceptions.get(0);
        }
    }

    private MfaMethod getDefaultMfaMethod(ConnectionFields connectionFields) {
        String defaultMethodName = (String)connectionFields.get(ConnectionFieldKey.DEFAULT_AUTH_METHOD.getKey());
        MfaMethod method = MfaMethod.valueOfName(defaultMethodName);
        if (method == null) {
            logger.log((LogEvent)PingOneLogEvents.INVALID_DEFAULT_AUTH_METHOD, defaultMethodName);
        }
        return method;
    }

    private InvalidDataException createDeviceInternal(Map<ClientConfig, String> clientConfig, Device device) throws CrudException {
        String nickname = device.getOne(DeviceAttribute.NICKNAME);
        logger.log((LogEvent)PingOneLogEvents.CREATE_DEVICE, nickname);
        try {
            this.deviceClient.create(clientConfig, device);
            logger.log((LogEvent)PingOneLogEvents.DEVICE_CREATED, nickname);
        }
        catch (InvalidDataException e) {
            logger.log((LogEvent)PingOneLogEvents.INVALID_DEVICE_DATA, nickname, e.getMessage());
            return e;
        }
        return null;
    }

    public void updateDevices(ConnectionFields connectionFields, Map<MfaMethod, String> directoryMfaDevices, ResourceUniqueId userId, DeviceMgmtOption deviceMgmtOption) throws CrudException {
        Map<ClientConfig, String> clientConfig = this.buildClientConfig(connectionFields);
        List<Device> spDevices = this.getSpDevices(userId, clientConfig);
        this.syncDevices(clientConfig, userId, directoryMfaDevices, spDevices, deviceMgmtOption);
    }

    private List<Device> getSpDevices(ResourceUniqueId userId, Map<ClientConfig, String> clientConfig) throws CrudException {
        logger.log(PingOneLogEvents.GET_DEVICES);
        Device query = new Device();
        query.putOne(DeviceAttribute.USER_ID, userId.getId());
        return this.deviceClient.search(clientConfig, query);
    }

    private Map<MfaMethod, String> getDirectoryMfaAttrs(ResourceAttributes resourceAttributes) {
        HashMap<MfaMethod, String> directoryDevices = new HashMap<MfaMethod, String>();
        for (MfaMethod method : MfaMethod.values()) {
            String value = resourceAttributes.getValueOf(method.getResourceFieldName());
            if (value == null || value.trim().isEmpty()) continue;
            directoryDevices.put(method, value);
        }
        return directoryDevices;
    }

    private boolean devicesContainsDevice(List<Device> devices, Device queryDevice) {
        Map queryDeviceAttrs = queryDevice.getAttributes();
        for (Device device : devices) {
            Map deviceAttrs = device.getAttributes();
            if (!deviceAttrs.equals(queryDeviceAttrs)) continue;
            return true;
        }
        return false;
    }

    private void syncDevices(Map<ClientConfig, String> clientConfig, ResourceUniqueId userId, Map<MfaMethod, String> directoryDevices, List<Device> spDevices, DeviceMgmtOption deviceMgmtOption) throws CrudException {
        ArrayList<Device> builtDevices = new ArrayList<Device>();
        directoryDevices.forEach((k, v) -> builtDevices.add(this.buildDevice(userId, (MfaMethod)((Object)k), (String)v)));
        List managedValues = builtDevices.stream().map(device -> DeviceType.EMAIL.getType().equalsIgnoreCase(device.getOne(DeviceAttribute.TYPE)) ? device.getOne(DeviceAttribute.EMAIL) : device.getOne(DeviceAttribute.PHONE)).collect(Collectors.toList());
        for (Device spDevice : spDevices) {
            boolean isDeviceSynced = this.devicesContainsDevice(builtDevices, spDevice);
            boolean isOverwriteEnabledAndDeviceUnmanaged = deviceMgmtOption == DeviceMgmtOption.OVERWRITE && !isDeviceSynced;
            String nickname = spDevice.getOne(DeviceAttribute.NICKNAME);
            if (isOverwriteEnabledAndDeviceUnmanaged) {
                logger.log((LogEvent)PingOneLogEvents.DELETE_DEVICE, nickname);
                this.deviceClient.delete(clientConfig, spDevice);
                logger.log((LogEvent)PingOneLogEvents.DEVICE_DELETED, nickname);
            }
            String deviceValue = DeviceType.EMAIL.getType().equalsIgnoreCase(spDevice.getOne(DeviceAttribute.TYPE)) ? spDevice.getOne(DeviceAttribute.EMAIL) : spDevice.getOne(DeviceAttribute.PHONE);
            boolean isManagedValue = managedValues.contains(deviceValue);
            boolean isManagedNickname = MfaMethod.isValidName(nickname);
            boolean hasDeviceAlreadyBeenDeleted = isOverwriteEnabledAndDeviceUnmanaged;
            if (!isManagedNickname && !isManagedValue || isDeviceSynced || hasDeviceAlreadyBeenDeleted) continue;
            logger.log((LogEvent)PingOneLogEvents.DELETE_DEVICE, nickname);
            this.deviceClient.delete(clientConfig, spDevice);
            logger.log((LogEvent)PingOneLogEvents.DEVICE_DELETED, nickname);
        }
        ArrayList<InvalidDataException> allExceptions = new ArrayList<InvalidDataException>();
        for (Device builtDevice : builtDevices) {
            InvalidDataException exception;
            if (this.devicesContainsDevice(spDevices, builtDevice) || (exception = this.createDeviceInternal(clientConfig, builtDevice)) == null) continue;
            allExceptions.add(exception);
        }
        if (!allExceptions.isEmpty()) {
            throw (CrudException)allExceptions.get(0);
        }
    }

    private Map<ClientConfig, String> buildClientConfig(ConnectionFields connectionFields) {
        HashMap<ConnectionFieldKey, ClientConfig> mapping = new HashMap<ConnectionFieldKey, ClientConfig>();
        mapping.put(ConnectionFieldKey.MGMT_URL, ClientConfig.API_BASE_URL);
        mapping.put(ConnectionFieldKey.P1_DIRECTORY_BASE_URL, ClientConfig.P1_DIRECTORY_BASE_URL);
        mapping.put(ConnectionFieldKey.P1_MFA_DEVICE_BASE_URL, ClientConfig.P1_MFA_DEVICE_BASE_URL);
        mapping.put(ConnectionFieldKey.P1_IDENTITY_PROVIDER_BASE_URL, ClientConfig.P1_IDENTITY_PROVIDER_BASE_URL);
        mapping.put(ConnectionFieldKey.ENV_ID, ClientConfig.ENV_ID);
        mapping.put(ConnectionFieldKey.ACCESS_TOKEN, ClientConfig.ACCESS_TOKEN);
        HashMap<ClientConfig, String> config = new HashMap<ClientConfig, String>();
        for (Map.Entry entry : mapping.entrySet()) {
            config.put((ClientConfig)((Object)entry.getValue()), (String)connectionFields.get(((ConnectionFieldKey)((Object)entry.getKey())).getKey()));
        }
        return config;
    }

    private Device buildDevice(ResourceUniqueId userId, MfaMethod mfaMethod, String value) {
        Device device = new Device();
        device.putOne(DeviceAttribute.USER_ID, userId.getId());
        device.putOne(DeviceAttribute.TYPE, mfaMethod.getType().getType());
        device.putOne(DeviceAttribute.NICKNAME, mfaMethod.getName());
        device.putOne(DeviceAttribute.STATUS, "ACTIVE");
        device.putOne(mfaMethod.getValueAttribute(), value);
        return device;
    }

    private boolean valueChanged(Values oldValue, Values newValue) {
        boolean isOldValueNullOrEmpty = oldValue == null || oldValue.getValue() == null || oldValue.getValue().isEmpty();
        boolean isNewValueNullOrEmpty = newValue == null || newValue.getValue() == null || newValue.getValue().isEmpty();
        String oldStringValue = !isOldValueNullOrEmpty ? oldValue.getValue() : "";
        String newStringValue = !isNewValueNullOrEmpty ? newValue.getValue() : "";
        return !newStringValue.equalsIgnoreCase(oldStringValue);
    }

    @Override
    public List<IdentityProvider> getIdps(ConnectionFields connectionFields) throws CrudException {
        Map<ClientConfig, String> clientConfig = this.buildClientConfig(connectionFields);
        return this.idpClient.search(clientConfig, new IdentityProvider());
    }

    @Override
    public List<Population> getPopulations(ConnectionFields connectionFields) throws CrudException {
        Map<ClientConfig, String> clientConfig = this.buildClientConfig(connectionFields);
        return this.populationClient.search(clientConfig, new Population());
    }

    @Override
    public List<Schema> getSchemas(ConnectionFields connectionFields) throws CrudException {
        Map<ClientConfig, String> clientConfig = this.buildClientConfig(connectionFields);
        return this.schemaCache.getSchemas(clientConfig);
    }

    @Override
    public List<SchemaAttribute> getSchemaAttributes(ConnectionFields connectionFields, Schema schema) throws CrudException {
        Map<ClientConfig, String> clientConfig = this.buildClientConfig(connectionFields);
        SchemaAttribute attribute = new SchemaAttribute();
        attribute.add(SchemaAttributeProperty.SCHEMA_ID, schema.getId());
        return this.schemaCache.getSchemaAttributes(clientConfig, attribute);
    }

    private void updateUsersIdentityProvider(ConnectionFields cf, User u) throws ResourceException, ServiceException {
        ResourceUniqueId userId = u.getResourceUniqueId();
        String idpId = u.getResourceAttributes().getValueOf(ResourceFieldKey.AUTHORITATIVE_IDP.getLabel());
        HttpUriRequest updateIdpReq = this.requestBuilder.buildUpdateIdentityProviderRequest(cf, userId, idpId);
        this.httpService.executeFullRequest(u, updateIdpReq);
    }

    @Override
    public SaasGroup createGroup(ConnectionFields connectionFields, Group group) throws ServiceException, ResourceException {
        HttpUriRequest request = this.requestBuilder.buildCreateGroupRequest(connectionFields, group.getResourceAttributes());
        String groupString = this.httpService.executeFullRequest(group, request);
        return this.userBuilder.buildGroup(groupString, group);
    }

    @Override
    public SaasGroup getGroupBySaasGuid(ConnectionFields connectionFields, Group group) throws ServiceException, ResourceException {
        HttpUriRequest request = this.requestBuilder.buildGetGroupRequest(connectionFields, group.getResourceUniqueId());
        String groupString = this.httpService.executeFullRequest(group, request);
        return this.userBuilder.buildGroup(groupString, group);
    }

    @Override
    public SaasGroup getGroupBySecondaryId(ConnectionFields connectionFields, Group group) throws ServiceException, ResourceException {
        String secondaryId = group.getResourceAttributes().getValueOf(ResourceFieldKey.GROUP_NAME.getLabel());
        HttpUriRequest request = this.requestBuilder.buildGetGroupRequest(connectionFields, secondaryId);
        String groupString = this.httpService.executeFullRequest(group, request);
        return this.userBuilder.buildGroupByFilter(groupString, group);
    }

    @Override
    public Groups getAllGroups(ConnectionFields connectionFields, PageFields pageFields) throws ServiceException {
        return null;
    }

    @Override
    public SaasGroup updateGroup(ConnectionFields connectionFields, Group group) throws ServiceException, ResourceException {
        HttpUriRequest request = this.requestBuilder.buildUpdateGroupRequest(connectionFields, group);
        this.httpService.executeFullRequest(group, request);
        return this.getGroupBySaasGuid(connectionFields, group);
    }

    @Override
    public void deleteGroup(ConnectionFields connectionFields, Group group) throws ServiceException, ResourceException {
        HttpUriRequest request = this.requestBuilder.buildDeleteGroupRequest(connectionFields, group.getResourceUniqueId());
        try {
            this.httpService.executeFullRequest(group, request);
        }
        catch (ResourceNotFoundException e) {
            String groupName = group.getResourceAttributes().getValueOf(ResourceFieldKey.GROUP_NAME.getLabel());
            logger.log((LogEvent)PingOneLogEvents.GROUP_NOT_FOUND_ON_DELETE, groupName);
        }
    }

    @Override
    public Memberships getAllMembersOfGroup(ConnectionFields connectionFields, Group group, PageFields pageFields) throws ServiceException, ResourceException {
        HttpUriRequest request = this.requestBuilder.buildGetAllMembersOfGroupRequest(connectionFields, group.getResourceUniqueId(), pageFields);
        String membershipString = this.httpService.executeServiceOnlyRequest(group, request);
        return this.userBuilder.buildMemberships(membershipString, group, pageFields);
    }

    @Override
    public SaasMembership createMembership(ConnectionFields connectionFields, Membership membership) throws ServiceException, ResourceException {
        HttpUriRequest request = this.requestBuilder.buildCreateMembershipRequest(connectionFields, membership);
        String groupString = this.httpService.executeFullRequest(membership, request);
        return this.userBuilder.buildMembership(groupString, membership);
    }

    @Override
    public void deleteMembership(ConnectionFields connectionFields, Membership membership) throws ServiceException, ResourceException {
        HttpUriRequest request = this.requestBuilder.buildDeleteMembershipRequest(connectionFields, membership);
        this.httpService.executeFullRequest(membership, request);
    }
}

