/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.pingone.saas.wrapper;

import com.pingidentity.io.cpl.pingone.metadata.Attributes;
import com.pingidentity.io.cpl.pingone.metadata.BaseAttribute;
import com.pingidentity.io.cpl.pingone.resource.ResourceAttributes;
import com.pingidentity.io.cpl.pingone.resource.ResourceUniqueId;
import com.pingidentity.io.cpl.pingone.resource.User;
import com.pingidentity.provisioner.integrations.pingone.ResourceFieldKey;
import com.pingidentity.provisioner.integrations.pingone.saas.SaasUser;
import com.pingidentity.provisioner.integrations.pingone.saas.wrapper.ExternalPassword;
import com.pingidentity.provisioner.integrations.pingone.saas.wrapper.PingOneAddress;
import com.pingidentity.provisioner.integrations.pingone.saas.wrapper.PingOneIdp;
import com.pingidentity.provisioner.integrations.pingone.saas.wrapper.PingOneName;
import com.pingidentity.provisioner.integrations.pingone.saas.wrapper.PingOnePassword;
import com.pingidentity.provisioner.integrations.pingone.saas.wrapper.PingOnePhoto;
import com.pingidentity.provisioner.integrations.pingone.saas.wrapper.PingOnePopulation;
import com.pingidentity.provisioner.integrations.pingone.saas.wrapper.UserPassword;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.unboundid.scim2.common.types.UserResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UserProfile
extends UserResource
implements SaasUser {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private boolean enabled;
    private boolean mfaEnabled;
    private String primaryPhone;
    private String mobilePhone;
    private String accountId;
    private String type;
    private String email;
    private String username;
    private String nickname;
    private PingOneName name;
    private PingOneAddress address;
    private PingOnePhoto photo;
    private PingOnePopulation population;
    private UserPassword password;
    private PingOneIdp identityProvider;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public UserProfile() {
    }

    public UserProfile(ResourceAttributes attrs) {
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.ID.getLabel()))) {
            this.setId(attrs.getValueOf(ResourceFieldKey.ID.getLabel()));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.POPULATION_ID.getLabel()))) {
            this.setPopulationId(attrs.getValueOf(ResourceFieldKey.POPULATION_ID.getLabel()));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.ENABLED.getLabel()))) {
            this.setEnabled(Boolean.parseBoolean(attrs.getValueOf(ResourceFieldKey.ENABLED.getLabel())));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.MFA_ENABLED.getLabel()))) {
            this.setMfaEnaled(Boolean.parseBoolean(attrs.getValueOf(ResourceFieldKey.MFA_ENABLED.getLabel())));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.USERNAME.getLabel()))) {
            this.setUsername(attrs.getValueOf(ResourceFieldKey.USERNAME.getLabel()));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.FULL_NAME.getLabel()))) {
            this.setFormattedName(attrs.getValueOf(ResourceFieldKey.FULL_NAME.getLabel()));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.FIRST_NAME.getLabel()))) {
            this.setGivenName(attrs.getValueOf(ResourceFieldKey.FIRST_NAME.getLabel()));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.MIDDLE_NAME.getLabel()))) {
            this.setMiddleName(attrs.getValueOf(ResourceFieldKey.MIDDLE_NAME.getLabel()));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.LAST_NAME.getLabel()))) {
            this.setFamilyName(attrs.getValueOf(ResourceFieldKey.LAST_NAME.getLabel()));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.HONORIFIC_PREFIX.getLabel()))) {
            this.setHonorificPrefix(attrs.getValueOf(ResourceFieldKey.HONORIFIC_PREFIX.getLabel()));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.HONORIFIC_SUFFIX.getLabel()))) {
            this.setHonorificSuffix(attrs.getValueOf(ResourceFieldKey.HONORIFIC_SUFFIX.getLabel()));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.NICKNAME.getLabel()))) {
            this.setNickname(attrs.getValueOf(ResourceFieldKey.NICKNAME.getLabel()));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.JOB_TITLE.getLabel()))) {
            this.setTitle(attrs.getValueOf(ResourceFieldKey.JOB_TITLE.getLabel()));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.PRIMARY_PHONE.getLabel()))) {
            this.setPrimaryPhone(attrs.getValueOf(ResourceFieldKey.PRIMARY_PHONE.getLabel()));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.MOBILE_PHONE.getLabel()))) {
            this.setMobilePhone(attrs.getValueOf(ResourceFieldKey.MOBILE_PHONE.getLabel()));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.STREET_ADDRESS.getLabel()))) {
            this.setStreetAddress(attrs.getValueOf(ResourceFieldKey.STREET_ADDRESS.getLabel()));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.CITY.getLabel()))) {
            this.setLocality(attrs.getValueOf(ResourceFieldKey.CITY.getLabel()));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.STATE_REGION.getLabel()))) {
            this.setRegion(attrs.getValueOf(ResourceFieldKey.STATE_REGION.getLabel()));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.ZIP_CODE.getLabel()))) {
            this.setPostalCode(attrs.getValueOf(ResourceFieldKey.ZIP_CODE.getLabel()));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.COUNTRY.getLabel()))) {
            this.setCountryCode(attrs.getValueOf(ResourceFieldKey.COUNTRY.getLabel()));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.ACCOUNT_ID.getLabel()))) {
            this.setAccountId(attrs.getValueOf(ResourceFieldKey.ACCOUNT_ID.getLabel()));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.USER_TYPE.getLabel()))) {
            this.setType(attrs.getValueOf(ResourceFieldKey.USER_TYPE.getLabel()));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.EXTERNAL_ID.getLabel()))) {
            this.setExternalId(attrs.getValueOf(ResourceFieldKey.EXTERNAL_ID.getLabel()));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.PROFILE_IMAGE.getLabel()))) {
            this.setPhoto(attrs.getValueOf(ResourceFieldKey.PROFILE_IMAGE.getLabel()));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.EMAIL.getLabel()))) {
            this.setEmail(attrs.getValueOf(ResourceFieldKey.EMAIL.getLabel()));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.PREFERRED_LANGUAGE.getLabel()))) {
            this.setPreferredLanguage(attrs.getValueOf(ResourceFieldKey.PREFERRED_LANGUAGE.getLabel()));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.LOCALE.getLabel()))) {
            this.setLocale(attrs.getValueOf(ResourceFieldKey.LOCALE.getLabel()));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.TIMEZONE.getLabel()))) {
            this.setTimezone(attrs.getValueOf(ResourceFieldKey.TIMEZONE.getLabel()));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.PASSWORD.getLabel()))) {
            this.setPasswordValue(attrs.getValueOf(ResourceFieldKey.PASSWORD.getLabel()));
        }
        if (!this.isEmpty(attrs.getValueOf(ResourceFieldKey.FORCE_CHANGE_PASSWORD.getLabel()))) {
            this.setForceChangePassword(Boolean.parseBoolean(attrs.getValueOf(ResourceFieldKey.FORCE_CHANGE_PASSWORD.getLabel())));
        }
    }

    public UserProfile(ResourceAttributes resourceAttributes, Attributes customAttributes) {
        this(resourceAttributes);
        if (null == customAttributes) {
            return;
        }
        for (BaseAttribute customAttribute : customAttributes.values()) {
            String name = customAttribute.getKey();
            List<String> values = resourceAttributes.getAll(name);
            if (values.isEmpty()) continue;
            if (customAttribute.getMaxNumberOfValues() <= 1) {
                String value2 = values.get(0);
                if (this.isEmpty(value2)) continue;
                this.setAdditionalProperty(name, value2);
                continue;
            }
            List<String> multiValues = values.size() <= customAttribute.getMaxNumberOfValues() ? values : values.subList(0, customAttribute.getMaxNumberOfValues());
            if ((multiValues = multiValues.stream().filter(value -> !this.isEmpty((String)value)).collect(Collectors.toList())).isEmpty()) continue;
            this.setAdditionalProperty(name, multiValues);
        }
    }

    @Override
    @JsonIgnore
    public User getCplUser() {
        String idp;
        ResourceAttributes attributes = new ResourceAttributes();
        if (!this.isEmpty(this.getId())) {
            attributes.add(ResourceFieldKey.ID.getLabel(), this.getId());
        }
        if (!this.isEmpty(this.getPopulationId())) {
            attributes.add(ResourceFieldKey.POPULATION_ID.getLabel(), this.getPopulationId());
        }
        if (!this.isEmpty(String.valueOf(this.getEnabled()))) {
            attributes.add(ResourceFieldKey.ENABLED.getLabel(), String.valueOf(this.getEnabled()));
        }
        if (!this.isEmpty(String.valueOf(this.getMfaEnaled()))) {
            attributes.add(ResourceFieldKey.MFA_ENABLED.getLabel(), String.valueOf(this.getMfaEnaled()));
        }
        if (!this.isEmpty(this.getUsername())) {
            attributes.add(ResourceFieldKey.USERNAME.getLabel(), this.getUsername());
        }
        if (!this.isEmpty(this.getFormattedName())) {
            attributes.add(ResourceFieldKey.FULL_NAME.getLabel(), this.getFormattedName());
        }
        if (!this.isEmpty(this.getGivenName())) {
            attributes.add(ResourceFieldKey.FIRST_NAME.getLabel(), this.getGivenName());
        }
        if (!this.isEmpty(this.getMiddleName())) {
            attributes.add(ResourceFieldKey.MIDDLE_NAME.getLabel(), this.getMiddleName());
        }
        if (!this.isEmpty(this.getFamilyName())) {
            attributes.add(ResourceFieldKey.LAST_NAME.getLabel(), this.getFamilyName());
        }
        if (!this.isEmpty(this.getHonorificPrefix())) {
            attributes.add(ResourceFieldKey.HONORIFIC_PREFIX.getLabel(), this.getHonorificPrefix());
        }
        if (!this.isEmpty(this.getHonorificSuffix())) {
            attributes.add(ResourceFieldKey.HONORIFIC_SUFFIX.getLabel(), this.getHonorificSuffix());
        }
        if (!this.isEmpty(this.getNickname())) {
            attributes.add(ResourceFieldKey.NICKNAME.getLabel(), this.getNickname());
        }
        if (!this.isEmpty(this.getTitle())) {
            attributes.add(ResourceFieldKey.JOB_TITLE.getLabel(), this.getTitle());
        }
        if (!this.isEmpty(this.getPrimaryPhone())) {
            attributes.add(ResourceFieldKey.PRIMARY_PHONE.getLabel(), this.getPrimaryPhone());
        }
        if (!this.isEmpty(this.getMobilePhone())) {
            attributes.add(ResourceFieldKey.MOBILE_PHONE.getLabel(), this.getMobilePhone());
        }
        if (!this.isEmpty(this.getStreetAddress())) {
            attributes.add(ResourceFieldKey.STREET_ADDRESS.getLabel(), this.getStreetAddress());
        }
        if (!this.isEmpty(this.getLocality())) {
            attributes.add(ResourceFieldKey.CITY.getLabel(), this.getLocality());
        }
        if (!this.isEmpty(this.getRegion())) {
            attributes.add(ResourceFieldKey.STATE_REGION.getLabel(), this.getRegion());
        }
        if (!this.isEmpty(this.getPostalCode())) {
            attributes.add(ResourceFieldKey.ZIP_CODE.getLabel(), this.getPostalCode());
        }
        if (!this.isEmpty(this.getCountryCode())) {
            attributes.add(ResourceFieldKey.COUNTRY.getLabel(), this.getCountryCode());
        }
        if (!this.isEmpty(this.getAccountId())) {
            attributes.add(ResourceFieldKey.ACCOUNT_ID.getLabel(), this.getAccountId());
        }
        if (!this.isEmpty(this.getType())) {
            attributes.add(ResourceFieldKey.USER_TYPE.getLabel(), this.getType());
        }
        if (!this.isEmpty(this.getExternalId())) {
            attributes.add(ResourceFieldKey.EXTERNAL_ID.getLabel(), this.getExternalId());
        }
        if (!this.isEmpty(this.getPhoto())) {
            attributes.add(ResourceFieldKey.PROFILE_IMAGE.getLabel(), this.getPhoto());
        }
        if (!this.isEmpty(this.getEmail())) {
            attributes.add(ResourceFieldKey.EMAIL.getLabel(), this.getEmail());
        }
        if (!this.isEmpty(this.getPreferredLanguage())) {
            attributes.add(ResourceFieldKey.PREFERRED_LANGUAGE.getLabel(), this.getPreferredLanguage());
        }
        if (!this.isEmpty(this.getLocale())) {
            attributes.add(ResourceFieldKey.LOCALE.getLabel(), this.getLocale());
        }
        if (!this.isEmpty(this.getTimezone())) {
            attributes.add(ResourceFieldKey.TIMEZONE.getLabel(), this.getTimezone());
        }
        if (!this.isEmpty(this.getPasswordValue())) {
            attributes.add(ResourceFieldKey.PASSWORD.getLabel(), this.getPasswordValue());
        }
        if (!this.isEmpty(String.valueOf(this.getForceChangePassword()))) {
            attributes.add(ResourceFieldKey.FORCE_CHANGE_PASSWORD.getLabel(), String.valueOf(this.getForceChangePassword()));
        }
        String string = idp = this.getIdentityProvider() != null ? this.getIdentityProvider().getId() : null;
        if (!this.isEmpty(idp)) {
            attributes.add(ResourceFieldKey.AUTHORITATIVE_IDP.getLabel(), idp);
        }
        if (!this.additionalProperties.isEmpty()) {
            for (Map.Entry<String, Object> e : this.additionalProperties.entrySet()) {
                if (e.getValue() instanceof String) {
                    attributes.add(e.getKey(), (String)e.getValue());
                    continue;
                }
                if (!(e.getValue() instanceof List)) continue;
                attributes.add(e.getKey(), (List)e.getValue());
            }
        }
        User cplUser = new User(attributes, new ResourceUniqueId(this.getId()));
        return cplUser;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    public void setEmail(String email) {
        this.email = email;
    }

    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    public void setUsername(String username) {
        this.username = username;
    }

    @JsonProperty(value="nickname")
    public String getNickname() {
        return this.nickname;
    }

    @JsonProperty(value="nickname")
    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    @JsonProperty(value="name")
    public PingOneName getPingOneName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setPingOneName(PingOneName name) {
        this.name = name;
    }

    @JsonProperty(value="address")
    public PingOneAddress getPingOneAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    public void setPingOneAddress(PingOneAddress address) {
        this.address = address;
    }

    @JsonProperty(value="photo")
    public PingOnePhoto getPingOnePhoto() {
        return this.photo;
    }

    @JsonProperty(value="photo")
    public void setPingOnePhoto(PingOnePhoto photo) {
        this.photo = photo;
    }

    @JsonProperty(value="population")
    public PingOnePopulation getPingOnePopulation() {
        return this.population;
    }

    @JsonProperty(value="population")
    public void setPingOnePopulation(PingOnePopulation population) {
        this.population = population;
    }

    @JsonIgnore
    public PingOnePassword getPingOnePassword() {
        if (this.password instanceof PingOnePassword) {
            return (PingOnePassword)this.password;
        }
        return null;
    }

    @JsonProperty(value="password")
    public UserPassword getUserPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    public void setUserPassword(UserPassword userPassword) {
        this.password = userPassword;
    }

    public void setPingOnePassword(PingOnePassword password) {
        this.setUserPassword(password);
    }

    @JsonIgnore
    public String getGivenName() {
        if (this.getPingOneName() != null) {
            return this.getPingOneName().getGiven();
        }
        return null;
    }

    public void setGivenName(String givenName) {
        this.checkName();
        this.getPingOneName().setGiven(givenName);
    }

    @JsonIgnore
    public String getFamilyName() {
        if (this.getPingOneName() != null) {
            return this.getPingOneName().getFamily();
        }
        return null;
    }

    public void setFamilyName(String familyName) {
        this.checkName();
        this.getPingOneName().setFamily(familyName);
    }

    @JsonIgnore
    public String getMiddleName() {
        if (this.getPingOneName() != null) {
            return this.getPingOneName().getMiddle();
        }
        return null;
    }

    public void setMiddleName(String middleName) {
        this.checkName();
        this.getPingOneName().setMiddle(middleName);
    }

    @JsonIgnore
    public String getHonorificPrefix() {
        if (this.getPingOneName() != null) {
            return this.getPingOneName().getHonorificPrefix();
        }
        return null;
    }

    public void setHonorificPrefix(String honorificPrefix) {
        this.checkName();
        this.getPingOneName().setHonorificPrefix(honorificPrefix);
    }

    @JsonIgnore
    public String getHonorificSuffix() {
        if (this.getPingOneName() != null) {
            return this.getPingOneName().getHonorificSuffix();
        }
        return null;
    }

    public void setHonorificSuffix(String honorificSuffix) {
        this.checkName();
        this.getPingOneName().setHonorificSuffix(honorificSuffix);
    }

    @JsonIgnore
    public String getFormattedName() {
        if (this.getPingOneName() != null) {
            return this.getPingOneName().getFormatted();
        }
        return null;
    }

    public void setFormattedName(String formattedName) {
        this.checkName();
        this.getPingOneName().setFormatted(formattedName);
    }

    @JsonIgnore
    public String getStreetAddress() {
        if (this.getPingOneAddress() != null) {
            return this.getPingOneAddress().getStreetAddress();
        }
        return null;
    }

    public void setStreetAddress(String streetAddress) {
        this.checkAddress();
        this.getPingOneAddress().setStreetAddress(streetAddress);
    }

    @JsonIgnore
    public String getLocality() {
        if (this.getPingOneAddress() != null) {
            return this.getPingOneAddress().getLocality();
        }
        return null;
    }

    public void setLocality(String locality) {
        this.checkAddress();
        this.getPingOneAddress().setLocality(locality);
    }

    @JsonIgnore
    public String getRegion() {
        if (this.getPingOneAddress() != null) {
            return this.getPingOneAddress().getRegion();
        }
        return null;
    }

    public void setRegion(String region) {
        this.checkAddress();
        this.getPingOneAddress().setRegion(region);
    }

    @JsonIgnore
    public String getPostalCode() {
        if (this.getPingOneAddress() != null) {
            return this.getPingOneAddress().getPostalCode();
        }
        return null;
    }

    public void setPostalCode(String postalCode) {
        this.checkAddress();
        this.getPingOneAddress().setPostalCode(postalCode);
    }

    @JsonIgnore
    public String getCountryCode() {
        if (this.getPingOneAddress() != null) {
            return this.getPingOneAddress().getCountryCode();
        }
        return null;
    }

    public void setCountryCode(String countryCode) {
        this.checkAddress();
        this.getPingOneAddress().setCountryCode(countryCode);
    }

    @JsonIgnore
    public String getPhoto() {
        if (this.getPingOnePhoto() != null) {
            return this.getPingOnePhoto().getHref();
        }
        return null;
    }

    public void setPhoto(String photo) {
        this.checkPhoto();
        this.getPingOnePhoto().setHref(photo);
    }

    @JsonIgnore
    public String getPopulationId() {
        if (this.getPingOnePopulation() != null) {
            return this.getPingOnePopulation().getId();
        }
        return null;
    }

    public void setPopulationId(String populationId) {
        this.checkPopulation();
        this.getPingOnePopulation().setId(populationId);
    }

    @JsonIgnore
    public String getPasswordValue() {
        if (this.getUserPassword() != null) {
            return this.getPingOnePassword().getValue();
        }
        return null;
    }

    public void setPasswordValue(String password) {
        try {
            Map map = MAPPER.readValue(password, Map.class);
            if (map.containsKey("external")) {
                this.setUserPassword(new ExternalPassword(map.get("external")));
            } else {
                this.checkPassword();
                this.getPingOnePassword().setValue(password);
            }
        }
        catch (Exception exception) {
            this.checkPassword();
            this.getPingOnePassword().setValue(password);
        }
    }

    @JsonIgnore
    public boolean getForceChangePassword() {
        if (this.getPingOnePassword() != null) {
            return this.getPingOnePassword().getForceChange();
        }
        return false;
    }

    public void setForceChangePassword(boolean forceChange) {
        this.checkPassword();
        if (this.password instanceof PingOnePassword) {
            this.getPingOnePassword().setForceChange(forceChange);
        }
    }

    @JsonProperty(value="primaryPhone")
    public String getPrimaryPhone() {
        return this.primaryPhone;
    }

    @JsonProperty(value="primaryPhone")
    public void setPrimaryPhone(String primaryPhone) {
        this.primaryPhone = primaryPhone;
    }

    @JsonProperty(value="mobilePhone")
    public String getMobilePhone() {
        return this.mobilePhone;
    }

    @JsonProperty(value="mobilePhone")
    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    @JsonProperty(value="accountId")
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty(value="accountId")
    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="enabled")
    public boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @JsonProperty(value="mfaEnabled")
    public boolean getMfaEnaled() {
        return this.mfaEnabled;
    }

    @JsonProperty(value="mfaEnabled")
    public void setMfaEnaled(boolean mfaEnabled) {
        this.mfaEnabled = mfaEnabled;
    }

    public PingOneIdp getIdentityProvider() {
        return this.identityProvider;
    }

    public void setIdentityProvider(PingOneIdp identityProvider) {
        this.identityProvider = identityProvider;
    }

    @Override
    @JsonAnyGetter(enabled=false)
    protected Map<String, Object> getAny() {
        return null;
    }

    @Override
    @JsonAnySetter(enabled=false)
    protected void setAny(String key, JsonNode value) {
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    private void checkPhoto() {
        if (this.getPingOnePhoto() == null) {
            PingOnePhoto photo = new PingOnePhoto();
            this.setPingOnePhoto(photo);
        }
    }

    private void checkName() {
        if (this.getPingOneName() == null) {
            PingOneName name = new PingOneName();
            this.setPingOneName(name);
        }
    }

    private void checkAddress() {
        if (this.getPingOneAddress() == null) {
            PingOneAddress address = new PingOneAddress();
            this.setPingOneAddress(address);
        }
    }

    private void checkPopulation() {
        if (this.getPingOnePopulation() == null) {
            PingOnePopulation population = new PingOnePopulation();
            this.setPingOnePopulation(population);
        }
    }

    private void checkPassword() {
        if (this.getUserPassword() == null) {
            PingOnePassword password = new PingOnePassword();
            this.setUserPassword(password);
        }
    }

    private boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }
}

